/*
 * Decompiled with CFR 0.152.
 */
package org.orangepalantir.filters;

import Jama.LUDecomposition;
import Jama.Matrix;

public class SavitzyGolayFilter {
    double[] coefficients;
    int LEFT;
    int RIGHT;
    int ORDER;

    public SavitzyGolayFilter(int left, int right, int order) {
        this.coefficients = SavitzyGolayFilter.SavitzkyGolayCoefficients(left, right, order);
        this.LEFT = left;
        this.RIGHT = right;
        this.ORDER = order;
    }

    public SavitzyGolayFilter(int left, int right, int order, int derivative) {
        this.coefficients = SavitzyGolayFilter.SavitzkyGolayCoefficients(left, right, order, derivative);
        this.LEFT = left;
        this.RIGHT = right;
        this.ORDER = order;
    }

    public double[] filterData(double[] data) {
        int j;
        int pts = data.length;
        double[] ret_value = new double[pts];
        for (j = 0; j < this.LEFT; ++j) {
            ret_value[j] = this.rFilter(data, this.coefficients, j, this.LEFT);
        }
        for (j = this.LEFT; j < pts - this.RIGHT; ++j) {
            ret_value[j] = this.filter(data, this.coefficients, j, this.LEFT);
        }
        for (j = pts - this.RIGHT; j < pts; ++j) {
            ret_value[j] = this.rFilter(data, this.coefficients, j, this.LEFT);
        }
        return ret_value;
    }

    public float[] filterData(float[] data) {
        int j;
        int pts = data.length;
        float[] ret_value = new float[pts];
        for (j = 0; j < this.LEFT; ++j) {
            ret_value[j] = this.rFilter(data, this.coefficients, j, this.LEFT);
        }
        for (j = this.LEFT; j < pts - this.RIGHT; ++j) {
            ret_value[j] = this.filter(data, this.coefficients, j, this.LEFT);
        }
        for (j = pts - this.RIGHT; j < pts; ++j) {
            ret_value[j] = this.rFilter(data, this.coefficients, j, this.LEFT);
        }
        return ret_value;
    }

    public float filter(float[] o, double[] mask, int start, int middle) {
        float out = 0.0f;
        for (int i = 0; i < mask.length; ++i) {
            out += (float)mask[i] * o[start - middle + i];
        }
        return out;
    }

    public double filter(double[] o, double[] mask, int start, int middle) {
        double out = 0.0;
        for (int i = 0; i < mask.length; ++i) {
            out += mask[i] * o[start - middle + i];
        }
        return out;
    }

    public double rFilter(double[] o, double[] mask, int start, int middle) {
        double out = 0.0;
        for (int i = 0; i < mask.length; ++i) {
            int dex = Math.abs(start - middle + 1 + i);
            dex = dex < o.length ? dex : 2 * o.length - dex - 1;
            out += mask[i] * o[dex];
        }
        return out;
    }

    public float rFilter(float[] o, double[] mask, int start, int middle) {
        double out = 0.0;
        for (int i = 0; i < mask.length; ++i) {
            int dex = Math.abs(start - middle + 1 + i);
            dex = dex < o.length ? dex : 2 * o.length - dex - 1;
            out += mask[i] * (double)o[dex];
        }
        return (float)out;
    }

    public static double[] SavitzkyGolayCoefficients(int nl, int nr, int order) {
        if (nl + nr + 1 <= order) {
            throw new IllegalArgumentException(" The order of polynomial cannot exceed the number of points being used.If they are equal the input equals the output.");
        }
        int N = nr + nl + 1;
        double[] ret_values = new double[N];
        double[] xvalues = new double[N];
        for (int i = 0; i < N; ++i) {
            xvalues[i] = -nl + i;
        }
        int counts = 2 * order + 1;
        double[] moments = new double[counts];
        for (int i = 0; i < counts; ++i) {
            for (int j = 0; j < N; ++j) {
                int n = i;
                moments[n] = moments[n] + Math.pow(xvalues[j], i);
            }
            moments[i] = moments[i] / (double)N;
        }
        double[][] matrix = new double[order + 1][order + 1];
        for (int i = 0; i < order + 1; ++i) {
            for (int j = 0; j < order + 1; ++j) {
                matrix[i][j] = moments[counts - i - j - 1];
            }
            System.out.println("");
        }
        Matrix A = new Matrix(matrix);
        LUDecomposition lu = A.lu();
        Matrix x = new Matrix(new double[order + 1], order + 1);
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < order + 1; ++j) {
                x.set(j, 0, Math.pow(xvalues[i], order - j));
            }
            Matrix y = lu.solve(x);
            double[] polynomial = y.getColumnPackedCopy();
            ret_values[i] = SavitzyGolayFilter.evaluatePolynomial(polynomial, xvalues[nl]) / (double)N;
        }
        return ret_values;
    }

    public static double[] SavitzkyGolayCoefficients(int nl, int nr, int order, int derivative) {
        if (nl + nr + 1 <= order) {
            throw new IllegalArgumentException(" The order of polynomial cannot exceed the number of points being used.If they are equal the input equals the output.");
        }
        int N = nr + nl + 1;
        double[] ret_values = new double[N];
        double[] xvalues = new double[N];
        for (int i = 0; i < N; ++i) {
            xvalues[i] = -nl + i;
        }
        int counts = 2 * order + 1;
        double[] moments = new double[counts];
        for (int i = 0; i < counts; ++i) {
            for (int j = 0; j < N; ++j) {
                int n = i;
                moments[n] = moments[n] + Math.pow(xvalues[j], i);
            }
            moments[i] = moments[i] / (double)N;
        }
        double[][] matrix = new double[order + 1][order + 1];
        for (int i = 0; i < order + 1; ++i) {
            for (int j = 0; j < order + 1; ++j) {
                matrix[i][j] = moments[counts - i - j - 1];
            }
            System.out.println("");
        }
        Matrix A = new Matrix(matrix);
        LUDecomposition lu = A.lu();
        Matrix x = new Matrix(new double[order + 1], order + 1);
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < order + 1; ++j) {
                x.set(j, 0, Math.pow(xvalues[i], order - j));
            }
            Matrix y = lu.solve(x);
            double[] polynomial = y.getColumnPackedCopy();
            ret_values[i] = SavitzyGolayFilter.evaluatePolynomial(polynomial, xvalues[nl], derivative) / (double)N;
        }
        return ret_values;
    }

    public static double[][] getKernel(int size, int order) {
        int N = 2 * size + 1;
        double[][] xyvalues = new double[N][2];
        for (int i = 0; i < N; ++i) {
            xyvalues[i][0] = i - size;
            xyvalues[i][1] = i - size;
        }
        int M = 0;
        for (int i = 1; i <= order + 1; ++i) {
            M += i;
        }
        double[][] matrix = new double[M][M];
        int pqdex = 0;
        int mndex = 0;
        for (int p = 0; p <= order; ++p) {
            for (int q = 0; q <= order - p; ++q) {
                mndex = 0;
                for (int m = 0; m <= order; ++m) {
                    for (int n = 0; n <= order - m; ++n) {
                        double sum = 0.0;
                        for (int i = 0; i < N; ++i) {
                            for (int j = 0; j < N; ++j) {
                                sum += Math.pow(xyvalues[i][0], p + m) * Math.pow(xyvalues[j][1], q + n);
                            }
                        }
                        matrix[pqdex][mndex] = sum;
                        ++mndex;
                    }
                }
                ++pqdex;
            }
        }
        Matrix mat = new Matrix(matrix);
        LUDecomposition lud = mat.lu();
        double[][] kernel = new double[N][N];
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                double[] equals = new double[M];
                int xp = 0;
                int yp = 0;
                for (int k = 0; k < M; ++k) {
                    equals[k] = Math.pow(xyvalues[i][0], xp) * Math.pow(xyvalues[j][1], yp);
                    if (++yp <= order - xp) continue;
                    yp = 0;
                    ++xp;
                }
                Matrix rs = new Matrix(equals, M);
                Matrix ls = lud.solve(rs);
                double sum = 0.0;
                xp = 0;
                yp = 0;
                for (int k = 0; k < M; ++k) {
                    sum += ls.get(k, 0) * Math.pow(xyvalues[size][0], xp) * Math.pow(xyvalues[size][1], yp);
                    if (++yp <= order - xp) continue;
                    yp = 0;
                    ++xp;
                }
                kernel[j][i] = sum;
            }
        }
        return kernel;
    }

    public static double evaluatePolynomial(double[] poly, double x) {
        double val = 0.0;
        int m = poly.length;
        for (int j = 0; j < m; ++j) {
            val += Math.pow(x, m - j - 1) * poly[j];
        }
        return val;
    }

    public static double evaluatePolynomial(double[] poly, double x, int order) {
        double val = 0.0;
        int m = poly.length;
        for (int j = 0; j < m - order; ++j) {
            int pow = m - j - 1;
            val += Math.pow(x, pow - order) * poly[j] * SavitzyGolayFilter.pfact(pow, order);
        }
        return val;
    }

    public static double pfact(int m, int n) {
        int p = 1;
        for (int i = 0; i < n; ++i) {
            p *= m - i;
        }
        return p;
    }
}

