/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.utility;

import java.util.Arrays;
import net.imglib2.AbstractWrappedInterval;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Point;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converter;
import net.imglib2.type.numeric.NumericType;

public class OuterProductView<T, U, V extends NumericType<V>>
extends AbstractWrappedInterval<FinalInterval>
implements RandomAccessibleInterval<V> {
    private static final int N_DIM = 2;
    private final RandomAccessibleInterval<T> vec1;
    private final RandomAccessibleInterval<U> vec2;
    private final Converter<T, V> c1;
    private final Converter<U, V> c2;
    private final V v;
    private final long[] dim;
    private final long[] max;
    private final long[] min;

    public OuterProductView(RandomAccessibleInterval<T> vec1, RandomAccessibleInterval<U> vec2, Converter<T, V> c1, Converter<U, V> c2, V v) {
        super((Interval)new FinalInterval(new long[]{vec2.dimension(0), vec1.dimension(0)}));
        this.vec1 = vec1;
        this.vec2 = vec2;
        this.c1 = c1;
        this.c2 = c2;
        this.v = (NumericType)v.createVariable();
        this.dim = new long[]{vec2.dimension(0), vec1.dimension(0)};
        this.max = Arrays.stream(this.dim).map(l -> l - 1L).toArray();
        this.min = new long[2];
    }

    public RandomAccess<V> randomAccess() {
        return new OuterProductAccess();
    }

    public RandomAccess<V> randomAccess(Interval interval) {
        return this.randomAccess();
    }

    public class OuterProductAccess
    extends Point
    implements RandomAccess<V> {
        private final RandomAccess<T> a1;
        private final RandomAccess<U> a2;
        private final V v1;
        private final V v2;

        private OuterProductAccess() {
            super(2);
            this.a1 = OuterProductView.this.vec1.randomAccess();
            this.a2 = OuterProductView.this.vec2.randomAccess();
            this.v1 = (NumericType)OuterProductView.this.v.createVariable();
            this.v2 = (NumericType)OuterProductView.this.v.createVariable();
        }

        private OuterProductAccess(OuterProductAccess other) {
            super((long[])other.position.clone());
            this.a1 = other.a1.copyRandomAccess();
            this.a2 = other.a2.copyRandomAccess();
            this.v1 = (NumericType)other.v1.copy();
            this.v2 = (NumericType)other.v2.copy();
        }

        public V get() {
            this.a1.setPosition(this.position[1], 0);
            this.a2.setPosition(this.position[0], 0);
            OuterProductView.this.c1.convert(this.a1.get(), this.v1);
            OuterProductView.this.c2.convert(this.a2.get(), this.v2);
            this.v1.mul(this.v2);
            return this.v1;
        }

        public OuterProductAccess copy() {
            return this.copyRandomAccess();
        }

        public OuterProductAccess copyRandomAccess() {
            return new OuterProductAccess(this);
        }
    }
}

