/*
 * Decompiled with CFR 0.152.
 */
package itc.utilities;

import java.util.Arrays;
import java.util.stream.DoubleStream;
import net.imglib2.FinalInterval;
import net.imglib2.FinalRealInterval;
import net.imglib2.Interval;
import net.imglib2.RealInterval;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.Scale;
import net.imglib2.realtransform.Scale3D;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.RotationConvention;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;

public class TransformUtils {
    public static FinalRealInterval transformRealInterval(RealInterval interval, RealTransform xfm) {
        int d;
        int nd = interval.numDimensions();
        double[] pt = new double[nd];
        double[] min = new double[nd];
        double[] max = new double[nd];
        for (d = 0; d < nd; ++d) {
            pt[d] = interval.realMin(d);
        }
        xfm.apply(pt, min);
        for (d = 0; d < nd; ++d) {
            pt[d] = interval.realMax(d);
        }
        xfm.apply(pt, max);
        return new FinalRealInterval(min, max);
    }

    public static AffineTransform3D scaleAffineTransform3DUnits(AffineTransform3D transform, double[] scale) {
        AffineTransform3D scaledTransform = transform.copy();
        double[] inverse = Arrays.stream(scale).map(x -> 1.0 / x).toArray();
        scaledTransform = scaledTransform.concatenate((AffineGet)new Scale(inverse));
        scaledTransform = scaledTransform.preConcatenate((AffineGet)new Scale(scale));
        return scaledTransform;
    }

    public static FinalInterval transformRealIntervalExpand(RealInterval interval, RealTransform xfm) {
        int nd = interval.numDimensions();
        FinalRealInterval realTransformedInterval = TransformUtils.transformRealInterval(interval, xfm);
        long[] min = new long[nd];
        long[] max = new long[nd];
        for (int i = 0; i < nd; ++i) {
            min[i] = (long)Math.floor(realTransformedInterval.realMin(i));
            max[i] = (long)Math.ceil(realTransformedInterval.realMax(i));
        }
        return new FinalInterval(min, max);
    }

    public static FinalInterval transformInterval(Interval interval, RealTransform xfm) {
        int d;
        int nd = interval.numDimensions();
        double[] pt = new double[nd];
        double[] ptxfm = new double[nd];
        long[] min = new long[nd];
        long[] max = new long[nd];
        for (d = 0; d < nd; ++d) {
            pt[d] = interval.min(d);
        }
        xfm.apply(pt, ptxfm);
        TransformUtils.copyToLongFloor(ptxfm, min);
        for (d = 0; d < nd; ++d) {
            pt[d] = interval.max(d);
        }
        xfm.apply(pt, ptxfm);
        TransformUtils.copyToLongCeil(ptxfm, max);
        return new FinalInterval(min, max);
    }

    public static void copyToLongFloor(double[] src, long[] dst) {
        for (int d = 0; d < src.length; ++d) {
            dst[d] = (long)Math.floor(src[d]);
        }
    }

    public static void copyToLongCeil(double[] src, long[] dst) {
        for (int d = 0; d < src.length; ++d) {
            dst[d] = (long)Math.ceil(src[d]);
        }
    }

    public static Scale3D getScaleTransform3D(double ... spacing) {
        assert (spacing.length == 3) : "Input dimensions do not match or are not 3.";
        return new Scale3D(spacing);
    }

    public static Scale3D getPhysicalToPixelScaleTransform3D(double ... spacing) {
        assert (spacing.length == 3) : "Input dimensions do not match or are not 3.";
        return new Scale3D(DoubleStream.of(spacing).map(s -> 1.0 / s).toArray());
    }

    public static double[][] rotationMatrix(Vector3D axis, double angle) {
        Rotation rotation = new Rotation(axis, angle, RotationConvention.VECTOR_OPERATOR);
        double[][] matrix = rotation.getMatrix();
        return matrix;
    }

    public static AffineTransform3D scaleAffineTransform3D(AffineTransform3D transform, double[] scale) {
        AffineTransform3D scaledTransform = transform.copy();
        transform.concatenate((AffineGet)new Scale(scale));
        double[] translation = transform.getTranslation();
        for (int d = 0; d < 3; ++d) {
            int n = d;
            translation[n] = translation[n] * scale[d];
        }
        transform.setTranslation(translation);
        return transform;
    }

    public static AffineTransform3D rotationAffineTransform3D(double[][] rotationMatrix) {
        AffineTransform3D rotationTransform = new AffineTransform3D();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                rotationTransform.set(rotationMatrix[row][col], row, col);
            }
        }
        return rotationTransform;
    }

    public static AffineTransform3D rotationAroundImageCenterTransform(double[][] rotation, double[] rotationCenter) {
        AffineTransform3D rotationTransform = TransformUtils.rotationAffineTransform3D(rotation);
        double[] translationFromCenterToOrigin = new double[3];
        double[] translationFromOriginToCenter = new double[3];
        for (int d = 0; d < 3; ++d) {
            translationFromCenterToOrigin[d] = -rotationCenter[d];
            translationFromOriginToCenter[d] = rotationCenter[d];
        }
        AffineTransform3D rotationAroundCenterTransform = new AffineTransform3D();
        rotationAroundCenterTransform.translate(translationFromCenterToOrigin);
        rotationAroundCenterTransform.preConcatenate(rotationTransform);
        AffineTransform3D transformOriginToCenter = new AffineTransform3D();
        transformOriginToCenter.translate(translationFromOriginToCenter);
        rotationAroundCenterTransform.preConcatenate(transformOriginToCenter);
        return rotationAroundCenterTransform;
    }

    public static String asStringBdvStyle(AffineTransform3D affineTransform3D) {
        String out = "";
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 4; ++col) {
                out = out + String.format("%.4f", affineTransform3D.get(row, col)) + " ";
            }
        }
        return out;
    }
}

