/*
 * Decompiled with CFR 0.152.
 */
package itc.utilities;

import java.util.Arrays;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.FinalRealInterval;
import net.imglib2.Interval;
import net.imglib2.RealInterval;
import net.imglib2.util.Intervals;

public class IntervalUtils {
    public static RealInterval toCalibratedRealInterval(Interval interval, double voxelSpacing) {
        double[] calibrations = new double[interval.numDimensions()];
        Arrays.fill(calibrations, voxelSpacing);
        return IntervalUtils.toCalibratedRealInterval(interval, calibrations);
    }

    public static RealInterval toCalibratedRealInterval(Interval interval, double[] voxelSpacings) {
        double[] min = Intervals.minAsDoubleArray((RealInterval)interval);
        double[] max = Intervals.maxAsDoubleArray((RealInterval)interval);
        int numDimensions = min.length;
        for (int d = 0; d < numDimensions; ++d) {
            int n = d;
            min[n] = min[n] * voxelSpacings[d];
            int n2 = d;
            max[n2] = max[n2] * voxelSpacings[d];
        }
        return new FinalRealInterval(min, max);
    }

    public static RealInterval toCalibratedRealInterval(Interval interval, VoxelDimensions voxelDimensions) {
        double[] min = Intervals.minAsDoubleArray((RealInterval)interval);
        double[] max = Intervals.maxAsDoubleArray((RealInterval)interval);
        int numDimensions = min.length;
        for (int d = 0; d < numDimensions; ++d) {
            int n = d;
            min[n] = min[n] * voxelDimensions.dimension(d);
            int n2 = d;
            max[n2] = max[n2] * voxelDimensions.dimension(d);
        }
        return new FinalRealInterval(min, max);
    }

    public static RealInterval scale(RealInterval realInterval, double scale) {
        double[] scales = new double[realInterval.numDimensions()];
        Arrays.fill(scales, scale);
        return IntervalUtils.scale(realInterval, scales);
    }

    public static RealInterval scale(RealInterval realInterval, double[] scale) {
        double[] min = Intervals.minAsDoubleArray((RealInterval)realInterval);
        double[] max = Intervals.maxAsDoubleArray((RealInterval)realInterval);
        int numDimensions = min.length;
        for (int d = 0; d < numDimensions; ++d) {
            int n = d;
            min[n] = min[n] * scale[d];
            int n2 = d;
            max[n2] = max[n2] * scale[d];
        }
        return new FinalRealInterval(min, max);
    }

    public static String toString(RealInterval realInterval) {
        int d;
        int n = realInterval.numDimensions();
        double[] min = Intervals.minAsDoubleArray((RealInterval)realInterval);
        double[] max = Intervals.maxAsDoubleArray((RealInterval)realInterval);
        StringBuilder sb = new StringBuilder();
        String className = realInterval.getClass().getSimpleName();
        sb.append(" (");
        for (d = 0; d < n; ++d) {
            sb.append(min[d]);
            if (d >= n - 1) continue;
            sb.append(", ");
        }
        sb.append(") -- (");
        for (d = 0; d < n; ++d) {
            sb.append(max[d]);
            if (d >= n - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }
}

