/*
 * Decompiled with CFR 0.152.
 */
package itc.utilities;

import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.util.Grids;
import net.imglib2.img.AbstractImg;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class CopyUtils {
    public static <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> copyAsArrayImg(RandomAccessibleInterval<T> orig) {
        ArrayImg arrayImg = new ArrayImgFactory((NativeType)Util.getTypeFromInterval(orig)).create(orig);
        IntervalView copy = Views.translate((RandomAccessibleInterval)arrayImg, (long[])Intervals.minAsLongArray(orig));
        LoopBuilder.setImages((RandomAccessibleInterval)copy, orig).forEachPixel((rec$, x$0) -> ((Type)rec$).set((Type)x$0));
        return copy;
    }

    public static <R extends RealType<R> & NativeType<R>> RandomAccessibleInterval<R> copyVolumeRaiMultiThreaded(RandomAccessibleInterval<R> volume, int numThreads) {
        ArrayImg copy;
        int dimensionX = (int)volume.dimension(0);
        int dimensionY = (int)volume.dimension(1);
        int dimensionZ = (int)volume.dimension(2);
        long numElements = AbstractImg.numElements((long[])Intervals.dimensionsAsLongArray(volume));
        if (numElements < 0x7FFFFFFEL) {
            copy = new ArrayImgFactory((NativeType)Util.getTypeFromInterval(volume)).create(volume);
        } else {
            int cellSizeZ = (int)(0x7FFFFFFEL / (volume.dimension(0) * volume.dimension(1)));
            int[] cellSize = new int[]{dimensionX, dimensionY, cellSizeZ};
            copy = new CellImgFactory((NativeType)Util.getTypeFromInterval(volume), cellSize).create(volume);
        }
        int[] blockSize = new int[]{dimensionX, dimensionY, (int)Math.ceil(1.0 * (double)dimensionZ / (double)numThreads)};
        Grids.collectAllContainedIntervals((long[])Intervals.dimensionsAsLongArray(volume), (int[])blockSize).parallelStream().forEach(arg_0 -> CopyUtils.lambda$copyVolumeRaiMultiThreaded$1(volume, (RandomAccessibleInterval)copy, arg_0));
        return copy;
    }

    public static <R extends RealType<R> & NativeType<R>> RandomAccessibleInterval<R> copyPlanarRaiMultiThreaded(RandomAccessibleInterval<R> volume, int numThreads) {
        ArrayImg copy;
        int dimensionX = (int)volume.dimension(0);
        int dimensionY = (int)volume.dimension(1);
        long numElements = AbstractImg.numElements((long[])Intervals.dimensionsAsLongArray(volume));
        if (numElements < 0x7FFFFFFEL) {
            copy = new ArrayImgFactory((NativeType)Util.getTypeFromInterval(volume)).create(volume);
        } else {
            int[] cellSize = new int[]{dimensionX, dimensionY};
            copy = new CellImgFactory((NativeType)Util.getTypeFromInterval(volume), cellSize).create(volume);
        }
        int[] blockSize = new int[]{dimensionX, (int)Math.ceil(dimensionY / numThreads)};
        Grids.collectAllContainedIntervals((long[])Intervals.dimensionsAsLongArray(volume), (int[])blockSize).parallelStream().forEach(arg_0 -> CopyUtils.lambda$copyPlanarRaiMultiThreaded$2(volume, (RandomAccessibleInterval)copy, arg_0));
        return copy;
    }

    private static <T extends Type<T>> void copy(RandomAccessible<T> source, IterableInterval<T> target) {
        Cursor targetCursor = target.localizingCursor();
        RandomAccess sourceRandomAccess = source.randomAccess();
        while (targetCursor.hasNext()) {
            targetCursor.fwd();
            sourceRandomAccess.setPosition((Localizable)targetCursor);
            ((Type)targetCursor.get()).set((Type)sourceRandomAccess.get());
        }
    }

    private static /* synthetic */ void lambda$copyPlanarRaiMultiThreaded$2(RandomAccessibleInterval volume, RandomAccessibleInterval copy, Interval interval) {
        CopyUtils.copy(volume, Views.interval((RandomAccessible)copy, (Interval)interval));
    }

    private static /* synthetic */ void lambda$copyVolumeRaiMultiThreaded$1(RandomAccessibleInterval volume, RandomAccessibleInterval copy, Interval interval) {
        CopyUtils.copy(volume, Views.interval((RandomAccessible)copy, (Interval)interval));
    }
}

