/*
 * Decompiled with CFR 0.152.
 */
package itc.transforms.elastix;

import itc.transforms.elastix.ElastixAffineTransform;
import itc.transforms.elastix.ElastixAffineTransform2D;
import itc.transforms.elastix.ElastixAffineTransform3D;
import itc.transforms.elastix.ElastixBSplineTransform;
import itc.transforms.elastix.ElastixBSplineTransform2D;
import itc.transforms.elastix.ElastixBSplineTransform3D;
import itc.transforms.elastix.ElastixEulerTransform;
import itc.transforms.elastix.ElastixEulerTransform2D;
import itc.transforms.elastix.ElastixEulerTransform3D;
import itc.transforms.elastix.ElastixSimilarityTransform;
import itc.transforms.elastix.ElastixSimilarityTransform2D;
import itc.transforms.elastix.ElastixSimilarityTransform3D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.scijava.plugin.Parameter;

public class ElastixTransform {
    public static final String EULER_TRANSFORM = "EulerTransform";
    public static final String AFFINE_TRANSFORM = "AffineTransform";
    public static final String BSPLINE_TRANSFORM = "BSplineTransform";
    public static final String SIMILARITY_TRANSFORM = "SimilarityTransform";
    public static final String TRANSLATION_TRANSFORM = "TranslationTransform";
    public static final String SPLINE_KERNEL_TRANSFORM = "SplineKernelTransform";
    public static final String DEFAULT_RESAMPLER = "DefaultResampler";
    public static final String RESULT_IMAGE_FORMAT_MHD = "mhd";
    public static final String RESULT_IMAGE_PIXEL_TYPE_UNSIGNED_CHAR = "unsigned char";
    public static final String RESULT_IMAGE_PIXEL_TYPE_UNSIGNED_SHORT = "unsigned short";
    public static final String FINAL_LINEAR_INTERPOLATOR = "FinalLinearInterpolator";
    public static final String FINAL_NEAREST_NEIGHBOR_INTERPOLATOR = "FinalNearestNeighborInterpolator";
    @Parameter
    public String Transform;
    @Parameter
    public Integer NumberOfParameters;
    @Parameter
    public Double[] TransformParameters;
    @Parameter
    public String InitialTransformParametersFileName;
    @Parameter
    public String HowToCombineTransforms;
    @Parameter
    public Integer FixedImageDimension;
    @Parameter
    public Integer MovingImageDimension;
    @Parameter
    public String FixedInternalImagePixelType;
    @Parameter
    public String MovingInternalImagePixelType;
    @Parameter
    public Integer[] Size;
    @Parameter
    public Integer[] Index;
    @Parameter
    public Double[] Spacing;
    @Parameter
    public Double[] Origin;
    @Parameter
    public Double[] Direction;
    @Parameter
    public Boolean UseDirectionCosines;
    @Parameter
    public String ResampleInterpolator;
    @Parameter
    public Integer FinalBSplineInterpolationOrder;
    @Parameter
    public String Resampler;
    @Parameter
    public Double DefaultPixelValue;
    @Parameter
    public String ResultImageFormat;
    @Parameter
    public String ResultImagePixelType;
    @Parameter
    public Boolean CompressResultImage;
    @Parameter
    public Boolean UseBinaryFormatForTransformationParameters;
    @Parameter
    public String InitialTransformParameterFileName;

    public String toString() {
        String str = "";
        Field[] fields = this.getClass().getFields();
        try {
            block18: for (int i = 0; i < fields.length; ++i) {
                Field f = fields[i];
                if (f.get(this) == null || !f.isAnnotationPresent(Parameter.class)) continue;
                switch (f.getType().getSimpleName()) {
                    case "String": 
                    case "Boolean": {
                        str = str + "(" + f.getName() + " \"" + f.get(this) + "\")\n";
                        continue block18;
                    }
                    case "Integer": 
                    case "Double": {
                        str = str + "(" + f.getName() + " " + f.get(this) + ")\n";
                        continue block18;
                    }
                    case "Integer[]": {
                        String integersList = Arrays.stream((Integer[])f.get(this)).map(Object::toString).collect(Collectors.joining(" "));
                        str = str + "(" + f.getName() + " " + integersList + ")\n";
                        continue block18;
                    }
                    case "Double[]": {
                        try {
                            String doublesList = Arrays.stream((Double[])f.get(this)).map(x -> String.format("%.12f", x)).collect(Collectors.joining(" "));
                            str = str + "(" + f.getName() + " " + doublesList + ")\n";
                        }
                        catch (Exception e) {
                            System.out.println("Parameter not found: " + f.getName());
                        }
                        continue block18;
                    }
                    default: {
                        System.err.println("Unhandled class : " + f.getType().getSimpleName());
                    }
                }
            }
        }
        catch (IllegalAccessException e) {
            str = "Error during ElastixTransform to String conversion";
            e.printStackTrace();
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File toFile() {
        BufferedWriter writer = null;
        try {
            File temp = File.createTempFile("TransformParameters.", ".txt");
            writer = new BufferedWriter(new FileWriter(temp));
            writer.write(this.toString());
            writer.close();
            temp.deleteOnExit();
            File file = temp;
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
            File file = null;
            return file;
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File save(String path) {
        BufferedWriter writer = null;
        try {
            File f = new File(path);
            writer = new BufferedWriter(new FileWriter(f));
            writer.write(this.toString());
            writer.close();
            File file = f;
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
            File file = null;
            return file;
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    public static ElastixTransform load(File f) throws IOException, UnsupportedOperationException {
        ElastixTransform dimensionCastET;
        Matcher m;
        String line;
        BufferedReader file = new BufferedReader(new FileReader(f));
        String regex = "\\((\\S+)\\s(.+)(\\))";
        Pattern p = Pattern.compile(regex);
        Object out = null;
        block46: while ((line = file.readLine()) != null) {
            m = p.matcher(line);
            if (!m.matches() || !m.group(1).equals("Transform")) continue;
            switch (m.group(2)) {
                case "\"TranslationTransform\"": {
                    file.close();
                    throw new UnsupportedOperationException();
                }
                case "\"SplineKernelTransform\"": {
                    file.close();
                    throw new UnsupportedOperationException();
                }
                case "\"EulerTransform\"": {
                    out = new ElastixEulerTransform();
                    ((ElastixTransform)out).Transform = EULER_TRANSFORM;
                    break block46;
                }
                case "\"AffineTransform\"": {
                    out = new ElastixAffineTransform();
                    ((ElastixTransform)out).Transform = AFFINE_TRANSFORM;
                    break block46;
                }
                case "\"BSplineTransform\"": {
                    out = new ElastixBSplineTransform();
                    ((ElastixTransform)out).Transform = BSPLINE_TRANSFORM;
                    break block46;
                }
                case "\"SimilarityTransform\"": {
                    out = new ElastixSimilarityTransform();
                    ((ElastixTransform)out).Transform = SIMILARITY_TRANSFORM;
                    break block46;
                }
                default: {
                    file.close();
                    throw new UnsupportedOperationException("Unrecognized transformation type: " + m.group(2));
                }
            }
        }
        if (out == null) {
            throw new UnsupportedOperationException("Could not find the transformation type of the file.");
        }
        file.close();
        file = new BufferedReader(new FileReader(f));
        Class<?> elastixTransformClass = out.getClass();
        while ((line = file.readLine()) != null) {
            m = p.matcher(line);
            if (!m.matches() || m.group(1).equals("Transform")) continue;
            try {
                Field field = elastixTransformClass.getField(m.group(1));
                if (!field.isAnnotationPresent(Parameter.class)) continue;
                ElastixTransform.fillField((ElastixTransform)out, field, m.group(2));
            }
            catch (NoSuchFieldException e) {
                System.err.println("Field " + m.group(1) + " not found in " + elastixTransformClass.getName() + " class.");
            }
        }
        file.close();
        if (!((ElastixTransform)out).FixedImageDimension.equals(((ElastixTransform)out).MovingImageDimension)) {
            System.err.println("fixed dimension = " + ((ElastixTransform)out).FixedImageDimension);
            System.err.println("moving dimension = " + ((ElastixTransform)out).MovingImageDimension);
            System.err.println("Unhandled case : non identical dimensions transformation");
            throw new UnsupportedOperationException();
        }
        block17 : switch (((ElastixTransform)out).FixedImageDimension) {
            case 2: {
                switch (out.getClass().getSimpleName()) {
                    case "ElastixAffineTransform": {
                        dimensionCastET = ElastixTransform.upCast((ElastixTransform)out, ElastixAffineTransform2D.class);
                        break block17;
                    }
                    case "ElastixBSplineTransform": {
                        dimensionCastET = ElastixTransform.upCast((ElastixTransform)out, ElastixBSplineTransform2D.class);
                        break block17;
                    }
                    case "ElastixSimilarityTransform": {
                        dimensionCastET = ElastixTransform.upCast((ElastixTransform)out, ElastixSimilarityTransform2D.class);
                        break block17;
                    }
                    case "ElastixEulerTransform": {
                        dimensionCastET = ElastixTransform.upCast((ElastixTransform)out, ElastixEulerTransform2D.class);
                        break block17;
                    }
                }
                throw new UnsupportedOperationException();
            }
            case 3: {
                switch (out.getClass().getSimpleName()) {
                    case "ElastixAffineTransform": {
                        dimensionCastET = ElastixTransform.upCast((ElastixTransform)out, ElastixAffineTransform3D.class);
                        break block17;
                    }
                    case "ElastixBSplineTransform": {
                        dimensionCastET = ElastixTransform.upCast((ElastixTransform)out, ElastixBSplineTransform3D.class);
                        break block17;
                    }
                    case "ElastixSimilarityTransform": {
                        dimensionCastET = ElastixTransform.upCast((ElastixTransform)out, ElastixSimilarityTransform3D.class);
                        break block17;
                    }
                    case "ElastixEulerTransform": {
                        dimensionCastET = ElastixTransform.upCast((ElastixTransform)out, ElastixEulerTransform3D.class);
                        break block17;
                    }
                }
                throw new UnsupportedOperationException();
            }
            default: {
                System.err.println(((ElastixTransform)out).FixedImageDimension + "D transform unsupported.");
                throw new UnsupportedOperationException();
            }
        }
        return dimensionCastET;
    }

    static ElastixTransform upCast(ElastixTransform et, Class classType) {
        ElastixTransform et_out = null;
        try {
            et_out = (ElastixTransform)classType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        try {
            Field[] fields = et.getClass().getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field f = fields[i];
                if (!f.isAnnotationPresent(Parameter.class)) continue;
                f.set(et_out, f.get(et));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return et_out;
    }

    static void fillField(ElastixTransform et, Field f, String s) {
        try {
            switch (f.getType().getSimpleName()) {
                case "String": {
                    String stringValue = s.substring(1, s.length() - 1);
                    f.set(et, stringValue);
                    break;
                }
                case "Integer": {
                    f.set(et, new Integer(s));
                    break;
                }
                case "Integer[]": {
                    String[] integerList = s.split(" ");
                    Integer[] integers = new Integer[integerList.length];
                    for (int i = 0; i < integers.length; ++i) {
                        integers[i] = new Integer(integerList[i]);
                    }
                    f.set(et, integers);
                    break;
                }
                case "Double": {
                    f.set(et, new Double(s));
                    break;
                }
                case "Double[]": {
                    String[] doubleList = s.split(" ");
                    Double[] doubles = new Double[doubleList.length];
                    for (int i = 0; i < doubles.length; ++i) {
                        doubles[i] = new Double(doubleList[i]);
                    }
                    f.set(et, doubles);
                    break;
                }
                case "Boolean": {
                    f.set(et, new Boolean(s.substring(1, s.length() - 1)));
                    break;
                }
                default: {
                    System.err.println("Unhandled class : " + f.getType().getSimpleName());
                    break;
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

