/*
 * Decompiled with CFR 0.152.
 */
package itc.transforms.elastix;

import itc.transforms.elastix.ElastixSimilarityTransform;
import net.imglib2.util.LinAlgHelpers;

public class ElastixSimilarityTransform3D
extends ElastixSimilarityTransform {
    private double getNorm(double[] vector) {
        double norm = 0.0;
        for (int i = 0; i < vector.length; ++i) {
            norm += vector[i] * vector[i];
        }
        if (norm > 0.0) {
            norm = Math.sqrt(norm);
        }
        return norm;
    }

    public double[][] getRotationMatrix() {
        double epsilon;
        double[] axis = new double[]{this.TransformParameters[0], this.TransformParameters[1], this.TransformParameters[2]};
        double norm = this.getNorm(axis);
        if (norm >= 1.0 - (epsilon = 1.0E-10)) {
            for (int i = 0; i < axis.length; ++i) {
                axis[i] = axis[i] / (norm + epsilon * norm);
            }
        }
        double sinangle2 = this.getNorm(axis);
        double cosangle2 = Math.sqrt(1.0 - sinangle2 * sinangle2);
        double[] unitQuaternion = new double[]{cosangle2, axis[0], axis[1], axis[2]};
        double[][] matrix = new double[3][3];
        LinAlgHelpers.quaternionToR((double[])unitQuaternion, (double[][])matrix);
        return matrix;
    }

    public double getScalingFactor() {
        double scalingFactor = this.TransformParameters[6];
        return scalingFactor;
    }

    public double[] getTranslationInMillimeters() {
        double[] translation = new double[]{this.TransformParameters[3], this.TransformParameters[4], this.TransformParameters[5]};
        return translation;
    }

    public double[] getRotationCenterInMillimeters() {
        double[] rotationCenter = new double[]{this.CenterOfRotationPoint[0], this.CenterOfRotationPoint[1], this.CenterOfRotationPoint[2]};
        return rotationCenter;
    }
}

