/*
 * Decompiled with CFR 0.152.
 */
package itc.transforms.bdv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.imglib2.realtransform.AffineTransform3D;

public class BdvTransform {
    public static final String BDV_DELIM = " ";
    public final AffineTransform3D affineTransform3D;
    public final String unit;
    public final double[] voxelSizes;
    public final long[] imageDimensions;

    public BdvTransform(AffineTransform3D affineTransform3D, String unit, double[] voxelSizes, long[] imageDimensions) {
        this.affineTransform3D = affineTransform3D;
        this.unit = unit;
        this.voxelSizes = voxelSizes;
        this.imageDimensions = imageDimensions;
    }

    public static BdvTransform load(File f) throws IOException {
        String line;
        BufferedReader file = new BufferedReader(new FileReader(f));
        Pattern affinePattern = Pattern.compile(".*<affine>(.*)</affine>");
        Pattern unitPattern = Pattern.compile(".*<unit>(.*)</unit>");
        Pattern sizePattern = Pattern.compile(".*<size>(.*)</size>");
        Pattern voxelSizeStartPattern = Pattern.compile(".*<voxelSize>.*");
        Pattern voxelSizeEndPattern = Pattern.compile(".*</voxelSize>.*");
        String affine = null;
        String unit = null;
        String voxelSize = null;
        String imageDimension = null;
        boolean voxelSizeGroup = false;
        while ((line = file.readLine()) != null) {
            Matcher m = voxelSizeStartPattern.matcher(line);
            if (m.matches()) {
                voxelSizeGroup = true;
            }
            if ((m = voxelSizeEndPattern.matcher(line)).matches()) {
                voxelSizeGroup = false;
            }
            if (voxelSizeGroup) {
                m = sizePattern.matcher(line);
                if (m.matches()) {
                    voxelSize = m.group(1);
                }
                if (!(m = unitPattern.matcher(line)).matches()) continue;
                unit = m.group(1);
                continue;
            }
            m = affinePattern.matcher(line);
            if (m.matches()) {
                affine = m.group(1);
            }
            if (!(m = sizePattern.matcher(line)).matches()) continue;
            imageDimension = m.group(1);
        }
        AffineTransform3D affineTransform3D = BdvTransform.affineTransform3D(affine);
        double[] voxelSizes = Arrays.stream(voxelSize.split(BDV_DELIM)).mapToDouble(Double::parseDouble).toArray();
        long[] imageDimensions = Arrays.stream(imageDimension.split(BDV_DELIM)).mapToLong(Long::parseLong).toArray();
        BdvTransform bdvTransform = new BdvTransform(affineTransform3D, unit.trim(), voxelSizes, imageDimensions);
        return bdvTransform;
    }

    public static AffineTransform3D affineTransform3D(String affine) {
        double[] affineParams = Arrays.stream(affine.split(BDV_DELIM)).mapToDouble(Double::parseDouble).toArray();
        AffineTransform3D affineTransform3D = new AffineTransform3D();
        affineTransform3D.set(affineParams);
        return affineTransform3D;
    }
}

