/*
 * Decompiled with CFR 0.152.
 */
package itc.physicalimg;

import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class SimplePhysicalImg<T extends RealType<T> & NativeType<T>> {
    public static final int C = 3;
    public static final int T = 4;
    public static final int Z = 2;
    private final RandomAccessibleInterval<T> rai;
    private final double[] voxelSpacing;
    private final String unit;

    public SimplePhysicalImg(RandomAccessibleInterval<T> raiXYZCT, double[] voxelSpacingXYZ, String unit) {
        this.rai = raiXYZCT;
        this.voxelSpacing = voxelSpacingXYZ;
        this.unit = unit;
        if (!this.isWritable()) {
            // empty if block
        }
    }

    public boolean isWritable() {
        return true;
    }

    public long[] toPixels(double[] xyz) {
        long[] pixels = new long[3];
        for (int d = 0; d < 3; ++d) {
            pixels[d] = (long)(xyz[d] / this.voxelSpacing[d]);
        }
        return pixels;
    }

    public RandomAccessibleInterval<T> get3DRAI(long c, long t) {
        return Views.hyperSlice((RandomAccessibleInterval)Views.hyperSlice(this.rai, (int)4, (long)t), (int)3, (long)c);
    }

    public RandomAccessibleInterval<T> get2DRAI(double z, long c, long t) {
        double physicalOffset = (double)this.rai.min(2) / this.voxelSpacing[2];
        long zPlane = (int)(z / this.voxelSpacing[2] - physicalOffset + 0.5);
        IntervalView timepoint = Views.hyperSlice(this.rai, (int)4, (long)t);
        IntervalView channel = Views.hyperSlice((RandomAccessibleInterval)timepoint, (int)3, (long)c);
        IntervalView plane = Views.hyperSlice((RandomAccessibleInterval)channel, (int)2, (long)zPlane);
        return plane;
    }

    public double valueAt(double[] xyz, long c, long t) {
        long[] pixels = this.toPixels(xyz);
        RandomAccess access = this.get3DRAI(c, t).randomAccess();
        access.setPosition(pixels);
        return ((RealType)access.get()).getRealDouble();
    }
}

