/*
 * Decompiled with CFR 0.152.
 */
package itc.physicalimg;

import itc.physicalimg.PhysicalImg;
import itc.utilities.TransformUtils;
import net.imglib2.EuclideanSpace;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.ClampingNLinearInterpolatorFactory;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealViews;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;

public class PhysicalImgFromDiscrete<T extends RealType<T> & NativeType<T>>
extends PhysicalImg<T> {
    private final AffineGet pixelToPhysical;

    public PhysicalImgFromDiscrete(RandomAccessibleInterval<T> rai, AffineGet pixelToPhysical, String unit) {
        this(rai, pixelToPhysical, (InterpolatorFactory<T, RandomAccessible<T>>)new ClampingNLinearInterpolatorFactory(), unit);
    }

    public PhysicalImgFromDiscrete(RandomAccessibleInterval<T> rai, AffineGet pixelToPhysical, InterpolatorFactory<T, RandomAccessible<T>> interpolatorFactory, String unit) {
        super(RealViews.transform((RealRandomAccessible)Views.interpolate((EuclideanSpace)Views.extendZero(rai), interpolatorFactory), (InvertibleRealTransform)pixelToPhysical), (RealInterval)TransformUtils.transformRealInterval(rai, (RealTransform)pixelToPhysical), unit, rai);
        this.pixelToPhysical = pixelToPhysical;
    }

    public PhysicalImgFromDiscrete(RandomAccessible<T> ra, Interval interval, AffineGet pixelToPhysical, InterpolatorFactory<T, RandomAccessible<T>> interpolatorFactory, String unit) {
        super(RealViews.transform((RealRandomAccessible)Views.interpolate(ra, interpolatorFactory), (InvertibleRealTransform)pixelToPhysical), (RealInterval)TransformUtils.transformRealInterval((RealInterval)interval, (RealTransform)pixelToPhysical), unit, Views.interval(ra, (Interval)interval));
        this.pixelToPhysical = pixelToPhysical;
    }
}

