/*
 * Decompiled with CFR 0.152.
 */
package itc.physicalimg;

import itc.physicalimg.PhysicalImgFromDiscrete;
import itc.utilities.CopyUtils;
import itc.utilities.TransformUtils;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealTransformRandomAccessible;
import net.imglib2.realtransform.RealViews;
import net.imglib2.realtransform.Scale;
import net.imglib2.realtransform.Scale3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.RandomAccessibleOnRealRandomAccessible;
import net.imglib2.view.Views;

public class PhysicalImg<T extends RealType<T> & NativeType<T>> {
    public static final String MICROMETER = "micrometer";
    private final RandomAccessibleInterval<T> wrappedRAI;
    private final RealRandomAccessible<T> rra;
    private final RealInterval interval;
    private final String unit;

    public PhysicalImg(RealRandomAccessible<T> rra, RealInterval interval) {
        this(rra, interval, MICROMETER, null);
    }

    public PhysicalImg(RealRandomAccessible<T> rra, RealInterval interval, String unit, RandomAccessibleInterval<T> wrappedRAI) {
        this.rra = rra;
        this.interval = interval;
        this.unit = unit;
        this.wrappedRAI = wrappedRAI;
    }

    public RandomAccessibleInterval<T> raiView() {
        return this.raiView(1.0, 1.0, 1.0);
    }

    public RandomAccessibleInterval<T> raiView(double ... spacing) {
        assert (spacing.length == 3) : "Input dimensions do not match or are not 3.";
        FinalInterval interval = this.interval(spacing);
        RandomAccessible<T> ra = this.raView(spacing);
        return Views.interval(ra, (Interval)interval);
    }

    private FinalInterval interval(double ... spacing) {
        Scale3D scale = TransformUtils.getPhysicalToPixelScaleTransform3D(spacing);
        FinalInterval pixelInterval = TransformUtils.transformRealIntervalExpand(this.interval, (RealTransform)scale);
        return pixelInterval;
    }

    public RandomAccessible<T> raView(double ... spacing) {
        assert (spacing.length == 3) : "Input dimensions do not match or are not 3.";
        Scale3D scale = TransformUtils.getScaleTransform3D(spacing);
        RealTransformRandomAccessible scaledRRA = RealViews.transform(this.rra, (InvertibleRealTransform)scale);
        RandomAccessibleOnRealRandomAccessible raster = Views.raster((RealRandomAccessible)scaledRRA);
        return raster;
    }

    public PhysicalImg<T> copy(double ... spacing) {
        PhysicalImgFromDiscrete<T> copy = new PhysicalImgFromDiscrete<T>(CopyUtils.copyAsArrayImg(this.raiView(spacing)), (AffineGet)new Scale(spacing), this.unit);
        return copy;
    }

    public RealRandomAccessible<T> getRRA() {
        return this.rra;
    }

    public RealInterval getInterval() {
        return this.interval;
    }

    public String getUnit() {
        return this.unit;
    }

    public RandomAccessibleInterval<T> getWrappedRAI() {
        return this.wrappedRAI;
    }
}

