/*
 * Decompiled with CFR 0.152.
 */
package itc.demos;

import bdv.util.BdvFunctions;
import itc.physicalimg.PhysicalImg;
import itc.physicalimg.PhysicalImgFromDiscrete;
import java.util.Random;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gauss3.Gauss3;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.view.Views;

public class PhysicalImgGaussExample {
    public static final double[] ONE_MICROMETER_3D = new double[]{1.0, 1.0, 1.0};

    public static <T extends RealType<T> & NativeType<T>> void main(String[] args) {
        ArrayImg ints = ArrayImgs.ints((long[])new long[]{100L, 100L, 10L});
        Cursor cursor = Views.iterable((RandomAccessibleInterval)ints).cursor();
        Random random = new Random();
        while (cursor.hasNext()) {
            ((IntType)cursor.next()).set(random.nextInt(65535));
        }
        PhysicalImgFromDiscrete img = new PhysicalImgFromDiscrete(ints, (AffineGet)new AffineTransform3D(), "micrometer");
        BdvFunctions.show(img.raiView(), (String)"input");
        PhysicalImg gauss = img.copy(ONE_MICROMETER_3D);
        Gauss3.gauss((double[])new double[]{3.0, 3.0, 3.0}, img.raView(ONE_MICROMETER_3D), gauss.getWrappedRAI());
        BdvFunctions.show(gauss.raiView(), (String)"gauss");
    }
}

