/*
 * Decompiled with CFR 0.152.
 */
package itc.demos;

import bdv.util.BdvFunctions;
import ij.IJ;
import ij.ImagePlus;
import net.imglib2.EuclideanSpace;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.img.Img;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.ClampingNLinearInterpolatorFactory;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.InvertibleRealTransformSequence;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealViews;
import net.imglib2.realtransform.Scale;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;

public class ImageTransformBestPractices {
    public static <R extends RealType<R> & NativeType<R>> void main(String[] args) {
        ImagePlus imp = ImageTransformBestPractices.loadMrAndCalibrate();
        Img imgpixel = ImageJFunctions.wrapReal((ImagePlus)imp);
        double[] inputSpacing = new double[]{800.0, 800.0, 2200.0};
        RealRandomAccessible imgPhysical = ImageTransformBestPractices.wrapAndInterpolateToPhysicalSpace(imgpixel, inputSpacing);
        AffineTransform3D shearingTransform = new AffineTransform3D();
        shearingTransform.set(0.8, 0.1, 0.1, 0.0, 0.1, 0.8, 0.1, 0.0, 0.1, 0.1, 0.8, 0.0);
        double[] outputSpacing = new double[]{400.0, 400.0, 400.0};
        RealRandomAccessible resultPixel = ImageTransformBestPractices.transformAndRender(imgPhysical, (InvertibleRealTransform)shearingTransform, outputSpacing);
        BdvFunctions.show(resultPixel, (Interval)ImageTransformBestPractices.getOutputInterval((Interval)imgpixel, inputSpacing, outputSpacing), (String)"transformed real interval pixel space");
    }

    public static Interval getOutputInterval(Interval intervalIn, double[] spacingin, double[] spacingout) {
        return new FinalInterval(new long[]{Math.round((double)intervalIn.dimension(0) * spacingin[0] / spacingout[0]), Math.round((double)intervalIn.dimension(1) * spacingin[1] / spacingout[1]), Math.round((double)intervalIn.dimension(2) * spacingin[2] / spacingout[2])});
    }

    public static <T extends RealType<T> & NativeType<T>> RealRandomAccessible<T> transformAndRender(RealRandomAccessible<T> imgPhysical, InvertibleRealTransform transform, double[] outputPixelSpacing) {
        AffineTransform3D outputPixelToPhysical = new AffineTransform3D();
        for (int i = 0; i < 3; ++i) {
            outputPixelToPhysical.set(outputPixelSpacing[i], i, i);
        }
        InvertibleRealTransformSequence totalTransform = new InvertibleRealTransformSequence();
        totalTransform.add((RealTransform)transform);
        totalTransform.add((RealTransform)outputPixelToPhysical.inverse());
        return RealViews.transform(imgPhysical, (InvertibleRealTransform)totalTransform);
    }

    public static ImagePlus loadMrAndCalibrate() {
        ImagePlus imp = IJ.openImage((String)"http://imagej.nih.gov/ij/images/mri-stack.zip");
        imp.getCalibration().pixelWidth = 800.0;
        imp.getCalibration().pixelHeight = 800.0;
        imp.getCalibration().pixelDepth = 2200.0;
        imp.getCalibration().setUnit("micrometer");
        return imp;
    }

    public static <T extends RealType<T> & NativeType<T>> RealRandomAccessible<T> wrapAndInterpolateToPhysicalSpace(RandomAccessibleInterval<T> imgPixelSpace, double[] pixelSpacing) {
        Scale scale3D = new Scale(pixelSpacing);
        return RealViews.affine((RealRandomAccessible)Views.interpolate((EuclideanSpace)Views.extendZero(imgPixelSpace), (InterpolatorFactory)new ClampingNLinearInterpolatorFactory()), (AffineGet)scale3D);
    }

    public static <T extends RealType<T> & NativeType<T>> RealRandomAccessible<T> wrapAndInterpolateToPhysicalSpace(RandomAccessibleInterval<T> imgPixelSpace, double[] pixelSpacing, double[] offset) {
        Scale scale3D = new Scale(pixelSpacing);
        return RealViews.affine((RealRandomAccessible)Views.interpolate((EuclideanSpace)Views.extendZero(imgPixelSpace), (InterpolatorFactory)new ClampingNLinearInterpolatorFactory()), (AffineGet)scale3D);
    }
}

