/*
 * Decompiled with CFR 0.152.
 */
package itc.converters;

import itc.transforms.elastix.ElastixSimilarityTransform2D;
import net.imglib2.realtransform.AffineTransform2D;

public class ElastixSimilarity2DToAffineTransform2D {
    public static AffineTransform2D convert(ElastixSimilarityTransform2D elastixSimilarityTransform2D) {
        double angle = elastixSimilarityTransform2D.getRotationAnglesInRadians()[2];
        double scalingFactor = elastixSimilarityTransform2D.getScalingFactor();
        double[] rotationCenterInMillimeters = elastixSimilarityTransform2D.getRotationCenterInMillimeters();
        double[] translationInMillimeters = elastixSimilarityTransform2D.getTranslationInMillimeters();
        double[] rotationCenterPositive = new double[2];
        double[] rotationCenterNegative = new double[2];
        for (int d = 0; d < 2; ++d) {
            rotationCenterPositive[d] = rotationCenterInMillimeters[d];
            rotationCenterNegative[d] = -rotationCenterInMillimeters[d];
        }
        AffineTransform2D transform2D = new AffineTransform2D();
        transform2D.translate(rotationCenterNegative);
        transform2D.rotate(angle);
        transform2D.scale(scalingFactor);
        AffineTransform2D translateBackFromRotationCenter = new AffineTransform2D();
        translateBackFromRotationCenter.translate(rotationCenterPositive);
        transform2D.preConcatenate(translateBackFromRotationCenter);
        transform2D.translate(translationInMillimeters);
        return transform2D;
    }
}

