/*
 * Decompiled with CFR 0.152.
 */
package itc.converters;

import itc.transforms.elastix.ElastixEulerTransform3D;
import net.imglib2.realtransform.AffineTransform3D;

public class ElastixEuler3DToAffineTransform3D {
    public static AffineTransform3D convert(ElastixEulerTransform3D elastixEulerTransform3D) {
        double[] angles = elastixEulerTransform3D.getRotationAnglesInRadians();
        double[] rotationCenterInMillimeters = elastixEulerTransform3D.getRotationCenterInMillimeters();
        double[] translationInMillimeters = elastixEulerTransform3D.getTranslationInMillimeters();
        double[] rotationCenterPositive = new double[3];
        double[] rotationCenterNegative = new double[3];
        for (int d = 0; d < 3; ++d) {
            rotationCenterPositive[d] = rotationCenterInMillimeters[d];
            rotationCenterNegative[d] = -rotationCenterInMillimeters[d];
        }
        AffineTransform3D transform3D = new AffineTransform3D();
        transform3D.translate(rotationCenterNegative);
        for (int d = 0; d < 3; ++d) {
            transform3D.rotate(d, angles[d]);
        }
        AffineTransform3D translateBackFromRotationCenter = new AffineTransform3D();
        translateBackFromRotationCenter.translate(rotationCenterPositive);
        transform3D.preConcatenate(translateBackFromRotationCenter);
        transform3D.translate(translationInMillimeters);
        return transform3D;
    }
}

