/*
 * Decompiled with CFR 0.152.
 */
package itc.converters;

import itc.transforms.elastix.ElastixAffineTransform3D;
import net.imglib2.realtransform.AffineTransform3D;

public class ElastixAffine3DToAffineTransform3D {
    public static AffineTransform3D convert(ElastixAffineTransform3D elastixAffineTransform3D) {
        double[][] matrix = elastixAffineTransform3D.getMatrix();
        double[] rotationCenterInMillimeters = elastixAffineTransform3D.getRotationCenterInMillimeters();
        double[] translationInMillimeters = elastixAffineTransform3D.getTranslationInMillimeters();
        double[] rotationCenterPositive = new double[3];
        double[] rotationCenterNegative = new double[3];
        for (int d = 0; d < 3; ++d) {
            rotationCenterPositive[d] = rotationCenterInMillimeters[d];
            rotationCenterNegative[d] = -rotationCenterInMillimeters[d];
        }
        AffineTransform3D transform3D = new AffineTransform3D();
        transform3D.translate(rotationCenterNegative);
        AffineTransform3D rotateAndScale = new AffineTransform3D();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                rotateAndScale.set(matrix[row][col], row, col);
            }
        }
        transform3D.preConcatenate(rotateAndScale);
        AffineTransform3D translateBackFromRotationCenter = new AffineTransform3D();
        translateBackFromRotationCenter.translate(rotationCenterPositive);
        transform3D.preConcatenate(translateBackFromRotationCenter);
        transform3D.translate(translationInMillimeters);
        return transform3D;
    }
}

