/*
 * Decompiled with CFR 0.152.
 */
package itc.converters;

import itc.transforms.elastix.ElastixAffineTransform2D;
import net.imglib2.realtransform.AffineTransform2D;

public class ElastixAffine2DToAffineTransform2D {
    public static AffineTransform2D convert(ElastixAffineTransform2D elastixAffineTransform2D) {
        double[][] matrix = elastixAffineTransform2D.getMatrix();
        double[] rotationCenterInMillimeters = elastixAffineTransform2D.getRotationCenterInMillimeters();
        double[] translationInMillimeters = elastixAffineTransform2D.getTranslationInMillimeters();
        double[] rotationCenterPositive = new double[2];
        double[] rotationCenterNegative = new double[2];
        for (int d = 0; d < 2; ++d) {
            rotationCenterPositive[d] = rotationCenterInMillimeters[d];
            rotationCenterNegative[d] = -rotationCenterInMillimeters[d];
        }
        AffineTransform2D transform2D = new AffineTransform2D();
        transform2D.translate(rotationCenterNegative);
        AffineTransform2D rotateAndScale = new AffineTransform2D();
        for (int row = 0; row < 2; ++row) {
            for (int col = 0; col < 2; ++col) {
                rotateAndScale.set(matrix[row][col], row, col);
            }
        }
        transform2D.preConcatenate(rotateAndScale);
        AffineTransform2D translateBackFromRotationCenter = new AffineTransform2D();
        translateBackFromRotationCenter.translate(rotationCenterPositive);
        transform2D.preConcatenate(translateBackFromRotationCenter);
        transform2D.translate(translationInMillimeters);
        return transform2D;
    }
}

