/*
 * Decompiled with CFR 0.152.
 */
package itc.converters;

import itc.transforms.elastix.ElastixEulerTransform3D;
import itc.utilities.TransformUtils;
import net.imglib2.realtransform.AffineTransform3D;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;

public abstract class DiverseConverters {
    public static AffineTransform3D amiraEulerInMicrometerToAffineTransform3DInPixels(double[] amiraRotationAxis, double amiraRotationAngleInDegrees, double[] amiraTranslationVectorInMicrometer, double[] targetImageVoxelSizeInMicrometer, double[] targetImageCenterInPixels) {
        Vector3D axis = new Vector3D(amiraRotationAxis[0], amiraRotationAxis[1], amiraRotationAxis[2]);
        double angle = amiraRotationAngleInDegrees / 180.0 * Math.PI;
        double[][] rotationMatrix = TransformUtils.rotationMatrix(axis, angle);
        AffineTransform3D transform3D = TransformUtils.rotationAroundImageCenterTransform(rotationMatrix, targetImageCenterInPixels);
        double[] translationInPixels = new double[3];
        for (int d = 0; d < 3; ++d) {
            translationInPixels[d] = amiraTranslationVectorInMicrometer[d] / targetImageVoxelSizeInMicrometer[d];
        }
        transform3D.translate(translationInPixels);
        return transform3D;
    }

    public static String affineTransform3DToElastixAffine3DString(AffineTransform3D affineTransform3D, double voxelSizeInMillimeter) {
        String out = "";
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                out = out + affineTransform3D.get(row, col) + " ";
            }
        }
        out = out + voxelSizeInMillimeter * affineTransform3D.get(0, 3) + " ";
        out = out + voxelSizeInMillimeter * affineTransform3D.get(1, 3) + " ";
        out = out + voxelSizeInMillimeter * affineTransform3D.get(2, 3);
        return out;
    }

    public static String affineTransform3DToBigDataViewerAffine3DString(AffineTransform3D affineTransform3D) {
        String out = "";
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 4; ++col) {
                out = out + String.format("%.4f", affineTransform3D.get(row, col)) + " ";
            }
        }
        return out;
    }

    public static AffineTransform3D getElastixSimilarityAsBdvAffine() {
        return null;
    }

    public static AffineTransform3D elastixEuler3DStringsAsAffineTransform3DInPixelUnits(String transform, String rotationCentre, double[] imageVoxelSizeInMicrometer) {
        String[] split = transform.split(" ");
        double[] angles = new double[3];
        for (int d = 0; d < 3; ++d) {
            angles[d] = Double.parseDouble(split[d]);
        }
        double[] translationInPixels = new double[3];
        for (int d = 0; d < 3; ++d) {
            translationInPixels[d] = Double.parseDouble(split[d + 3]) / (0.001 * imageVoxelSizeInMicrometer[d]);
        }
        split = rotationCentre.split(" ");
        double[] rotationCentreVectorInPixelsPositive = new double[3];
        double[] rotationCentreVectorInPixelsNegative = new double[3];
        for (int d = 0; d < 3; ++d) {
            rotationCentreVectorInPixelsPositive[d] = Double.parseDouble(split[d]) / (0.001 * imageVoxelSizeInMicrometer[d]);
            rotationCentreVectorInPixelsNegative[d] = -Double.parseDouble(split[d]) / (0.001 * imageVoxelSizeInMicrometer[d]);
        }
        AffineTransform3D transform3D = new AffineTransform3D();
        transform3D.translate(rotationCentreVectorInPixelsNegative);
        for (int d = 0; d < 3; ++d) {
            transform3D.rotate(d, angles[d]);
        }
        AffineTransform3D translateBackFromRotationCentre = new AffineTransform3D();
        translateBackFromRotationCentre.translate(rotationCentreVectorInPixelsPositive);
        transform3D.preConcatenate(translateBackFromRotationCentre);
        transform3D.translate(translationInPixels);
        return transform3D;
    }

    public static ElastixEulerTransform3D elastixEuler3DStringsToElastixEulerTransform3D(String transform, String rotationCentre) {
        return null;
    }

    public static AffineTransform3D elastixEulerTransform3DToAffineTransform3DInPixelUnits(ElastixEulerTransform3D elastixEulerTransform3D, double[] imageVoxelSizeInMicrometer) {
        double[] angles = elastixEulerTransform3D.getRotationAnglesInRadians();
        double[] translationInMillimeters = elastixEulerTransform3D.getTranslationInMillimeters();
        double[] translationInPixels = new double[3];
        for (int d = 0; d < 3; ++d) {
            translationInPixels[d] = translationInMillimeters[d] / (0.001 * imageVoxelSizeInMicrometer[d]);
        }
        double[] rotationCenterInMillimeters = elastixEulerTransform3D.getRotationCenterInMillimeters();
        double[] rotationCentreVectorInPixelsPositive = new double[3];
        double[] rotationCentreVectorInPixelsNegative = new double[3];
        for (int d = 0; d < 3; ++d) {
            rotationCentreVectorInPixelsPositive[d] = rotationCenterInMillimeters[d] / (0.001 * imageVoxelSizeInMicrometer[d]);
            rotationCentreVectorInPixelsNegative[d] = -rotationCenterInMillimeters[d] / (0.001 * imageVoxelSizeInMicrometer[d]);
        }
        AffineTransform3D transform3D = new AffineTransform3D();
        transform3D.translate(rotationCentreVectorInPixelsNegative);
        for (int d = 0; d < 3; ++d) {
            transform3D.rotate(d, angles[d]);
        }
        AffineTransform3D translateBackFromRotationCentre = new AffineTransform3D();
        translateBackFromRotationCentre.translate(rotationCentreVectorInPixelsPositive);
        transform3D.preConcatenate(translateBackFromRotationCentre);
        transform3D.translate(translationInPixels);
        return transform3D;
    }
}

