/*
 * Decompiled with CFR 0.152.
 */
package itc.converters;

import itc.converterinterfaces.ImageTransformConverterA;
import itc.transforms.CmtkAffineTransform3D;
import net.imglib2.realtransform.AffineTransform3D;

public class CmtkAffineToAffineTransform3DConverter
implements ImageTransformConverterA<CmtkAffineTransform3D, AffineTransform3D> {
    @Override
    public AffineTransform3D convert(CmtkAffineTransform3D input) {
        AffineTransform3D mtx = new AffineTransform3D();
        double alpha = Math.toRadians(input.rotate[0]);
        double theta = Math.toRadians(input.rotate[1]);
        double phi = Math.toRadians(input.rotate[2]);
        double cos0 = Math.cos(alpha);
        double cos1 = Math.cos(theta);
        double cos2 = Math.cos(phi);
        double sin0 = Math.sin(alpha);
        double sin1 = Math.sin(theta);
        double sin2 = Math.sin(phi);
        double sin0xsin1 = sin0 * sin1;
        double cos0xsin1 = cos0 * sin1;
        mtx.set(cos1 * cos2, 0, 0);
        mtx.set(-cos1 * sin2, 0, 1);
        mtx.set(-sin1, 0, 2);
        mtx.set(sin0xsin1 * cos2 + cos0 * sin2, 1, 0);
        mtx.set(-sin0xsin1 * sin2 + cos0 * cos2, 1, 1);
        mtx.set(sin0 * cos1, 1, 2);
        mtx.set(cos0xsin1 * cos2 - sin0 * sin2, 2, 0);
        mtx.set(-cos0xsin1 * sin2 - sin0 * cos2, 2, 1);
        mtx.set(cos0 * cos1, 2, 2);
        AffineTransform3D scaleShear = new AffineTransform3D();
        for (int i = 0; i < 3; ++i) {
            input.getClass();
            scaleShear.set(input.scale[i], i, i);
            scaleShear.set(input.shear[i], i / 2 + i % 2 + 1, i / 2);
        }
        mtx.preConcatenate(scaleShear);
        this.transposeInPlace(mtx);
        double[] xfmCenter = new double[3];
        mtx.apply(input.center, xfmCenter);
        mtx.set(input.translationXYZ[0] - xfmCenter[0] + input.center[0], 0, 3);
        mtx.set(input.translationXYZ[1] - xfmCenter[1] + input.center[1], 1, 3);
        mtx.set(input.translationXYZ[2] - xfmCenter[2] + input.center[2], 2, 3);
        return mtx;
    }

    public void transposeInPlace(AffineTransform3D mtx) {
        AffineTransform3D copy = mtx.copy();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                mtx.set(copy.get(i, j), j, i);
            }
        }
    }

    @Override
    public Class<CmtkAffineTransform3D> inputType() {
        return CmtkAffineTransform3D.class;
    }

    @Override
    public Class<AffineTransform3D> outputType() {
        return AffineTransform3D.class;
    }
}

