/*
 * Decompiled with CFR 0.152.
 */
package itc.converters;

import itc.converters.AffineTransform3DToElastixAffine3D;
import itc.transforms.elastix.ElastixAffineTransform3D;
import itc.utilities.TransformUtils;
import net.imglib2.realtransform.AffineTransform3D;

public class BigWarpAffineToElastixAffineTransform3D {
    public ElastixAffineTransform3D convert(AffineTransform3D bigWarpAffine, Double[] targetImageVoxelSpacingMillimeter, Integer[] targetImageDimensionsPixels, int targetImageBitDepth, String interpolator, String affineTransformUnit) {
        String resultImagePixelType = this.getPixelTypeString(targetImageBitDepth);
        AffineTransform3DToElastixAffine3D converter = new AffineTransform3DToElastixAffine3D(interpolator, resultImagePixelType, targetImageVoxelSpacingMillimeter, targetImageDimensionsPixels);
        if (!affineTransformUnit.equals("millimeter")) {
            if (affineTransformUnit.equals("micrometer")) {
                bigWarpAffine = TransformUtils.scaleAffineTransform3DUnits(bigWarpAffine, new double[]{0.001, 0.001, 0.001});
            } else if (affineTransformUnit.equals("nanometer")) {
                bigWarpAffine = TransformUtils.scaleAffineTransform3DUnits(bigWarpAffine, new double[]{1.0E-6, 1.0E-6, 1.0E-6});
            }
        }
        return converter.convert(bigWarpAffine);
    }

    private String getPixelTypeString(int targetImageBitDepth) {
        String resultImagePixelType;
        if (targetImageBitDepth == 8) {
            resultImagePixelType = "unsigned char";
        } else if (targetImageBitDepth == 16) {
            resultImagePixelType = "unsigned short";
        } else {
            throw new UnsupportedOperationException("No support for bit depth " + targetImageBitDepth);
        }
        return resultImagePixelType;
    }
}

