/*
 * Decompiled with CFR 0.152.
 */
package itc.converters;

import itc.utilities.TransformUtils;
import net.imglib2.realtransform.AffineTransform3D;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;

public class AmiraEulerToAffineTransform3D {
    public static AffineTransform3D convert(double[] rotationAxis, double rotationAngleInDegrees, double[] translationVectorInMicrometer, double[] rotationCenterInMicrometer) {
        Vector3D axis = new Vector3D(rotationAxis[0], rotationAxis[1], rotationAxis[2]);
        double angle = rotationAngleInDegrees / 180.0 * Math.PI;
        double[][] rotationMatrix = TransformUtils.rotationMatrix(axis, angle);
        double[] rotationCentreInMillimeter = AmiraEulerToAffineTransform3D.microToMillimeter(rotationCenterInMicrometer);
        AffineTransform3D transform3D = TransformUtils.rotationAroundImageCenterTransform(rotationMatrix, rotationCentreInMillimeter);
        double[] translationInMillimeters = AmiraEulerToAffineTransform3D.microToMillimeter(translationVectorInMicrometer);
        transform3D.translate(translationInMillimeters);
        return transform3D;
    }

    private static double[] microToMillimeter(double[] rotationCenterInMicrometer) {
        double[] rotationCentreInMillimeter = new double[3];
        for (int d = 0; d < 3; ++d) {
            rotationCentreInMillimeter[d] = rotationCenterInMicrometer[d] / 1000.0;
        }
        return rotationCentreInMillimeter;
    }
}

