/*
 * Decompiled with CFR 0.152.
 */
package itc.commands;

import itc.converters.BigWarpAffineToElastixAffineTransform3D;
import itc.transforms.elastix.ElastixAffineTransform3D;
import itc.utilities.ParsingUtils;
import java.io.File;
import loci.common.services.ServiceFactory;
import loci.formats.ImageReader;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import net.imglib2.realtransform.AffineTransform3D;
import ome.units.UNITS;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>Registration>Elastix>Utils>Big Warp Affine Transform to Transformix File")
public class BigWarpAffineToTransformixFileCommand
implements Command {
    public static final String MILLIMETER = "millimeter";
    public static final String MICROMETER = "micrometer";
    public static final String NANOMETER = "nanometer";
    @Parameter(label="Target image dimensions (from image file)")
    public File targetImageFile;
    @Parameter(label="Big warp affine transform")
    public String affineTransformString = "1.0 0.0 0.0 0.0 0.0 1.0 0.0 0.0 0.0 0.0 1.0 0.0";
    @Parameter(label="Big warp affine transform units", choices={"millimeter", "micrometer", "nanometer"})
    public String affineTransformUnit;
    @Parameter(label="Transformix transformation output file", style="save")
    public File transformationOutputFile;
    @Parameter(label="Interpolation", choices={"FinalLinearInterpolator", "FinalNearestNeighborInterpolator"})
    public String interpolation = "FinalLinearInterpolator";
    private Double[] voxelSpacingsMillimeter;
    private Integer[] dimensionsPixels;
    private Integer bitDepth;

    public void run() {
        this.setTargetImageProperties(this.targetImageFile);
        AffineTransform3D affineTransform3D = new AffineTransform3D();
        affineTransform3D.set(BigWarpAffineToTransformixFileCommand.affineStringAsDoubles(this.affineTransformString));
        ElastixAffineTransform3D elastixAffineTransform3D = new BigWarpAffineToElastixAffineTransform3D().convert(affineTransform3D, this.voxelSpacingsMillimeter, this.dimensionsPixels, this.bitDepth, this.interpolation, this.affineTransformUnit);
        elastixAffineTransform3D.save(this.transformationOutputFile.getAbsolutePath());
    }

    public static double[] affineStringAsDoubles(String affineString) {
        affineString = affineString.replace("3d-affine: (", "");
        affineString = affineString.replace(")", "");
        if ((affineString = affineString.replace("(", "")).contains(",")) {
            return ParsingUtils.delimitedStringToDoubleArray(affineString, ",");
        }
        return ParsingUtils.delimitedStringToDoubleArray(affineString, " ");
    }

    private void setTargetImageProperties(File file) {
        ServiceFactory factory = null;
        try {
            factory = new ServiceFactory();
            OMEXMLService service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
            OMEXMLMetadata meta = service.createOMEXMLMetadata();
            ImageReader reader = new ImageReader();
            reader.setMetadataStore((MetadataStore)meta);
            reader.setId(file.getAbsolutePath());
            reader.setSeries(0);
            String unit = meta.getPixelsPhysicalSizeX(0).unit().getSymbol();
            this.voxelSpacingsMillimeter = new Double[3];
            this.voxelSpacingsMillimeter[0] = meta.getPixelsPhysicalSizeX(0).value(UNITS.MILLIMETRE).doubleValue();
            this.voxelSpacingsMillimeter[1] = meta.getPixelsPhysicalSizeX(0).value(UNITS.MILLIMETRE).doubleValue();
            this.voxelSpacingsMillimeter[2] = meta.getPixelsPhysicalSizeX(0).value(UNITS.MILLIMETRE).doubleValue();
            this.dimensionsPixels = new Integer[3];
            this.dimensionsPixels[0] = (Integer)meta.getPixelsSizeX(0).getValue();
            this.dimensionsPixels[1] = (Integer)meta.getPixelsSizeY(0).getValue();
            this.dimensionsPixels[2] = (Integer)meta.getPixelsSizeZ(0).getValue();
            this.bitDepth = (Integer)meta.getPixelsSignificantBits(0).getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

