/*
 * Decompiled with CFR 0.152.
 */
package itc.commands;

import itc.commands.AbstractAmiraEulerToTransformixFileCommand;
import itc.utilities.ParsingUtils;
import java.util.Arrays;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>Registration>Elastix>Utils>Amira Euler Transform to Transformix File from Image Dimensions")
public class AmiraEulerToTransformixFileFromImageDimensionsCommand
extends AbstractAmiraEulerToTransformixFileCommand {
    @Parameter(label="Input image dimensions ( x, y, z ) [voxels]")
    public String inputImageVoxelDimensionsString = "100, 200, 50";
    @Parameter(label="Input image voxel spacing ( x, y, z ) [micrometer]")
    public String inputImageVoxelSpacingMicrometerString = "100, 200, 50";
    @Parameter(label="Target image dimensions ( x, y, z ) [voxels]")
    public String targetImageVoxelDimensionsString = "100, 200, 50";
    @Parameter(label="Target image voxel spacing ( x, y, z ) [micrometer]")
    public String targetImageVoxelSpacingMicrometerString = "100, 200, 50";
    @Parameter(label="Target image data type", choices={"unsigned char", "unsigned short"})
    public String targetImageDataTypeString = "unsigned short";

    public void run() {
        this.fetchRotationCenter();
        this.fetchTargetImageProperties();
        this.convertTransformAndCreateTransformixFile();
    }

    private void fetchTargetImageProperties() {
        this.targetImageVoxelSpacingMicrometer = ParsingUtils.delimitedStringToDoubleArray(this.targetImageVoxelSpacingMicrometerString, ",");
        this.targetImageDimensions = Arrays.stream(ParsingUtils.delimitedStringToDoubleArray(this.targetImageVoxelDimensionsString, ",")).mapToInt(x -> (int)x).toArray();
        this.targetImageDataType = this.targetImageDataTypeString;
    }

    private void fetchRotationCenter() {
        int[] inputImageDimensions = Arrays.stream(ParsingUtils.delimitedStringToDoubleArray(this.inputImageVoxelDimensionsString, ",")).mapToInt(x -> (int)x).toArray();
        double[] inputImageVoxelSpacing = ParsingUtils.delimitedStringToDoubleArray(this.inputImageVoxelSpacingMicrometerString, ",");
        this.rotationCentreMicrometer = new double[3];
        for (int d = 0; d < 3; ++d) {
            this.rotationCentreMicrometer[d] = 0.5 * (double)inputImageDimensions[d] * inputImageVoxelSpacing[d];
        }
    }
}

