/*
 * Decompiled with CFR 0.152.
 */
package itc.commands;

import itc.converters.AffineTransform3DToElastixAffine3D;
import itc.converters.AmiraEulerToAffineTransform3D;
import itc.transforms.elastix.ElastixAffineTransform3D;
import itc.utilities.ParsingUtils;
import java.io.File;
import java.util.Arrays;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;

public abstract class AbstractAmiraEulerToTransformixFileCommand
implements Command {
    @Parameter(label="Translation ( x, y, z ) [micrometer]")
    public String translationVectorMicrometerString = "10.0, 20.1, 15.3";
    @Parameter(label="Rotation axis ( x, y, z ) [unit vector]")
    public String rotationAxisUnitVectorString = "0.0, 1.0, 0.0";
    @Parameter(label="Rotation angle [degrees]")
    public double rotationAngleDegrees = 85.6;
    @Parameter(label="Interpolation method", choices={"FinalLinearInterpolator", "FinalNearestNeighborInterpolator"})
    public String interpolation = "FinalLinearInterpolator";
    @Parameter(label="Transformix transformation output file", style="save")
    public File transformationOutputFile;
    protected double[] translationMicrometer;
    protected double[] rotationAxisUnitVector;
    protected double[] rotationCentreMicrometer;
    protected double[] targetImageVoxelSpacingMicrometer;
    protected int[] targetImageDimensions;
    protected String targetImageDataType;

    protected void convertTransformAndCreateTransformixFile() {
        this.fetchTranslationAndRotationAxisAndAngle();
        AffineTransform3D transform3D = AmiraEulerToAffineTransform3D.convert(this.rotationAxisUnitVector, this.rotationAngleDegrees, this.translationMicrometer, this.rotationCentreMicrometer);
        AffineTransform3D inverse = transform3D.inverse();
        AffineTransform3DToElastixAffine3D affineTransform3DToElastixAffine3D = new AffineTransform3DToElastixAffine3D(this.interpolation, this.targetImageDataType, (Double[])Arrays.stream(this.targetImageVoxelSpacingMicrometer).boxed().map(x -> x / 1000.0).toArray(Double[]::new), (Integer[])Arrays.stream(this.targetImageDimensions).boxed().toArray(Integer[]::new));
        ElastixAffineTransform3D elastixAffineTransform3D = affineTransform3DToElastixAffine3D.convert(inverse);
        elastixAffineTransform3D.save(this.transformationOutputFile.getAbsolutePath());
    }

    private void fetchTranslationAndRotationAxisAndAngle() {
        this.translationMicrometer = ParsingUtils.delimitedStringToDoubleArray(this.translationVectorMicrometerString, ",");
        this.rotationAxisUnitVector = ParsingUtils.delimitedStringToDoubleArray(this.rotationAxisUnitVectorString, ",");
        this.rotationAngleDegrees = this.rotationAngleDegrees;
    }
}

