/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import com.google.common.base.Joiner;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import loci.common.DataTools;
import loci.common.DebugTools;
import loci.common.Location;
import loci.common.image.SimpleImageScaler;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.ChannelFiller;
import loci.formats.ChannelMerger;
import loci.formats.ChannelSeparator;
import loci.formats.DimensionSwapper;
import loci.formats.FilePattern;
import loci.formats.FileStitcher;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.IFormatWriter;
import loci.formats.ImageReader;
import loci.formats.ImageTools;
import loci.formats.ImageWriter;
import loci.formats.Memoizer;
import loci.formats.MetadataTools;
import loci.formats.MinMaxCalculator;
import loci.formats.MissingLibraryException;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000CodecOptions;
import loci.formats.gui.Index16ColorModel;
import loci.formats.in.DynamicMetadataOptions;
import loci.formats.in.MetadataOptions;
import loci.formats.meta.IMetadata;
import loci.formats.meta.IPyramidStore;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEPyramidStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.out.DicomWriter;
import loci.formats.out.IExtraMetadataWriter;
import loci.formats.out.TiffWriter;
import loci.formats.services.OMEXMLService;
import loci.formats.services.OMEXMLServiceImpl;
import loci.formats.tools.CommandLineTools;
import ome.xml.meta.MetadataRoot;
import ome.xml.meta.OMEXMLMetadataRoot;
import ome.xml.model.Channel;
import ome.xml.model.Image;
import ome.xml.model.Pixels;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.PositiveInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageConverter.class);
    private String in = null;
    private String out = null;
    private String map = null;
    private String compression = null;
    private boolean stitch = false;
    private boolean separate = false;
    private boolean merge = false;
    private boolean fill = false;
    private boolean bigtiff = false;
    private boolean group = true;
    private boolean nobigtiff = false;
    private boolean printVersion = false;
    private boolean lookup = true;
    private boolean autoscale = false;
    private Boolean overwrite = null;
    private int series = -1;
    private int firstPlane = 0;
    private int lastPlane = Integer.MAX_VALUE;
    private int channel = -1;
    private int zSection = -1;
    private int timepoint = -1;
    private int xCoordinate = 0;
    private int yCoordinate = 0;
    private int width = 0;
    private int height = 0;
    private int width_crop = 0;
    private int height_crop = 0;
    private int saveTileWidth = 0;
    private int saveTileHeight = 0;
    private boolean validate = false;
    private boolean zeroPadding = false;
    private boolean flat = true;
    private int pyramidScale = 1;
    private int pyramidResolutions = 1;
    private boolean useMemoizer = false;
    private String cacheDir = null;
    private boolean originalMetadata = true;
    private boolean noSequential = false;
    private String swapOrder = null;
    private Byte fillColor = null;
    private boolean precompressed = false;
    private boolean tryPrecompressed = false;
    private Double compressionQuality = null;
    private String extraMetadata = null;
    private IFormatReader reader;
    private MinMaxCalculator minMax;
    private DimensionSwapper dimSwapper;
    private HashMap<String, Integer> nextOutputIndex = new HashMap();
    private boolean firstTile = true;
    private DynamicMetadataOptions options = new DynamicMetadataOptions();
    private HashMap<String, Boolean> checkedPaths = new HashMap();

    private boolean parseArgs(String[] args) {
        if (args == null) {
            return true;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-") && args.length > 1) {
                if (args[i].equals("-version")) {
                    this.printVersion = true;
                    return true;
                }
                if (args[i].equals("-debug")) {
                    DebugTools.setRootLevel((String)"DEBUG");
                    continue;
                }
                if (args[i].equals("-stitch")) {
                    this.stitch = true;
                    continue;
                }
                if (args[i].equals("-separate")) {
                    this.separate = true;
                    continue;
                }
                if (args[i].equals("-merge")) {
                    this.merge = true;
                    continue;
                }
                if (args[i].equals("-expand")) {
                    this.fill = true;
                    continue;
                }
                if (args[i].equals("-bigtiff")) {
                    this.bigtiff = true;
                    continue;
                }
                if (args[i].equals("-nobigtiff")) {
                    this.nobigtiff = true;
                    continue;
                }
                if (args[i].equals("-map")) {
                    this.map = args[++i];
                    continue;
                }
                if (args[i].equals("-compression")) {
                    this.compression = args[++i];
                    continue;
                }
                if (args[i].equals("-nogroup")) {
                    this.group = false;
                    continue;
                }
                if (args[i].equals("-nolookup")) {
                    this.lookup = false;
                    continue;
                }
                if (args[i].equals("-autoscale")) {
                    this.autoscale = true;
                    continue;
                }
                if (args[i].equals("-novalid")) {
                    this.validate = false;
                    continue;
                }
                if (args[i].equals("-validate")) {
                    this.validate = true;
                    continue;
                }
                if (args[i].equals("-padded")) {
                    this.zeroPadding = true;
                    continue;
                }
                if (args[i].equals("-noflat")) {
                    this.flat = false;
                    continue;
                }
                if (args[i].equals("-no-sas")) {
                    this.originalMetadata = false;
                    continue;
                }
                if (args[i].equals("-precompressed")) {
                    this.precompressed = true;
                    continue;
                }
                if (args[i].equals("-cache")) {
                    this.useMemoizer = true;
                    continue;
                }
                if (args[i].equals("-cache-dir")) {
                    this.cacheDir = args[++i];
                    continue;
                }
                if (args[i].equals("-option")) {
                    this.options.set(args[++i], args[++i]);
                    continue;
                }
                if (args[i].equals("-overwrite")) {
                    this.overwrite = true;
                    continue;
                }
                if (args[i].equals("-nooverwrite")) {
                    this.overwrite = false;
                    continue;
                }
                if (args[i].equals("-channel")) {
                    this.channel = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-z")) {
                    this.zSection = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-timepoint")) {
                    this.timepoint = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-series")) {
                    try {
                        this.series = Integer.parseInt(args[++i]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (args[i].equals("-range")) {
                    try {
                        this.firstPlane = Integer.parseInt(args[++i]);
                        this.lastPlane = Integer.parseInt(args[++i]) + 1;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (args[i].equals("-crop")) {
                    String[] tokens = args[++i].split(",");
                    this.xCoordinate = Integer.parseInt(tokens[0]);
                    this.yCoordinate = Integer.parseInt(tokens[1]);
                    this.width_crop = Integer.parseInt(tokens[2]);
                    this.height_crop = Integer.parseInt(tokens[3]);
                    continue;
                }
                if (args[i].equals("-tilex")) {
                    try {
                        this.saveTileWidth = Integer.parseInt(args[++i]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (args[i].equals("-tiley")) {
                    try {
                        this.saveTileHeight = Integer.parseInt(args[++i]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (args[i].equals("-pyramid-scale")) {
                    try {
                        this.pyramidScale = Integer.parseInt(args[++i]);
                        if (this.pyramidScale <= 0) {
                            LOGGER.error("Invalid pyramid scale: {}", (Object)this.pyramidScale);
                            return false;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (args[i].equals("-pyramid-resolutions")) {
                    try {
                        this.pyramidResolutions = Integer.parseInt(args[++i]);
                        if (this.pyramidResolutions <= 0) {
                            LOGGER.error("Invalid pyramid resolution count: {}", (Object)this.pyramidResolutions);
                            return false;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (args[i].equals("-no-sequential")) {
                    this.noSequential = true;
                    continue;
                }
                if (args[i].equals("-swap")) {
                    this.swapOrder = args[++i].toUpperCase();
                    continue;
                }
                if (args[i].equals("-fill")) {
                    this.fillColor = (byte)Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-extra-metadata")) {
                    this.extraMetadata = args[++i];
                    continue;
                }
                if (args[i].equals("-quality")) {
                    this.compressionQuality = DataTools.parseDouble((String)args[++i]);
                    continue;
                }
                if (args[i].equals("-no-upgrade")) continue;
                LOGGER.error("Found unknown command flag: {}; exiting.", (Object)args[i]);
                return false;
            }
            if (args[i].equals("-version")) {
                this.printVersion = true;
                continue;
            }
            if (this.in == null) {
                this.in = args[i];
                continue;
            }
            if (this.out == null) {
                this.out = args[i];
                continue;
            }
            LOGGER.error("Found unknown argument: {}; exiting.", (Object)args[i]);
            LOGGER.error("You should specify exactly one input file and exactly one output file.");
            return false;
        }
        if (this.bigtiff && this.nobigtiff) {
            LOGGER.error("Do not specify both -bigtiff and -nobigtiff");
            return false;
        }
        return true;
    }

    private static SortedMap<String, String> getExtensions() {
        IFormatWriter[] writers = new ImageWriter().getWriters();
        TreeMap<String, String> extensions = new TreeMap<String, String>();
        for (int i = 0; i < writers.length; ++i) {
            extensions.put(writers[i].getFormat(), '.' + Joiner.on((String)", .").join((Object[])writers[i].getSuffixes()));
        }
        return extensions;
    }

    private static SortedMap<String, String> getCompressions() {
        IFormatWriter[] writers = new ImageWriter().getWriters();
        TreeMap<String, String> compressions = new TreeMap<String, String>();
        for (int i = 0; i < writers.length; ++i) {
            Object[] compressionTypes = writers[i].getCompressionTypes();
            if (compressionTypes == null) continue;
            compressions.put(writers[i].getFormat(), Joiner.on((String)", ").join(compressionTypes));
        }
        return compressions;
    }

    private static String printList(SortedMap<String, String> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> pair : map.entrySet()) {
            sb.append(" * " + pair.getKey() + ": " + pair.getValue() + '\n');
        }
        return sb.toString();
    }

    private void printUsage() {
        String[] s = new String[]{"To convert a file between formats, run:", "  bfconvert [-debug] [-stitch] [-separate] [-merge] [-expand]", "    [-bigtiff] [-nobigtiff] [-compression codec] [-series series] [-noflat]", "    [-cache] [-cache-dir dir] [-no-sas]", "    [-map id] [-range start end] [-crop x,y,w,h]", "    [-channel channel] [-z Z] [-timepoint timepoint] [-nogroup]", "    [-nolookup] [-autoscale] [-version] [-no-upgrade] [-padded]", "    [-option key value] [-novalid] [-validate] [-tilex tileSizeX]", "    [-tiley tileSizeY] [-pyramid-scale scale]", "    [-swap dimensionsOrderString] [-fill color]", "    [-precompressed] [-quality compressionQuality]", "    [-pyramid-resolutions numResolutionLevels] in_file out_file", "", "            -version: print the library version and exit", "         -no-upgrade: do not perform the upgrade check", "              -debug: turn on debugging output", "             -stitch: stitch input files with similar names", "           -separate: split RGB images into separate channels", "              -merge: combine separate channels into RGB image", "             -expand: expand indexed color to RGB", "            -bigtiff: force BigTIFF files to be written", "          -nobigtiff: do not automatically switch to BigTIFF", "        -compression: specify the codec to use when saving images", "             -series: specify which image series to convert", "             -noflat: do not flatten subresolutions", "              -cache: cache the initialized reader", "          -cache-dir: use the specified directory to store the cached", "                      initialized reader. If unspecified, the cached reader", "                      will be stored under the same folder as the image file", "             -no-sas: do not preserve the OME-XML StructuredAnnotation elements", "                -map: specify file on disk to which name should be mapped", "              -range: specify range of planes to convert (inclusive)", "            -nogroup: force multi-file datasets to be read as individual                      files", "           -nolookup: disable the conversion of lookup tables", "          -autoscale: automatically adjust brightness and contrast before", "                      converting; this may mean that the original pixel", "                      values are not preserved", "          -overwrite: always overwrite the output file, if it already exists", "        -nooverwrite: never overwrite the output file, if it already exists", "               -crop: crop images before converting; argument is 'x,y,w,h'", "            -channel: only convert the specified channel (indexed from 0)", "                  -z: only convert the specified Z section (indexed from 0)", "          -timepoint: only convert the specified timepoint (indexed from 0)", "             -padded: filename indexes for series, z, c and t will be zero padded", "             -option: add the specified key/value pair to the options list", "            -novalid: will not validate the OME-XML for the output file", "           -validate: will validate the generated OME-XML for the output file", "              -tilex: image will be converted one tile at a time using the given tile width", "              -tiley: image will be converted one tile at a time using the given tile height", "      -pyramid-scale: generates a pyramid image with each subsequent resolution level divided by scale", "-pyramid-resolutions: generates a pyramid image with the given number of resolution levels ", "      -no-sequential: do not assume that planes are written in sequential order", "               -swap: override the default input dimension order; argument is f.i. XYCTZ", "               -fill: byte value to use for undefined pixels (0-255)", "      -precompressed: transfer compressed bytes from input dataset directly to output.", "                      Most input and output formats do not support this option.", "                      Do not use -crop, -fill, or -autoscale, or pyramid generation options", "                      with this option.", "            -quality: double quality value for JPEG compression (0-1)", "", "The extension of the output file specifies the file format to use", "for the conversion. The list of available formats and extensions is:", "", ImageConverter.printList(ImageConverter.getExtensions()), "Some file formats offer multiple compression schemes that can be set", "using the -compression option. The list of available compressions is:", "", ImageConverter.printList(ImageConverter.getCompressions()), "If any of the following patterns are present in out_file, they will", "be replaced with the indicated metadata value from the input file.", "", "   Pattern:\tMetadata value:", "   ---------------------------", "   %s\t\tseries index", "   %n\t\tseries name", "   %c\t\tchannel index", "   %w\t\tchannel name", "   %z\t\tZ index", "   %t\t\tT index", "   %A\t\tacquisition timestamp", "   %x\t\trow index of the tile", "   %y\t\tcolumn index of the tile", "   %m\t\toverall tile index", "", "If any of these patterns are present, then the images to be saved", "will be split into multiple files.  For example, if the input file", "contains 5 Z sections and 3 timepoints, and out_file is", "", "  converted_Z%z_T%t.tiff", "", "then 15 files will be created, with the names", "", "  converted_Z0_T0.tiff", "  converted_Z0_T1.tiff", "  converted_Z0_T2.tiff", "  converted_Z1_T0.tiff", "  ...", "  converted_Z4_T2.tiff", "", "Each file would have a single image plane."};
        for (int i = 0; i < s.length; ++i) {
            System.out.println(s[i]);
        }
    }

    public boolean testConvert(IFormatWriter writer, String[] args) throws FormatException, IOException {
        IFormatWriter w;
        boolean ok;
        this.nextOutputIndex.clear();
        this.options.setValidate(this.validate);
        writer.setMetadataOptions((MetadataOptions)this.options);
        this.firstTile = true;
        boolean success = this.parseArgs(args);
        if (!success) {
            return false;
        }
        if (this.printVersion) {
            CommandLineTools.printVersion();
            return true;
        }
        if (this.in == null || this.out == null) {
            this.printUsage();
            return false;
        }
        if (this.precompressed && (this.width_crop > 0 || this.height_crop > 0 || this.pyramidResolutions > 1 || this.fillColor != null || this.autoscale)) {
            throw new UnsupportedOperationException("-precompressed not supported with -autoscale, -crop, -fill, -pyramid-scale, -pyramid-resolutions");
        }
        CommandLineTools.runUpgradeCheck(args);
        if (new Location(this.out).exists() && !(ok = this.overwriteCheck(this.out, false))) {
            return false;
        }
        if (this.map != null) {
            Location.mapId((String)this.in, (String)this.map);
        }
        long start = System.currentTimeMillis();
        LOGGER.info(this.in);
        this.reader = new ImageReader();
        if (this.swapOrder != null) {
            this.dimSwapper = new DimensionSwapper(this.reader);
            this.reader = this.dimSwapper;
        }
        if (this.stitch) {
            this.reader = new FileStitcher(this.reader);
            Location f = new Location(this.in);
            String pat = null;
            pat = !f.exists() ? this.in : FilePattern.findPattern((Location)f);
            if (pat != null) {
                this.in = pat;
            }
        }
        if (this.separate) {
            this.reader = new ChannelSeparator(this.reader);
        }
        if (this.merge) {
            this.reader = new ChannelMerger(this.reader);
        }
        if (this.fill) {
            this.reader = new ChannelFiller(this.reader);
        }
        if (this.useMemoizer) {
            this.reader = this.cacheDir != null ? new Memoizer(this.reader, 0L, new File(this.cacheDir)) : new Memoizer(this.reader, 0L);
        }
        this.minMax = null;
        if (this.autoscale) {
            this.reader = new MinMaxCalculator(this.reader);
            this.minMax = (MinMaxCalculator)this.reader;
        }
        this.reader.setMetadataOptions((MetadataOptions)this.options);
        this.reader.setGroupFiles(this.group);
        this.reader.setMetadataFiltered(true);
        this.reader.setOriginalMetadataPopulated(this.originalMetadata);
        this.reader.setFlattenedResolutions(this.flat);
        this.reader.setFillColor(this.fillColor);
        OMEXMLService service = null;
        try {
            ServiceFactory factory = new ServiceFactory();
            service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
            this.reader.setMetadataStore((MetadataStore)service.createOMEXMLMetadata());
        }
        catch (DependencyException de) {
            throw new MissingLibraryException(OMEXMLServiceImpl.NO_OME_XML_MSG, (Throwable)de);
        }
        catch (ServiceException se) {
            throw new FormatException((Throwable)se);
        }
        this.reader.setId(this.in);
        if (this.swapOrder != null) {
            this.dimSwapper.swapDimensions(this.swapOrder);
        }
        MetadataStore store = this.reader.getMetadataStore();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this.reader, (boolean)false, (boolean)false);
        boolean dimensionsSet = true;
        if (this.series >= 0) {
            this.reader.setSeries(this.series);
        }
        if (this.width_crop == 0 || this.height_crop == 0) {
            this.width = this.reader.getSizeX();
            this.height = this.reader.getSizeY();
            dimensionsSet = false;
        } else {
            this.width = Math.min(this.reader.getSizeX(), this.width_crop);
            this.height = Math.min(this.reader.getSizeY(), this.height_crop);
        }
        if (this.channel >= this.reader.getEffectiveSizeC()) {
            throw new FormatException("Invalid channel '" + this.channel + "' (" + this.reader.getEffectiveSizeC() + " channels in source file)");
        }
        if (this.timepoint >= this.reader.getSizeT()) {
            throw new FormatException("Invalid timepoint '" + this.timepoint + "' (" + this.reader.getSizeT() + " timepoints in source file)");
        }
        if (this.zSection >= this.reader.getSizeZ()) {
            throw new FormatException("Invalid Z section '" + this.zSection + "' (" + this.reader.getSizeZ() + " Z sections in source file)");
        }
        if (store instanceof MetadataRetrieve) {
            try {
                int c;
                List channels;
                Pixels exportPixels;
                String xml = service.getOMEXML(service.asRetrieve(store));
                OMEXMLMetadataRoot root = (OMEXMLMetadataRoot)store.getRoot();
                OMEXMLMetadata meta = service.createOMEXMLMetadata(xml);
                OMEXMLMetadataRoot newRoot = (OMEXMLMetadataRoot)meta.getRoot();
                if (this.series >= 0) {
                    Image exportImage = newRoot.getImage(this.series);
                    exportPixels = newRoot.getImage(this.series).getPixels();
                    if (this.channel >= 0) {
                        channels = exportPixels.copyChannelList();
                        for (c = 0; c < channels.size(); ++c) {
                            if (c == this.channel) continue;
                            exportPixels.removeChannel((Channel)channels.get(c));
                        }
                    }
                    exportImage.setPixels(exportPixels);
                    while (newRoot.sizeOfImageList() > 0) {
                        newRoot.removeImage(newRoot.getImage(0));
                    }
                    while (newRoot.sizeOfPlateList() > 0) {
                        newRoot.removePlate(newRoot.getPlate(0));
                    }
                    newRoot.addImage(exportImage);
                    meta.setRoot((MetadataRoot)newRoot);
                    meta.setPixelsSizeX(new PositiveInteger(Integer.valueOf(this.width)), 0);
                    meta.setPixelsSizeY(new PositiveInteger(Integer.valueOf(this.height)), 0);
                    if (this.autoscale) {
                        store.setPixelsType(PixelType.UINT8, 0);
                    }
                    if (this.channel >= 0) {
                        meta.setPixelsSizeC(new PositiveInteger(Integer.valueOf(1)), 0);
                    }
                    if (this.zSection >= 0) {
                        meta.setPixelsSizeZ(new PositiveInteger(Integer.valueOf(1)), 0);
                    }
                    if (this.timepoint >= 0) {
                        meta.setPixelsSizeT(new PositiveInteger(Integer.valueOf(1)), 0);
                    }
                    this.setupResolutions((IMetadata)meta);
                    writer.setMetadataRetrieve((MetadataRetrieve)meta);
                } else {
                    for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
                        this.reader.setSeries(i);
                        this.width = this.reader.getSizeX();
                        this.height = this.reader.getSizeY();
                        if (this.width_crop != 0 || this.height_crop != 0) {
                            this.width = Math.min(this.reader.getSizeX(), this.width_crop);
                            this.height = Math.min(this.reader.getSizeY(), this.height_crop);
                        }
                        meta.setPixelsSizeX(new PositiveInteger(Integer.valueOf(this.width)), i);
                        meta.setPixelsSizeY(new PositiveInteger(Integer.valueOf(this.height)), i);
                        if (this.autoscale) {
                            store.setPixelsType(PixelType.UINT8, i);
                        }
                        if (this.channel >= 0) {
                            exportPixels = newRoot.getImage(i).getPixels();
                            channels = exportPixels.copyChannelList();
                            for (c = 0; c < channels.size(); ++c) {
                                if (c == this.channel) continue;
                                exportPixels.removeChannel((Channel)channels.get(c));
                            }
                        }
                        if (this.channel >= 0) {
                            meta.setPixelsSizeC(new PositiveInteger(Integer.valueOf(1)), i);
                        }
                        if (this.zSection >= 0) {
                            meta.setPixelsSizeZ(new PositiveInteger(Integer.valueOf(1)), i);
                        }
                        if (this.timepoint < 0) continue;
                        meta.setPixelsSizeT(new PositiveInteger(Integer.valueOf(1)), i);
                    }
                    this.setupResolutions((IMetadata)meta);
                    writer.setMetadataRetrieve((MetadataRetrieve)meta);
                }
            }
            catch (ServiceException e) {
                throw new FormatException((Throwable)e);
            }
        }
        writer.setWriteSequentially(!this.noSequential);
        if (writer instanceof TiffWriter) {
            ((TiffWriter)writer).setBigTiff(this.bigtiff);
            ((TiffWriter)writer).setCanDetectBigTiff(!this.nobigtiff);
        } else if (writer instanceof DicomWriter) {
            ((DicomWriter)writer).setBigTiff(this.bigtiff);
        } else if (writer instanceof ImageWriter) {
            w = ((ImageWriter)writer).getWriter(this.out);
            if (w instanceof TiffWriter) {
                ((TiffWriter)w).setBigTiff(this.bigtiff);
                ((TiffWriter)w).setCanDetectBigTiff(!this.nobigtiff);
            } else if (w instanceof DicomWriter) {
                ((DicomWriter)w).setBigTiff(this.bigtiff);
            }
        }
        if (writer instanceof IExtraMetadataWriter) {
            ((IExtraMetadataWriter)writer).setExtraMetadata(this.extraMetadata);
        } else if (writer instanceof ImageWriter && (w = ((ImageWriter)writer).getWriter(this.out)) instanceof IExtraMetadataWriter) {
            ((IExtraMetadataWriter)w).setExtraMetadata(this.extraMetadata);
        }
        String format = writer.getFormat();
        LOGGER.info("[{}] -> {} [{}]", new Object[]{this.reader.getFormat(), this.out, format});
        long mid = System.currentTimeMillis();
        int total = 0;
        int num = writer.canDoStacks() ? this.reader.getSeriesCount() : 1;
        long read = 0L;
        long write = 0L;
        int first = this.series == -1 ? 0 : this.series;
        int last = this.series == -1 ? num : this.series + 1;
        long timeLastLogged = System.currentTimeMillis();
        for (int q = first; q < last; ++q) {
            this.reader.setSeries(q);
            this.nextOutputIndex.clear();
            boolean generatePyramid = this.pyramidResolutions > this.reader.getResolutionCount();
            int resolutionCount = generatePyramid ? this.pyramidResolutions : this.reader.getResolutionCount();
            for (int res = 0; res < resolutionCount; ++res) {
                if (!generatePyramid) {
                    this.reader.setResolution(res);
                }
                this.firstTile = true;
                if (!dimensionsSet) {
                    this.width = this.reader.getSizeX();
                    this.height = this.reader.getSizeY();
                    if (generatePyramid && res > 0) {
                        int scale = (int)Math.pow(this.pyramidScale, res);
                        this.width /= scale;
                        this.height /= scale;
                    }
                } else {
                    this.width = Math.min(this.reader.getSizeX(), this.width_crop);
                    this.height = Math.min(this.reader.getSizeY(), this.height_crop);
                }
                int writerSeries = this.series == -1 ? q : 0;
                writer.setSeries(writerSeries);
                writer.setResolution(res);
                writer.setInterleaved(this.reader.isInterleaved() && !this.autoscale);
                writer.setValidBitsPerPixel(this.reader.getBitsPerPixel());
                int numImages = writer.canDoStacks() ? this.reader.getImageCount() : 1;
                int startPlane = Math.max(0, this.firstPlane);
                int endPlane = Math.min(numImages, this.lastPlane);
                numImages = endPlane - startPlane;
                if (this.channel >= 0) {
                    numImages /= this.reader.getEffectiveSizeC();
                }
                if (this.zSection >= 0) {
                    numImages /= this.reader.getSizeZ();
                }
                if (this.timepoint >= 0) {
                    numImages /= this.reader.getSizeT();
                }
                total += numImages;
                if (this.precompressed) {
                    writer.setTileSizeX(this.reader.getOptimalTileWidth());
                    writer.setTileSizeY(this.reader.getOptimalTileHeight());
                } else if (this.saveTileWidth > 0 && this.saveTileHeight > 0) {
                    writer.setTileSizeX(this.saveTileWidth);
                    writer.setTileSizeY(this.saveTileHeight);
                }
                int count = 0;
                for (int i = startPlane; i < endPlane; ++i) {
                    String tileName;
                    int[] coords = this.reader.getZCTCoords(i);
                    if (this.zSection >= 0 && coords[0] != this.zSection || this.channel >= 0 && coords[1] != this.channel || this.timepoint >= 0 && coords[2] != this.timepoint) continue;
                    String outputName = FormatTools.getFilename((int)q, (int)i, (IFormatReader)this.reader, (String)this.out, (boolean)this.zeroPadding);
                    if (outputName.equals(tileName = FormatTools.getTileFilename((int)0, (int)0, (int)0, (String)outputName))) {
                        boolean ok2 = this.overwriteCheck(outputName, false);
                        if (!ok2) {
                            return false;
                        }
                        this.setCodecOptions(writer);
                        writer.setId(outputName);
                        if (this.compression != null) {
                            writer.setCompression(this.compression);
                        }
                    } else {
                        int tileNum = outputName.indexOf("%m");
                        int tileX = outputName.indexOf("%x");
                        int tileY = outputName.indexOf("%y");
                        if (tileNum < 0 && (tileX < 0 || tileY < 0)) {
                            throw new FormatException("Invalid file name pattern; %m or both of %x and %y must be specified.");
                        }
                        if (this.saveTileWidth == 0 && this.saveTileHeight == 0) {
                            boolean ok3 = this.overwriteCheck(tileName, false);
                            if (!ok3) {
                                return false;
                            }
                            this.setCodecOptions(writer);
                            writer.setId(tileName);
                            if (this.compression != null) {
                                writer.setCompression(this.compression);
                            }
                        }
                    }
                    int outputIndex = 0;
                    if (this.nextOutputIndex.containsKey(outputName)) {
                        outputIndex = this.nextOutputIndex.get(outputName);
                    }
                    long s = System.currentTimeMillis();
                    long m = this.convertPlane(writer, i, outputIndex, outputName);
                    long e = System.currentTimeMillis();
                    read += m - s;
                    write += e - m;
                    this.nextOutputIndex.put(outputName, outputIndex + 1);
                    if (i == endPlane - 1) {
                        this.nextOutputIndex.remove(outputName);
                    }
                    if (count == numImages - 1 || (e - timeLastLogged) / 1000L > 0L) {
                        int current = count - startPlane + 1;
                        int percent = 100 * current / numImages;
                        StringBuilder sb = new StringBuilder();
                        sb.append("\t");
                        int numSeries = last - first;
                        if (numSeries > 1) {
                            sb.append("Series ");
                            sb.append(q);
                            sb.append(": converted ");
                        } else {
                            sb.append("Converted ");
                        }
                        LOGGER.info(sb.toString() + "{}/{} planes ({}%)", new Object[]{current, numImages, percent});
                        timeLastLogged = e;
                    }
                    ++count;
                }
            }
        }
        writer.close();
        long end = System.currentTimeMillis();
        LOGGER.info("[done]");
        float sec = (float)(end - start) / 1000.0f;
        long initial = mid - start;
        float readAvg = (float)read / (float)total;
        float writeAvg = (float)write / (float)total;
        LOGGER.info("{}s elapsed ({}+{}ms per plane, {}ms overhead)", new Object[]{Float.valueOf(sec), Float.valueOf(readAvg), Float.valueOf(writeAvg), initial});
        return true;
    }

    private long convertPlane(IFormatWriter writer, int index, int outputIndex, String currentFile) throws FormatException, IOException {
        if (this.doTileConversion(writer, currentFile) && this.isTiledWriter(writer, this.out)) {
            return this.convertTilePlane(writer, index, outputIndex, currentFile);
        }
        this.tryPrecompressed = this.precompressed && FormatTools.canUsePrecompressedTiles((IFormatReader)this.reader, (IFormatWriter)writer, (int)writer.getSeries(), (int)writer.getResolution());
        byte[] buf = this.getTile(this.reader, writer.getResolution(), index, this.xCoordinate, this.yCoordinate, this.width, this.height);
        if (this.precompressed && !this.tryPrecompressed) {
            LOGGER.warn("Decompressed tile: series={}, resolution={}, x={}, y={}", new Object[]{writer.getSeries(), writer.getResolution(), this.xCoordinate, this.yCoordinate});
        }
        this.autoscalePlane(buf, index);
        this.applyLUT(writer);
        long m = System.currentTimeMillis();
        if (this.tryPrecompressed) {
            writer.saveCompressedBytes(outputIndex, buf, 0, 0, this.reader.getSizeX(), this.reader.getSizeY());
        } else {
            writer.saveBytes(outputIndex, buf);
        }
        return m;
    }

    private long convertTilePlane(IFormatWriter writer, int index, int outputIndex, String currentFile) throws FormatException, IOException {
        boolean canPrecompressResolution;
        int w = Math.min(this.reader.getOptimalTileWidth(), this.width);
        int h = Math.min(this.reader.getOptimalTileHeight(), this.height);
        if (this.saveTileWidth > 0 && this.saveTileWidth <= this.width) {
            w = this.saveTileWidth;
        }
        if (this.saveTileHeight > 0 && this.saveTileHeight <= this.height) {
            h = this.saveTileHeight;
        }
        IFormatWriter baseWriter = ((ImageWriter)writer).getWriter(this.out);
        w = baseWriter.setTileSizeX(w);
        h = baseWriter.setTileSizeY(h);
        if (this.firstTile) {
            LOGGER.info("Tile size = {} x {}", (Object)w, (Object)h);
            this.firstTile = false;
        }
        int nXTiles = this.width / w;
        int nYTiles = this.height / h;
        if (nXTiles * w != this.width) {
            ++nXTiles;
        }
        if (nYTiles * h != this.height) {
            ++nYTiles;
        }
        boolean bl = canPrecompressResolution = this.precompressed && FormatTools.canUsePrecompressedTiles((IFormatReader)this.reader, (IFormatWriter)writer, (int)writer.getSeries(), (int)writer.getResolution());
        if (this.precompressed && !canPrecompressResolution) {
            LOGGER.warn("Decompressing resolution: series={}, resolution={}", (Object)writer.getSeries(), (Object)writer.getResolution());
            this.tryPrecompressed = false;
        }
        Long m = null;
        for (int y = 0; y < nYTiles; ++y) {
            for (int x = 0; x < nXTiles; ++x) {
                String tileName;
                int tileX = this.xCoordinate + x * w;
                int tileY = this.yCoordinate + y * h;
                int tileWidth = x < nXTiles - 1 ? w : this.width - w * x;
                int tileHeight = y < nYTiles - 1 ? h : this.height - h * y;
                this.tryPrecompressed = this.precompressed && canPrecompressResolution && FormatTools.canUsePrecompressedTiles((IFormatReader)this.reader, (IFormatWriter)writer, (int)writer.getSeries(), (int)writer.getResolution());
                byte[] buf = this.getTile(this.reader, writer.getResolution(), index, tileX, tileY, tileWidth, tileHeight);
                if (this.precompressed && canPrecompressResolution && !this.tryPrecompressed) {
                    LOGGER.warn("Decompressed tile: series={}, resolution={}, x={}, y={}", new Object[]{writer.getSeries(), writer.getResolution(), x, y});
                }
                if (!currentFile.equals(tileName = FormatTools.getTileFilename((int)x, (int)y, (int)(y * nXTiles + x), (String)currentFile))) {
                    int writerSeries;
                    int nTileRows = this.getTileRows(currentFile);
                    int nTileCols = this.getTileColumns(currentFile);
                    int sizeX = nTileCols == 1 ? this.width : tileWidth;
                    int sizeY = nTileRows == 1 ? this.height : tileHeight;
                    MetadataRetrieve retrieve = writer.getMetadataRetrieve();
                    writer.close();
                    int n = writerSeries = this.series == -1 ? this.reader.getSeries() : 0;
                    if (retrieve instanceof MetadataStore) {
                        ((MetadataStore)retrieve).setPixelsSizeX(new PositiveInteger(Integer.valueOf(sizeX)), writerSeries);
                        ((MetadataStore)retrieve).setPixelsSizeY(new PositiveInteger(Integer.valueOf(sizeY)), writerSeries);
                        this.setupResolutions((IMetadata)retrieve);
                    }
                    writer.setMetadataRetrieve(retrieve);
                    this.overwriteCheck(tileName, true);
                    this.setCodecOptions(writer);
                    writer.setId(tileName);
                    if (this.compression != null) {
                        writer.setCompression(this.compression);
                    }
                    outputIndex = 0;
                    if (this.nextOutputIndex.containsKey(tileName)) {
                        outputIndex = this.nextOutputIndex.get(tileName);
                    }
                    this.nextOutputIndex.put(tileName, outputIndex + 1);
                    if (nTileRows > 1) {
                        tileY = 0;
                        tileHeight = baseWriter.setTileSizeY(tileHeight);
                    }
                    if (nTileCols > 1) {
                        tileX = 0;
                        tileWidth = baseWriter.setTileSizeX(tileWidth);
                    }
                }
                this.autoscalePlane(buf, index);
                this.applyLUT(writer);
                if (m == null) {
                    m = System.currentTimeMillis();
                }
                int outputX = x * w;
                int outputY = y * h;
                if (currentFile.indexOf("%m") >= 0 || currentFile.indexOf("%x") >= 0 || currentFile.indexOf("%y") >= 0) {
                    outputX = 0;
                    outputY = 0;
                }
                if (this.tryPrecompressed) {
                    writer.saveCompressedBytes(outputIndex, buf, outputX, outputY, tileWidth, tileHeight);
                    continue;
                }
                writer.saveBytes(outputIndex, buf, outputX, outputY, tileWidth, tileHeight);
            }
        }
        return m;
    }

    private int getTileRows(String outputName) {
        if (outputName.indexOf("%y") >= 0 || outputName.indexOf("%m") >= 0) {
            int nYTiles;
            int h = this.reader.getOptimalTileHeight();
            if (this.saveTileHeight > 0 && this.saveTileHeight <= this.height) {
                h = this.saveTileHeight;
            }
            if ((nYTiles = this.height / h) * h != this.height) {
                ++nYTiles;
            }
            return nYTiles;
        }
        return 1;
    }

    public int getTileColumns(String outputName) {
        if (outputName.indexOf("%x") >= 0 || outputName.indexOf("%m") >= 0) {
            int nXTiles;
            int w = this.reader.getOptimalTileWidth();
            if (this.saveTileWidth > 0 && this.saveTileWidth <= this.width) {
                w = this.saveTileWidth;
            }
            if ((nXTiles = this.width / w) * w != this.width) {
                ++nXTiles;
            }
            return nXTiles;
        }
        return 1;
    }

    private void autoscalePlane(byte[] buf, int index) throws FormatException, IOException {
        if (this.autoscale && !this.tryPrecompressed) {
            Double min = null;
            Double max = null;
            Double[] planeMin = this.minMax.getPlaneMinimum(index);
            Double[] planeMax = this.minMax.getPlaneMaximum(index);
            if (planeMin != null && planeMax != null) {
                min = planeMin[0];
                max = planeMax[0];
                for (int j = 1; j < planeMin.length; ++j) {
                    if (planeMin[j] < min) {
                        min = planeMin[j];
                    }
                    if (!(planeMax[j] < max)) continue;
                    max = planeMax[j];
                }
            }
            int pixelType = this.reader.getPixelType();
            int bpp = FormatTools.getBytesPerPixel((int)pixelType);
            boolean floatingPoint = FormatTools.isFloatingPoint((int)pixelType);
            Object pix = DataTools.makeDataArray((byte[])buf, (int)bpp, (boolean)floatingPoint, (boolean)this.reader.isLittleEndian());
            byte[][] b = ImageTools.make24Bits((Object)pix, (int)this.width, (int)this.height, (boolean)this.reader.isInterleaved(), (boolean)false, (Double)min, (Double)max);
            int channelCount = this.reader.getRGBChannelCount();
            int copyComponents = Math.min(channelCount, b.length);
            buf = new byte[channelCount * b[0].length];
            for (int j = 0; j < copyComponents; ++j) {
                System.arraycopy(b[j], 0, buf, b[0].length * j, b[0].length);
            }
        }
    }

    private void applyLUT(IFormatWriter writer) throws FormatException, IOException {
        if (this.lookup) {
            byte[][] lut = this.reader.get8BitLookupTable();
            if (lut != null) {
                IndexColorModel model = new IndexColorModel(8, lut[0].length, lut[0], lut[1], lut[2]);
                writer.setColorModel((ColorModel)model);
            } else {
                short[][] lut16 = this.reader.get16BitLookupTable();
                if (lut16 != null) {
                    Index16ColorModel model = new Index16ColorModel(16, lut16[0].length, lut16, this.reader.isLittleEndian());
                    writer.setColorModel((ColorModel)model);
                }
            }
        }
    }

    private void setupResolutions(IMetadata meta) {
        if (!(meta instanceof OMEPyramidStore)) {
            return;
        }
        for (int series = 0; series < meta.getImageCount(); ++series) {
            int width = (Integer)meta.getPixelsSizeX(series).getValue();
            int height = (Integer)meta.getPixelsSizeY(series).getValue();
            for (int i = 1; i < this.pyramidResolutions; ++i) {
                int scale = (int)Math.pow(this.pyramidScale, i);
                ((OMEPyramidStore)meta).setResolutionSizeX(new PositiveInteger(Integer.valueOf(width / scale)), series, i);
                ((OMEPyramidStore)meta).setResolutionSizeY(new PositiveInteger(Integer.valueOf(height / scale)), series, i);
            }
        }
    }

    private byte[] getTile(IFormatReader reader, int resolution, int no, int x, int y, int w, int h) throws FormatException, IOException {
        if (resolution < reader.getResolutionCount()) {
            reader.setResolution(resolution);
            int optimalWidth = reader.getOptimalTileWidth();
            int optimalHeight = reader.getOptimalTileHeight();
            if (this.tryPrecompressed) {
                return reader.openCompressedBytes(no, x / optimalWidth, y / optimalHeight);
            }
            this.tryPrecompressed = false;
            return reader.openBytes(no, x, y, w, h);
        }
        if (this.tryPrecompressed) {
            throw new UnsupportedOperationException("Cannot generate resolutions with precompressed tiles");
        }
        reader.setResolution(0);
        SimpleImageScaler scaler = new SimpleImageScaler();
        int scale = (int)Math.pow(this.pyramidScale, resolution);
        byte[] tile = reader.openBytes(no, x * scale, y * scale, w * scale, h * scale);
        int type = reader.getPixelType();
        return scaler.downsample(tile, w * scale, h * scale, (double)scale, FormatTools.getBytesPerPixel((int)type), reader.isLittleEndian(), FormatTools.isFloatingPoint((int)type), reader.getRGBChannelCount(), reader.isInterleaved());
    }

    private boolean isTiledWriter(IFormatWriter writer, String outputFile) throws FormatException {
        if (writer instanceof ImageWriter) {
            return this.isTiledWriter(((ImageWriter)writer).getWriter(outputFile), outputFile);
        }
        return writer instanceof TiffWriter || writer instanceof DicomWriter;
    }

    private boolean doTileConversion(IFormatWriter writer, String outputFile) throws FormatException {
        if (writer instanceof DicomWriter || writer instanceof ImageWriter && ((ImageWriter)writer).getWriter(outputFile) instanceof DicomWriter) {
            MetadataStore r = this.reader.getMetadataStore();
            return !(r instanceof IPyramidStore) || ((IPyramidStore)r).getResolutionCount(this.reader.getSeries()) > 1;
        }
        return DataTools.safeMultiply64((long[])new long[]{this.width, this.height}) >= DataTools.safeMultiply64((long[])new long[]{4096L, 4096L}) || this.saveTileWidth > 0 || this.saveTileHeight > 0;
    }

    private boolean overwriteCheck(String path, boolean throwOnExist) throws IOException {
        if (this.checkedPaths.containsKey(path)) {
            return this.checkedPaths.get(path);
        }
        if (!new Location(path).exists()) {
            this.checkedPaths.put(path, true);
            return true;
        }
        if (this.overwrite == null) {
            LOGGER.warn("Output file {} exists.", (Object)path);
            LOGGER.warn("Do you want to overwrite it? ([y]/n)");
            BufferedReader r = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
            String choice = r.readLine().trim().toLowerCase();
            this.overwrite = !choice.startsWith("n");
        }
        if (!this.overwrite.booleanValue()) {
            String msg = "Exiting; next time, please specify an output file that does not exist.";
            this.checkedPaths.put(path, false);
            if (throwOnExist) {
                throw new IOException(msg);
            }
            LOGGER.warn(msg);
            return false;
        }
        new Location(path).delete();
        this.checkedPaths.put(path, true);
        return true;
    }

    private void setCodecOptions(IFormatWriter writer) {
        if (this.compressionQuality != null) {
            JPEG2000CodecOptions codecOptions = JPEG2000CodecOptions.getDefaultOptions();
            codecOptions.quality = this.compressionQuality;
            writer.setCodecOptions((CodecOptions)codecOptions);
        }
    }

    public static void main(String[] args) throws FormatException, IOException {
        DebugTools.enableLogging((String)"INFO");
        ImageConverter converter = new ImageConverter();
        if (!converter.testConvert((IFormatWriter)new ImageWriter(), args)) {
            System.exit(1);
        }
        System.exit(0);
    }
}

