/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.scijava.java3d.BoundingBox;
import org.scijava.java3d.Bounds;
import org.scijava.java3d.CachedTargets;
import org.scijava.java3d.Canvas3D;
import org.scijava.java3d.Font3D;
import org.scijava.java3d.GeometryArrayRetained;
import org.scijava.java3d.GeometryAtom;
import org.scijava.java3d.GeometryRetained;
import org.scijava.java3d.GroupRetained;
import org.scijava.java3d.J3dMessage;
import org.scijava.java3d.NnuId;
import org.scijava.java3d.NodeRetained;
import org.scijava.java3d.PickInfo;
import org.scijava.java3d.PickShape;
import org.scijava.java3d.RenderAtom;
import org.scijava.java3d.Shape3DRetained;
import org.scijava.java3d.TargetsInterface;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.VirtualUniverse;
import org.scijava.vecmath.Point3d;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Vector3f;

class Text3DRetained
extends GeometryRetained {
    Font3D font3D = null;
    String string = null;
    Point3f position = new Point3f(0.0f, 0.0f, 0.0f);
    int alignment = 1;
    int path = 1;
    float charSpacing = 0.0f;
    int numChars = 0;
    static final int targetThreads = 8384;
    Transform3D[] charTransforms = new Transform3D[0];
    GeometryArrayRetained[] geometryList = new GeometryArrayRetained[0];
    GlyphVector[] glyphVecs = new GlyphVector[0];
    Point3d lower = new Point3d();
    Point3d upper = new Point3d();
    ArrayList newGeometryAtomList = new ArrayList();
    ArrayList oldGeometryAtomList = new ArrayList();
    Transform3D vpcToEc;
    Transform3D drawTransform;

    Text3DRetained() {
        this.geoType = 16;
    }

    @Override
    synchronized void computeBoundingBox() {
        Point3d l = new Point3d();
        Point3d u = new Point3d();
        Vector3f location = new Vector3f(this.position);
        int k = 0;
        int numTotal = 0;
        double width = 0.0;
        double height = 0.0;
        l.set(location);
        u.set(location);
        if (this.numChars != 0) {
            Rectangle2D bounds;
            if (this.path == 1 || this.path == 2) {
                k = 0;
                numTotal = this.numChars + 1;
            } else if (this.path == 0 || this.path == 3) {
                k = 1;
                numTotal = this.numChars;
                bounds = this.glyphVecs[0].getVisualBounds();
                u.x += bounds.getWidth();
                u.y += bounds.getHeight();
            }
            int i = 1;
            while (i < numTotal) {
                width = this.glyphVecs[k].getLogicalBounds().getWidth();
                bounds = this.glyphVecs[k].getVisualBounds();
                width += (double)this.charSpacing;
                height = bounds.getHeight();
                switch (this.path) {
                    case 1: {
                        u.x += width;
                        if (!(u.y < height + (double)location.y)) break;
                        u.y = (double)location.y + height;
                        break;
                    }
                    case 0: {
                        l.x -= width;
                        if (!(u.y < height + (double)location.y)) break;
                        u.y = (double)location.y + height;
                        break;
                    }
                    case 2: {
                        u.y += height;
                        if (!(u.x < bounds.getWidth() + (double)location.x)) break;
                        u.x = (double)location.x + bounds.getWidth();
                        break;
                    }
                    case 3: {
                        l.y -= height;
                        if (!(u.x < bounds.getWidth() + (double)location.x)) break;
                        u.x = (double)location.x + bounds.getWidth();
                    }
                }
                ++i;
                ++k;
            }
            if (this.alignment != 1) {
                double cx = u.x - l.x;
                double cy = u.y - l.y;
                if (this.alignment == 0) {
                    cx *= 0.5;
                    cy *= 0.5;
                }
                switch (this.path) {
                    case 1: {
                        l.x -= cx;
                        u.x -= cx;
                        break;
                    }
                    case 0: {
                        l.x += cx;
                        u.x += cx;
                        break;
                    }
                    case 2: {
                        l.y -= cy;
                        u.y -= cy;
                        break;
                    }
                    case 3: {
                        l.y += cy;
                        u.y += cy;
                    }
                }
            }
        }
        l.z = 0.0;
        u.z = this.font3D == null || this.font3D.fontExtrusion == null ? l.z : l.z + (double)this.font3D.fontExtrusion.length;
    }

    @Override
    void update() {
    }

    final Font3D getFont3D() {
        return this.font3D;
    }

    final void setFont3D(Font3D font3d) {
        this.geomLock.getLock();
        this.font3D = font3d;
        this.updateCharacterData();
        this.geomLock.unLock();
        this.sendDataChangedMessage();
    }

    final String getString() {
        return this.string;
    }

    final void setString(String string) {
        this.geomLock.getLock();
        this.string = string;
        this.numChars = string == null ? 0 : string.length();
        this.updateCharacterData();
        this.geomLock.unLock();
        this.sendDataChangedMessage();
    }

    final void getPosition(Point3f position) {
        position.set(this.position);
    }

    final void setPosition(Point3f position) {
        this.geomLock.getLock();
        this.position.set(position);
        this.updateTransformData();
        this.geomLock.unLock();
        this.sendTransformChangedMessage();
    }

    final int getAlignment() {
        return this.alignment;
    }

    final void setAlignment(int alignment) {
        this.geomLock.getLock();
        this.alignment = alignment;
        this.updateTransformData();
        this.geomLock.unLock();
        this.sendTransformChangedMessage();
    }

    final int getPath() {
        return this.path;
    }

    final void setPath(int path) {
        this.path = path;
        this.updateTransformData();
        this.sendTransformChangedMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void getBoundingBox(BoundingBox bounds) {
        Text3DRetained text3DRetained = this;
        synchronized (text3DRetained) {
            bounds.setLower(this.lower);
            bounds.setUpper(this.upper);
        }
    }

    final float getCharacterSpacing() {
        return this.charSpacing;
    }

    final void setCharacterSpacing(float characterSpacing) {
        this.geomLock.getLock();
        this.charSpacing = characterSpacing;
        this.updateTransformData();
        this.geomLock.unLock();
        this.sendTransformChangedMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sendDataChangedMessage() {
        ArrayList<TargetsInterface> tiArrList = new ArrayList<TargetsInterface>();
        ArrayList<CachedTargets[]> newCtArrArrList = new ArrayList<CachedTargets[]>();
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                ArrayList arrayList = this.universeList;
                synchronized (arrayList) {
                    int numMessages = this.universeList.size();
                    J3dMessage[] m = new J3dMessage[numMessages];
                    for (int i = 0; i < numMessages; ++i) {
                        int k;
                        int j;
                        m[i] = new J3dMessage();
                        m[i].type = 26;
                        m[i].threads = 8384;
                        ArrayList shapeList = (ArrayList)this.userLists.get(i);
                        this.newGeometryAtomList.clear();
                        this.oldGeometryAtomList.clear();
                        for (j = 0; j < shapeList.size(); ++j) {
                            int gaCnt;
                            Shape3DRetained s = (Shape3DRetained)shapeList.get(j);
                            if (s.boundsAutoCompute) {
                                s.getCombineBounds((BoundingBox)s.bounds);
                            }
                            int gSize = s.geometryList.size();
                            GeometryAtom oldGA = Shape3DRetained.getGeomAtom(s);
                            GeometryAtom newGA = new GeometryAtom();
                            int geometryCnt = 0;
                            for (k = 0; k < gSize; ++k) {
                                GeometryRetained geomRetained = s.geometryList.get(k);
                                if (geomRetained != null) {
                                    Text3DRetained tempT3d = (Text3DRetained)geomRetained;
                                    geometryCnt += tempT3d.numChars;
                                    continue;
                                }
                                ++geometryCnt;
                            }
                            newGA.geometryArray = new GeometryRetained[geometryCnt];
                            newGA.lastLocalTransformArray = new Transform3D[geometryCnt];
                            geometryCnt = 0;
                            newGA.locale = s.locale;
                            newGA.visible = s.visible;
                            newGA.source = s;
                            GeometryRetained geometry = null;
                            for (gaCnt = 0; gaCnt < gSize; ++gaCnt) {
                                geometry = s.geometryList.get(gaCnt);
                                if (geometry == null) continue;
                                newGA.geoType = geometry.geoType;
                                newGA.alphaEditable = s.isAlphaEditable(geometry);
                                break;
                            }
                            while (gaCnt < gSize) {
                                geometry = s.geometryList.get(gaCnt);
                                if (geometry == null) {
                                    newGA.geometryArray[gaCnt] = null;
                                } else {
                                    Text3DRetained t = (Text3DRetained)geometry;
                                    k = 0;
                                    while (k < t.numChars) {
                                        GeometryArrayRetained geo = t.geometryList[k];
                                        if (geo != null) {
                                            newGA.geometryArray[geometryCnt] = geo;
                                            newGA.lastLocalTransformArray[geometryCnt] = t.charTransforms[k];
                                        } else {
                                            newGA.geometryArray[geometryCnt] = null;
                                            newGA.lastLocalTransformArray[geometryCnt] = null;
                                        }
                                        ++k;
                                        ++geometryCnt;
                                    }
                                }
                                ++gaCnt;
                            }
                            this.oldGeometryAtomList.add(oldGA);
                            this.newGeometryAtomList.add(newGA);
                            Shape3DRetained.setGeomAtom(s, newGA);
                        }
                        Object[] oldGAArray = this.oldGeometryAtomList.toArray();
                        Object[] newGAArray = this.newGeometryAtomList.toArray();
                        ArrayList uniqueList = this.getUniqueSource(shapeList);
                        int numSrc = uniqueList.size();
                        for (j = 0; j < numSrc; ++j) {
                            CachedTargets[] newCtArr = null;
                            Shape3DRetained src = (Shape3DRetained)uniqueList.get(j);
                            int numMS3D = src.mirrorShape3D.size();
                            TargetsInterface ti = ((GroupRetained)src.parent).getClosestTargetsInterface(0);
                            if (ti == null) continue;
                            newCtArr = new CachedTargets[numMS3D];
                            for (k = 0; k < numMS3D; ++k) {
                                CachedTargets ct;
                                int kk;
                                Shape3DRetained ms = src.mirrorShape3D.get(k);
                                GeometryAtom ga = Shape3DRetained.getGeomAtom(ms);
                                for (kk = 0; kk < newGAArray.length && ga != newGAArray[kk]; ++kk) {
                                }
                                if (kk == newGAArray.length) {
                                    System.err.println("Text3DRetained : Problem !!! Can't find matching geomAtom");
                                }
                                if ((ct = ti.getCachedTargets(0, k, -1)) != null) {
                                    newCtArr[k] = new CachedTargets();
                                    newCtArr[k].copy(ct);
                                    newCtArr[k].replace((NnuId)oldGAArray[kk], (NnuId)newGAArray[kk], 0);
                                    continue;
                                }
                                newCtArr[k] = null;
                            }
                            ti.resetCachedTargets(0, newCtArr, -1);
                            tiArrList.add(ti);
                            newCtArrArrList.add(newCtArr);
                        }
                        m[i].args[0] = oldGAArray;
                        m[i].args[1] = newGAArray;
                        m[i].universe = (VirtualUniverse)this.universeList.get(i);
                        if (tiArrList.size() > 0) {
                            m[i].args[2] = tiArrList.toArray();
                            m[i].args[3] = newCtArrArrList.toArray();
                        }
                        tiArrList.clear();
                        newCtArrArrList.clear();
                    }
                    VirtualUniverse.mc.processMessage(m);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sendTransformChangedMessage() {
        ArrayList<GeometryAtom> gaList = new ArrayList<GeometryAtom>();
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                ArrayList arrayList = this.universeList;
                synchronized (arrayList) {
                    int numMessages = this.universeList.size();
                    J3dMessage[] m = new J3dMessage[numMessages];
                    for (int i = 0; i < numMessages; ++i) {
                        m[i] = new J3dMessage();
                        m[i].type = 25;
                        m[i].threads = 8384;
                        ArrayList shapeList = (ArrayList)this.userLists.get(i);
                        for (int j = 0; j < shapeList.size(); ++j) {
                            GeometryRetained geomR;
                            int sCnt;
                            Shape3DRetained s = (Shape3DRetained)shapeList.get(j);
                            for (sCnt = 0; sCnt < s.geometryList.size() && (geomR = s.geometryList.get(sCnt)) != this; ++sCnt) {
                            }
                            if (sCnt >= s.geometryList.size()) continue;
                            gaList.add(Shape3DRetained.getGeomAtom(s));
                        }
                        m[i].args[0] = gaList.toArray();
                        m[i].args[1] = this.charTransforms;
                        m[i].universe = (VirtualUniverse)this.universeList.get(i);
                    }
                    VirtualUniverse.mc.processMessage(m);
                }
            }
        }
    }

    final void updateCharacterData() {
        char[] c = new char[1];
        if (this.geometryList.length != this.numChars) {
            this.geometryList = new GeometryArrayRetained[this.numChars];
            this.glyphVecs = new GlyphVector[this.numChars];
        }
        if (this.font3D != null) {
            for (int i = 0; i < this.numChars; ++i) {
                c[0] = this.string.charAt(i);
                this.glyphVecs[i] = this.font3D.font.createGlyphVector(this.font3D.frc, c);
                this.geometryList[i] = this.font3D.triangulateGlyphs(this.glyphVecs[i], c[0]);
            }
        }
        this.updateTransformData();
    }

    final void updateTransformData() {
        int i;
        int k = 0;
        int numTotal = 0;
        double width = 0.0;
        double height = 0.0;
        Vector3f location = new Vector3f(this.position);
        this.lower.set(location);
        this.upper.set(location);
        this.charTransforms = new Transform3D[this.numChars];
        for (i = 0; i < this.numChars; ++i) {
            this.charTransforms[i] = new Transform3D();
        }
        if (this.numChars != 0) {
            Rectangle2D bounds;
            this.charTransforms[0].set(location);
            if (this.path == 1 || this.path == 2) {
                k = 0;
                numTotal = this.numChars + 1;
            } else if (this.path == 0 || this.path == 3) {
                k = 1;
                numTotal = this.numChars;
                bounds = this.glyphVecs[0].getVisualBounds();
                this.upper.x += bounds.getWidth();
                this.upper.y += bounds.getHeight();
            }
            i = 1;
            while (i < numTotal) {
                width = this.glyphVecs[k].getLogicalBounds().getWidth();
                bounds = this.glyphVecs[k].getVisualBounds();
                width += (double)this.charSpacing;
                height = bounds.getHeight();
                switch (this.path) {
                    case 1: {
                        location.x = (float)((double)location.x + width);
                        this.upper.x += width;
                        if (!(this.upper.y < height + (double)location.y)) break;
                        this.upper.y = (double)location.y + height;
                        break;
                    }
                    case 0: {
                        location.x = (float)((double)location.x - width);
                        this.lower.x -= width;
                        if (!(this.upper.y < height + (double)location.y)) break;
                        this.upper.y = (double)location.y + height;
                        break;
                    }
                    case 2: {
                        location.y = (float)((double)location.y + height);
                        this.upper.y += height;
                        if (!(this.upper.x < bounds.getWidth() + (double)location.x)) break;
                        this.upper.x = (double)location.x + bounds.getWidth();
                        break;
                    }
                    case 3: {
                        location.y = (float)((double)location.y - height);
                        this.lower.y -= height;
                        if (!(this.upper.x < bounds.getWidth() + (double)location.x)) break;
                        this.upper.x = (double)location.x + bounds.getWidth();
                    }
                }
                if (i < this.numChars) {
                    this.charTransforms[i].set(location);
                }
                ++i;
                ++k;
            }
            if (this.alignment != 1) {
                double cx = this.upper.x - this.lower.x;
                double cy = this.upper.y - this.lower.y;
                if (this.alignment == 0) {
                    cx *= 0.5;
                    cy *= 0.5;
                }
                switch (this.path) {
                    case 1: {
                        for (i = 0; i < this.numChars; ++i) {
                            this.charTransforms[i].mat[3] = this.charTransforms[i].mat[3] - cx;
                        }
                        this.lower.x -= cx;
                        this.upper.x -= cx;
                        break;
                    }
                    case 0: {
                        for (i = 0; i < this.numChars; ++i) {
                            this.charTransforms[i].mat[3] = this.charTransforms[i].mat[3] + cx;
                        }
                        this.lower.x += cx;
                        this.upper.x += cx;
                        break;
                    }
                    case 2: {
                        for (i = 0; i < this.numChars; ++i) {
                            this.charTransforms[i].mat[7] = this.charTransforms[i].mat[7] - cy;
                        }
                        this.lower.y -= cy;
                        this.upper.y -= cy;
                        break;
                    }
                    case 3: {
                        for (i = 0; i < this.numChars; ++i) {
                            this.charTransforms[i].mat[7] = this.charTransforms[i].mat[7] + cy;
                        }
                        this.lower.y += cy;
                        this.upper.y += cy;
                    }
                }
            }
        }
        this.lower.z = 0.0;
        this.upper.z = this.font3D == null || this.font3D.fontExtrusion == null ? this.lower.z : this.lower.z + (double)this.font3D.fontExtrusion.length;
        this.getBoundingBox(this.geoBounds);
    }

    @Override
    void setLive(boolean inBackgroundGroup, int refCount) {
        this.updateCharacterData();
        super.doSetLive(inBackgroundGroup, refCount);
        super.markAsLive();
    }

    @Override
    boolean intersect(PickShape pickShape, PickInfo pickInfo, int flags, Point3d iPnt, GeometryRetained geom, int geomIndex) {
        Transform3D tempT3D = new Transform3D();
        GeometryArrayRetained geo = null;
        int sIndex = -1;
        double minDist = Double.MAX_VALUE;
        double distance = 0.0;
        Point3d closestIPnt = new Point3d();
        for (int i = 0; i < this.numChars; ++i) {
            geo = this.geometryList[i];
            if (geo == null) continue;
            tempT3D.invert(this.charTransforms[i]);
            PickShape newPS = pickShape.transform(tempT3D);
            if (!geo.intersect(newPS, pickInfo, flags, iPnt, geom, geomIndex)) continue;
            if (flags == 0) {
                return true;
            }
            distance = newPS.distance(iPnt);
            if (!(distance < minDist)) continue;
            sIndex = i;
            minDist = distance;
            closestIPnt.set(iPnt);
        }
        if (sIndex >= 0) {
            iPnt.set(closestIPnt);
            this.charTransforms[sIndex].transform(iPnt);
            return true;
        }
        return false;
    }

    @Override
    boolean intersect(Point3d[] pnts) {
        Transform3D tempT3D = new Transform3D();
        boolean isIntersect = false;
        Point3d[] transPnts = new Point3d[pnts.length];
        for (int j = pnts.length - 1; j >= 0; --j) {
            transPnts[j] = new Point3d();
        }
        for (int i = this.numChars - 1; i >= 0; --i) {
            GeometryArrayRetained ga = this.geometryList[i];
            if (ga == null) continue;
            tempT3D.invert(this.charTransforms[i]);
            for (int j = pnts.length - 1; j >= 0; --j) {
                tempT3D.transform(pnts[j], transPnts[j]);
            }
            if (!ga.intersect(transPnts)) continue;
            isIntersect = true;
            break;
        }
        return isIntersect;
    }

    @Override
    boolean intersect(Transform3D thisToOtherVworld, GeometryRetained geom) {
        for (int i = this.numChars - 1; i >= 0; --i) {
            GeometryArrayRetained ga = this.geometryList[i];
            if (ga == null || !ga.intersect(thisToOtherVworld, geom)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean intersect(Bounds targetBound) {
        for (int i = this.numChars - 1; i >= 0; --i) {
            GeometryArrayRetained ga = this.geometryList[i];
            if (ga == null || !ga.intersect(targetBound)) continue;
            return true;
        }
        return false;
    }

    void setModelViewMatrix(Transform3D vpcToEc, Transform3D drawTransform) {
        this.vpcToEc = vpcToEc;
        this.drawTransform = drawTransform;
    }

    @Override
    void execute(Canvas3D cv, RenderAtom ra, boolean isNonUniformScale, boolean updateAlpha, float alpha, int screen, boolean ignoreVertexColors) {
        Transform3D trans = new Transform3D();
        for (int i = 0; i < this.geometryList.length; ++i) {
            trans.set(this.drawTransform);
            trans.mul(this.charTransforms[i]);
            cv.setModelViewMatrix(cv.ctx, this.vpcToEc.mat, trans);
            this.geometryList[i].execute(cv, ra, isNonUniformScale, updateAlpha, alpha, screen, ignoreVertexColors);
        }
    }

    @Override
    int getClassType() {
        return 6;
    }

    ArrayList getUniqueSource(ArrayList shapeList) {
        ArrayList<NodeRetained> uniqueList = new ArrayList<NodeRetained>();
        int size = shapeList.size();
        for (int i = 0; i < size; ++i) {
            NodeRetained src = ((Shape3DRetained)shapeList.get((int)i)).sourceNode;
            int index = uniqueList.indexOf(src);
            if (index != -1) continue;
            uniqueList.add(src);
        }
        return uniqueList;
    }
}

