/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.Context;
import org.scijava.java3d.J3dMessage;
import org.scijava.java3d.LightRetained;
import org.scijava.java3d.Pipeline;
import org.scijava.java3d.PointLightRetained;
import org.scijava.java3d.SetLiveState;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransformGroupRetained;
import org.scijava.java3d.VirtualUniverse;
import org.scijava.vecmath.Vector3f;

class SpotLightRetained
extends PointLightRetained {
    static final int DIRECTION_CHANGED = 512;
    static final int ANGLE_CHANGED = 1024;
    static final int CONCENTRATION_CHANGED = 2048;
    Vector3f direction = new Vector3f(0.0f, 0.0f, -1.0f);
    Vector3f xformDirection = new Vector3f(0.0f, 0.0f, -1.0f);
    float spreadAngle = (float)Math.PI;
    float concentration = 0.0f;

    SpotLightRetained() {
        this.nodeType = 8;
        this.lightType = 4;
    }

    void initSpreadAngle(float spreadAngle) {
        this.spreadAngle = (double)spreadAngle < 0.0 ? 0.0f : (spreadAngle > 1.5707964f ? (float)Math.PI : spreadAngle);
    }

    @Override
    void setLive(SetLiveState s) {
        super.doSetLive(s);
        J3dMessage createMessage = super.initMessage(12);
        Object[] objs = (Object[])createMessage.args[4];
        objs[9] = new Float(this.spreadAngle);
        objs[10] = new Float(this.concentration);
        objs[11] = new Vector3f(this.direction);
        VirtualUniverse.mc.processMessage(createMessage);
    }

    void setSpreadAngle(float spreadAngle) {
        this.initSpreadAngle(spreadAngle);
        this.sendMessage(1024, new Float(this.spreadAngle));
    }

    float getSpreadAngle() {
        return this.spreadAngle;
    }

    void initConcentration(float concentration) {
        this.concentration = concentration;
    }

    void setConcentration(float concentration) {
        this.initConcentration(concentration);
        this.sendMessage(2048, new Float(concentration));
    }

    float getConcentration() {
        return this.concentration;
    }

    void initDirection(Vector3f direction) {
        this.direction.set(direction);
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(this.direction, this.direction);
        }
    }

    void setDirection(Vector3f direction) {
        this.initDirection(direction);
        this.sendMessage(512, new Vector3f(direction));
    }

    void initDirection(float x, float y, float z) {
        this.direction.x = x;
        this.direction.y = y;
        this.direction.z = z;
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(this.direction, this.direction);
        }
    }

    void setDirection(float x, float y, float z) {
        this.setDirection(new Vector3f(x, y, z));
    }

    void getDirection(Vector3f direction) {
        direction.set(this.direction);
        if (this.staticTransform != null) {
            Transform3D invTransform = this.staticTransform.getInvTransform();
            invTransform.transform(direction, direction);
        }
    }

    @Override
    void update(Context ctx, int lightSlot, double scale) {
        this.validateAttenuationInEc(scale);
        Pipeline.getPipeline().updateSpotLight(ctx, lightSlot, this.color.x, this.color.y, this.color.z, this.attenuation.x, this.linearAttenuationInEc, this.quadraticAttenuationInEc, this.xformPosition.x, this.xformPosition.y, this.xformPosition.z, this.spreadAngle, this.concentration, this.xformDirection.x, this.xformDirection.y, this.xformDirection.z);
    }

    @Override
    void updateMirrorObject(Object[] objs) {
        int component = (Integer)objs[1];
        int numLgts = (Integer)objs[2];
        LightRetained[] mLgts = (LightRetained[])objs[3];
        if ((component & 0x200) != 0) {
            for (int i = 0; i < numLgts; ++i) {
                if (mLgts[i].nodeType != 8) continue;
                SpotLightRetained ml = (SpotLightRetained)mLgts[i];
                ml.direction = (Vector3f)objs[4];
                ml.getLastLocalToVworld().transform(ml.direction, ml.xformDirection);
                ml.xformDirection.normalize();
            }
        } else if ((component & 0x400) != 0) {
            for (int i = 0; i < numLgts; ++i) {
                if (mLgts[i].nodeType != 8) continue;
                SpotLightRetained ml = (SpotLightRetained)mLgts[i];
                ml.spreadAngle = ((Float)objs[4]).floatValue();
            }
        } else if ((component & 0x800) != 0) {
            for (int i = 0; i < numLgts; ++i) {
                if (mLgts[i].nodeType != 8) continue;
                SpotLightRetained ml = (SpotLightRetained)mLgts[i];
                ml.concentration = ((Float)objs[4]).floatValue();
            }
        } else if ((component & 0x20) != 0) {
            for (int i = 0; i < numLgts; ++i) {
                if (mLgts[i].nodeType != 8) continue;
                SpotLightRetained ml = (SpotLightRetained)mLgts[i];
                ml.spreadAngle = ((Float)((Object[])objs[4])[9]).floatValue();
                ml.concentration = ((Float)((Object[])objs[4])[10]).floatValue();
                ml.direction = (Vector3f)((Object[])objs[4])[11];
                ml.getLastLocalToVworld().transform(ml.direction, ml.xformDirection);
                ml.xformDirection.normalize();
            }
        }
        super.updateMirrorObject(objs);
    }

    @Override
    protected Object clone() {
        SpotLightRetained sr = (SpotLightRetained)super.clone();
        sr.direction = new Vector3f(this.direction);
        sr.xformDirection = new Vector3f();
        return sr;
    }

    @Override
    void updateTransformChange() {
        super.updateTransformChange();
        this.getLastLocalToVworld().transform(this.direction, this.xformDirection);
        this.xformDirection.normalize();
    }

    @Override
    final void sendMessage(int attrMask, Object attr) {
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 4224;
        createMessage.universe = this.universe;
        createMessage.type = 19;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(attrMask);
        createMessage.args[2] = this.inSharedGroup ? new Integer(this.numMirrorLights) : new Integer(1);
        createMessage.args[3] = this.mirrorLights.clone();
        createMessage.args[4] = attr;
        VirtualUniverse.mc.processMessage(createMessage);
    }

    @Override
    void mergeTransform(TransformGroupRetained xform) {
        super.mergeTransform(xform);
        xform.transform.transform(this.direction, this.direction);
    }
}

