/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.scijava.java3d.AlternateAppearanceRetained;
import org.scijava.java3d.Appearance;
import org.scijava.java3d.AppearanceRetained;
import org.scijava.java3d.BoundingBox;
import org.scijava.java3d.Bounds;
import org.scijava.java3d.BranchGroupRetained;
import org.scijava.java3d.CachedTargets;
import org.scijava.java3d.CompileState;
import org.scijava.java3d.FogRetained;
import org.scijava.java3d.Geometry;
import org.scijava.java3d.GeometryArrayRetained;
import org.scijava.java3d.GeometryAtom;
import org.scijava.java3d.GeometryRetained;
import org.scijava.java3d.GroupRetained;
import org.scijava.java3d.HashKey;
import org.scijava.java3d.J3dDebug;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.J3dMessage;
import org.scijava.java3d.LeafRetained;
import org.scijava.java3d.LightRetained;
import org.scijava.java3d.MRSWLock;
import org.scijava.java3d.ModelClipRetained;
import org.scijava.java3d.MorphRetained;
import org.scijava.java3d.NodeRetained;
import org.scijava.java3d.OrderedGroupRetained;
import org.scijava.java3d.OrderedPath;
import org.scijava.java3d.OrientedShape3DRetained;
import org.scijava.java3d.PickInfo;
import org.scijava.java3d.PickShape;
import org.scijava.java3d.RasterRetained;
import org.scijava.java3d.SceneGraphPath;
import org.scijava.java3d.SetLiveState;
import org.scijava.java3d.Shape3D;
import org.scijava.java3d.SwitchRetained;
import org.scijava.java3d.TargetsInterface;
import org.scijava.java3d.Text3DRetained;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransformGroupRetained;
import org.scijava.java3d.UnorderList;
import org.scijava.java3d.View;
import org.scijava.java3d.VirtualUniverse;
import org.scijava.vecmath.Point3d;

class Shape3DRetained
extends LeafRetained {
    static final int GEOMETRY_CHANGED = 1;
    static final int APPEARANCE_CHANGED = 2;
    static final int COLLISION_CHANGED = 4;
    static final int BOUNDS_CHANGED = 8;
    static final int APPEARANCEOVERRIDE_CHANGED = 16;
    static final int LAST_DEFINED_BIT = 16;
    static final int targetThreads = 4224;
    AppearanceRetained appearance = null;
    ArrayList<GeometryRetained> geometryList = null;
    private GeometryAtom geomAtom = null;
    private MRSWLock mirrorShape3DLock = null;
    ArrayList<Shape3DRetained> mirrorShape3D = new ArrayList(1);
    NodeRetained sourceNode = null;
    HashKey key = null;
    boolean inImmCtx = false;
    int isDirty = 65535;
    LightRetained[] lights = null;
    int numlights = 0;
    FogRetained[] fogs = null;
    int numfogs = 0;
    ModelClipRetained[] modelClips = null;
    int numModelClips = 0;
    AlternateAppearanceRetained[] altApps = null;
    int numAltApps = 0;
    BranchGroupRetained[] branchGroupPath;
    boolean isPickable = true;
    boolean isCollidable = true;
    SwitchRetained closestSwitchParent = null;
    int closestSwitchIndex = -1;
    boolean visible = true;
    boolean appearanceOverrideEnable = false;
    AppearanceRetained otherAppearance = null;
    Bounds bounds = null;
    BoundingBox vwcBounds = null;
    Bounds collisionBound = null;
    Bounds collisionVwcBound = null;
    OrderedPath orderedPath = null;
    ArrayList<View> viewList = null;
    int changedFrequent = 0;

    Shape3DRetained() {
        this.nodeType = 11;
        this.numlights = 0;
        this.numfogs = 0;
        this.numModelClips = 0;
        this.numAltApps = 0;
        this.localBounds = new BoundingBox((Bounds)null);
        this.mirrorShape3DLock = new MRSWLock();
        this.geometryList = new ArrayList(1);
        this.geometryList.add(null);
    }

    void setCollisionBounds(Bounds bounds) {
        this.collisionBound = bounds == null ? null : (Bounds)bounds.clone();
        if (this.source.isLive()) {
            J3dMessage message = new J3dMessage();
            message.type = 34;
            message.threads = 8192;
            message.universe = this.universe;
            message.args[0] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
            message.args[1] = this.collisionBound;
            VirtualUniverse.mc.processMessage(message);
        }
    }

    @Override
    Bounds getLocalBounds(Bounds bounds) {
        if (this.localBounds != null) {
            this.localBounds.set(bounds);
        } else {
            this.localBounds = new BoundingBox(bounds);
        }
        return this.localBounds;
    }

    @Override
    void setBounds(Bounds bounds) {
        super.setBounds(bounds);
        if (this.source.isLive() && !this.boundsAutoCompute) {
            J3dMessage message = new J3dMessage();
            message.type = 35;
            message.threads = 8384;
            message.universe = this.universe;
            message.args[0] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
            message.args[1] = this.localBounds;
            VirtualUniverse.mc.processMessage(message);
        }
    }

    Bounds getCollisionBounds(int id) {
        return this.collisionBound == null ? null : (Bounds)this.collisionBound.clone();
    }

    void addGeometry(Geometry geometry) {
        GeometryRetained newGeom = null;
        this.checkEquivalenceClass(geometry, -1);
        if (((Shape3D)this.source).isLive()) {
            if (geometry != null) {
                newGeom = (GeometryRetained)geometry.retained;
                newGeom.setLive(this.inBackgroundGroup, this.refCount);
                this.geometryList.add(newGeom);
            } else {
                this.geometryList.add(null);
                newGeom = null;
            }
            this.sendDataChangedMessage(newGeom);
        } else if (geometry != null) {
            this.geometryList.add((GeometryRetained)geometry.retained);
        } else {
            this.geometryList.add(null);
        }
        this.dirtyBoundsCache();
    }

    void setGeometry(Geometry geometry, int index) {
        GeometryRetained newGeom = null;
        GeometryRetained oldGeom = null;
        this.checkEquivalenceClass(geometry, index);
        if (((Shape3D)this.source).isLive()) {
            oldGeom = this.geometryList.get(index);
            if (oldGeom != null) {
                oldGeom.clearLive(this.refCount);
                for (int i = 0; i < this.mirrorShape3D.size(); ++i) {
                    Shape3DRetained mShape = this.mirrorShape3D.get(i);
                    oldGeom.removeUser(mShape);
                }
                oldGeom.decRefCnt();
            }
            if (geometry != null) {
                newGeom = (GeometryRetained)geometry.retained;
                newGeom.incRefCnt();
                newGeom.setLive(this.inBackgroundGroup, this.refCount);
                this.geometryList.set(index, newGeom);
                this.sendDataChangedMessage(newGeom);
            } else {
                this.geometryList.set(index, null);
                this.sendDataChangedMessage(null);
            }
        } else {
            oldGeom = this.geometryList.get(index);
            if (oldGeom != null) {
                oldGeom.decRefCnt();
            }
            if (geometry != null) {
                this.geometryList.set(index, (GeometryRetained)geometry.retained);
                ((GeometryRetained)geometry.retained).incRefCnt();
            } else {
                this.geometryList.set(index, null);
            }
        }
        this.dirtyBoundsCache();
    }

    void insertGeometry(Geometry geometry, int index) {
        GeometryRetained newGeom = null;
        this.checkEquivalenceClass(geometry, -1);
        if (((Shape3D)this.source).isLive()) {
            if (geometry != null) {
                newGeom = (GeometryRetained)geometry.retained;
                newGeom.incRefCnt();
                this.geometryList.add(index, newGeom);
                newGeom.setLive(this.inBackgroundGroup, this.refCount);
                this.sendDataChangedMessage(newGeom);
            } else {
                this.geometryList.add(index, null);
                this.sendDataChangedMessage(null);
            }
        } else if (geometry != null) {
            this.geometryList.add(index, (GeometryRetained)geometry.retained);
            ((GeometryRetained)geometry.retained).incRefCnt();
        } else {
            this.geometryList.add(index, null);
        }
        this.dirtyBoundsCache();
    }

    void removeGeometry(int index) {
        GeometryRetained oldGeom = null;
        if (((Shape3D)this.source).isLive()) {
            oldGeom = this.geometryList.get(index);
            if (oldGeom != null) {
                oldGeom.clearLive(this.refCount);
                oldGeom.decRefCnt();
                for (int i = 0; i < this.mirrorShape3D.size(); ++i) {
                    Shape3DRetained mShape = this.mirrorShape3D.get(i);
                    oldGeom.removeUser(mShape);
                }
            }
            this.geometryList.remove(index);
            this.sendDataChangedMessage(null);
        } else {
            oldGeom = this.geometryList.get(index);
            if (oldGeom != null) {
                oldGeom.decRefCnt();
            }
            this.geometryList.remove(index);
        }
        this.dirtyBoundsCache();
    }

    Geometry getGeometry(int index, int id) {
        GeometryRetained ga = this.geometryList.get(index);
        if (ga == null) {
            return null;
        }
        return (Geometry)ga.source;
    }

    Enumeration getAllGeometries(int id) {
        Vector<Geometry> geomList = new Vector<Geometry>(this.geometryList.size());
        for (int i = 0; i < this.geometryList.size(); ++i) {
            GeometryRetained ga = this.geometryList.get(i);
            if (ga != null) {
                geomList.add((Geometry)ga.source);
                continue;
            }
            geomList.add(null);
        }
        return geomList.elements();
    }

    int numGeometries(int id) {
        return this.geometryList.size();
    }

    void setAppearance(Appearance newAppearance) {
        boolean visibleIsDirty = false;
        if (((Shape3D)this.source).isLive()) {
            Shape3DRetained s;
            int i;
            if (this.appearance != null) {
                this.appearance.clearLive(this.refCount);
                for (i = 0; i < this.mirrorShape3D.size(); ++i) {
                    s = this.mirrorShape3D.get(i);
                    this.appearance.removeAMirrorUser(s);
                }
            }
            if (newAppearance != null) {
                ((AppearanceRetained)newAppearance.retained).setLive(this.inBackgroundGroup, this.refCount);
                this.appearance = (AppearanceRetained)newAppearance.retained;
                for (i = 0; i < this.mirrorShape3D.size(); ++i) {
                    s = this.mirrorShape3D.get(i);
                    this.appearance.addAMirrorUser(s);
                }
                if (this.appearance.renderingAttributes != null && this.visible != this.appearance.renderingAttributes.visible) {
                    this.visible = this.appearance.renderingAttributes.visible;
                    visibleIsDirty = true;
                }
            } else if (!this.visible) {
                this.visible = true;
                visibleIsDirty = true;
            }
            int size = 0;
            size = visibleIsDirty ? 2 : 1;
            J3dMessage[] createMessage = new J3dMessage[size];
            createMessage[0] = new J3dMessage();
            createMessage[0].threads = 4224;
            createMessage[0].type = 24;
            createMessage[0].universe = this.universe;
            createMessage[0].args[0] = this;
            createMessage[0].args[1] = new Integer(2);
            Shape3DRetained[] s3dArr = new Shape3DRetained[this.mirrorShape3D.size()];
            this.mirrorShape3D.toArray(s3dArr);
            createMessage[0].args[2] = s3dArr;
            Object[] obj = new Object[]{newAppearance == null ? null : this.appearance.mirror, new Integer(this.changedFrequent)};
            createMessage[0].args[3] = obj;
            createMessage[0].args[4] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
            if (visibleIsDirty) {
                createMessage[1] = new J3dMessage();
                createMessage[1].threads = 64;
                createMessage[1].type = 24;
                createMessage[1].universe = this.universe;
                createMessage[1].args[0] = this;
                createMessage[1].args[1] = new Integer(2);
                createMessage[1].args[2] = this.visible ? Boolean.TRUE : Boolean.FALSE;
                createMessage[1].args[3] = createMessage[0].args[4];
            }
            VirtualUniverse.mc.processMessage(createMessage);
        } else {
            this.appearance = newAppearance == null ? null : (AppearanceRetained)newAppearance.retained;
        }
    }

    Appearance getAppearance() {
        return this.appearance == null ? null : (Appearance)this.appearance.source;
    }

    void setAppearanceOverrideEnable(boolean flag) {
        if (((Shape3D)this.source).isLive()) {
            J3dMessage createMessage = new J3dMessage();
            createMessage.threads = 4224;
            createMessage.type = 24;
            createMessage.universe = this.universe;
            createMessage.args[0] = this;
            createMessage.args[1] = new Integer(16);
            Shape3DRetained[] s3dArr = new Shape3DRetained[this.mirrorShape3D.size()];
            this.mirrorShape3D.toArray(s3dArr);
            createMessage.args[2] = s3dArr;
            Object[] obj = new Object[]{flag ? Boolean.TRUE : Boolean.FALSE, new Integer(this.changedFrequent)};
            createMessage.args[3] = obj;
            createMessage.args[4] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
            VirtualUniverse.mc.processMessage(createMessage);
        }
        this.appearanceOverrideEnable = flag;
    }

    boolean getAppearanceOverrideEnable() {
        return this.appearanceOverrideEnable;
    }

    boolean intersect(PickInfo pickInfo, PickShape pickShape, int flags) {
        Transform3D localToVworld = pickInfo.getLocalToVWorldRef();
        if (this instanceof OrientedShape3DRetained) {
            Transform3D orientedTransform = ((OrientedShape3DRetained)this).getOrientedTransform(this.getPrimaryViewIdx());
            localToVworld.mul(orientedTransform);
        }
        Transform3D t3d = new Transform3D();
        t3d.invert(localToVworld);
        PickShape newPS = pickShape.transform(t3d);
        int geomListSize = this.geometryList.size();
        if ((flags & 8) == 0 && (flags & 0x10) == 0 && (flags & 0x20) == 0 && (flags & 0x40) == 0) {
            for (int i = 0; i < geomListSize; ++i) {
                GeometryRetained geometry = this.geometryList.get(i);
                if (geometry == null) continue;
                if (geometry.mirrorGeometry != null) {
                    geometry = geometry.mirrorGeometry;
                }
                if (!geometry.intersect(newPS, null, 0, null, null, 0)) continue;
                return true;
            }
        } else {
            double minDist = Double.POSITIVE_INFINITY;
            Point3d closestIPnt = new Point3d();
            Point3d iPnt = new Point3d();
            Point3d iPntVW = new Point3d();
            for (int i = 0; i < geomListSize; ++i) {
                GeometryRetained geometry = this.geometryList.get(i);
                if (geometry == null) continue;
                if (geometry.mirrorGeometry != null) {
                    geometry = geometry.mirrorGeometry;
                }
                if (!geometry.intersect(newPS, pickInfo, flags, iPnt, geometry, i)) continue;
                iPntVW.set(iPnt);
                localToVworld.transform(iPntVW);
                double distance = pickShape.distance(iPntVW);
                if (!(minDist > distance)) continue;
                minDist = distance;
                closestIPnt.set(iPnt);
            }
            if (minDist < Double.POSITIVE_INFINITY) {
                if ((flags & 0x10) != 0) {
                    pickInfo.setClosestDistance(minDist);
                }
                if ((flags & 8) != 0) {
                    pickInfo.setClosestIntersectionPoint(closestIPnt);
                }
                return true;
            }
        }
        return false;
    }

    boolean intersect(SceneGraphPath path, PickShape pickShape, double[] dist) {
        PickInfo pickInfo = new PickInfo();
        Transform3D localToVworld = path.getTransform();
        if (localToVworld == null) {
            throw new IllegalArgumentException(J3dI18N.getString("Shape3DRetained3"));
        }
        pickInfo.setLocalToVWorldRef(localToVworld);
        if (dist == null) {
            return this.intersect(pickInfo, pickShape, 0);
        }
        int flags = 16;
        if (this.intersect(pickInfo, pickShape, flags)) {
            dist[0] = pickInfo.getClosestDistance();
            return true;
        }
        return false;
    }

    void setInImmCtx(boolean inCtx) {
        this.inImmCtx = inCtx;
    }

    boolean getInImmCtx() {
        return this.inImmCtx;
    }

    private void initMirrorShape3D(SetLiveState s, Shape3DRetained ms, int index) {
        ms.inBackgroundGroup = this.inBackgroundGroup;
        ms.geometryBackground = this.geometryBackground;
        ms.source = this.source;
        ms.universe = this.universe;
        ms.inSharedGroup = false;
        ms.locale = this.locale;
        ms.parent = this.parent;
        ms.boundsAutoCompute = this.boundsAutoCompute;
        ms.localBounds = this.localBounds;
        OrderedPath op = s.orderedPaths.get(index);
        ms.orderedPath = op.pathElements.size() == 0 ? null : op;
        ms.staticTransform = this.staticTransform;
        ms.appearanceOverrideEnable = this.appearanceOverrideEnable;
        ms.geometryList = this.geometryList;
        ms.sourceNode = this;
        if (this instanceof OrientedShape3DRetained) {
            OrientedShape3DRetained os = (OrientedShape3DRetained)this;
            OrientedShape3DRetained oms = (OrientedShape3DRetained)ms;
            oms.initAlignmentMode(os.mode);
            oms.initAlignmentAxis(os.axis);
            oms.initRotationPoint(os.rotationPoint);
            oms.initConstantScaleEnable(os.constantScale);
            oms.initScale(os.scaleFactor);
        }
    }

    void updateImmediateMirrorObject(Object[] objs) {
        int i;
        int val;
        Object[] arg;
        int component = (Integer)objs[1];
        Shape3DRetained[] msArr = (Shape3DRetained[])objs[2];
        if ((component & 2) != 0) {
            arg = (Object[])objs[3];
            val = (Integer)arg[1];
            for (i = msArr.length - 1; i >= 0; --i) {
                msArr[i].appearance = (AppearanceRetained)arg[0];
                msArr[i].changedFrequent = val;
            }
        }
        if ((component & 0x10) != 0) {
            arg = (Object[])objs[3];
            val = (Integer)arg[1];
            for (i = msArr.length - 1; i >= 0; --i) {
                msArr[i].appearanceOverrideEnable = (Boolean)arg[0];
                msArr[i].changedFrequent = val;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Bounds getBounds() {
        if (this.boundsAutoCompute) {
            if (this.validCachedBounds) {
                return (Bounds)this.cachedBounds.clone();
            }
            if (this.geometryList != null) {
                BoundingBox bbox = new BoundingBox((Bounds)null);
                for (int i = 0; i < this.geometryList.size(); ++i) {
                    GeometryRetained geometry = this.geometryList.get(i);
                    if (geometry == null || geometry.geoType == -1) continue;
                    geometry.computeBoundingBox();
                    BoundingBox boundingBox = geometry.geoBounds;
                    synchronized (boundingBox) {
                        bbox.combine(geometry.geoBounds);
                        continue;
                    }
                }
                return bbox;
            }
            return null;
        }
        return super.getBounds();
    }

    @Override
    Bounds getEffectiveBounds() {
        if (this.boundsAutoCompute) {
            return this.getBounds();
        }
        return super.getEffectiveBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void computeCombineBounds(Bounds bounds) {
        block20: {
            block19: {
                if (!this.boundsAutoCompute) break block19;
                if (this.geometryList == null) break block20;
                BoundingBox bbox = null;
                if (this.staticTransform != null) {
                    bbox = new BoundingBox((Bounds)null);
                }
                if (!VirtualUniverse.mc.cacheAutoComputedBounds) {
                    for (int i = 0; i < this.geometryList.size(); ++i) {
                        GeometryRetained geometry = this.geometryList.get(i);
                        if (geometry == null || geometry.geoType == -1) continue;
                        geometry.computeBoundingBox();
                        BoundingBox boundingBox = geometry.geoBounds;
                        synchronized (boundingBox) {
                            if (this.staticTransform != null) {
                                bbox.set(geometry.geoBounds);
                                bbox.transform(this.staticTransform.transform);
                                bounds.combine(bbox);
                            } else {
                                bounds.combine(geometry.geoBounds);
                            }
                            continue;
                        }
                    }
                } else {
                    if (!this.validCachedBounds) {
                        this.validCachedBounds = true;
                        this.cachedBounds = new BoundingBox((Bounds)null);
                        for (int i = 0; i < this.geometryList.size(); ++i) {
                            GeometryRetained geometry = this.geometryList.get(i);
                            if (geometry == null || geometry.geoType == -1) continue;
                            geometry.computeBoundingBox();
                            BoundingBox boundingBox = geometry.geoBounds;
                            synchronized (boundingBox) {
                                if (this.staticTransform != null) {
                                    bbox.set(geometry.geoBounds);
                                    bbox.transform(this.staticTransform.transform);
                                    this.cachedBounds.combine(bbox);
                                } else {
                                    this.cachedBounds.combine(geometry.geoBounds);
                                }
                                continue;
                            }
                        }
                    }
                    bounds.combine(this.cachedBounds);
                }
                break block20;
            }
            Bounds bounds2 = this.localBounds;
            synchronized (bounds2) {
                bounds.combine(this.localBounds);
            }
        }
    }

    @Override
    void setLive(SetLiveState s) {
        this.doSetLive(s);
        this.markAsLive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doSetLive(SetLiveState s) {
        ArrayList<LeafRetained> l;
        Shape3DRetained shape;
        int i;
        ArrayList<Shape3DRetained> msList = new ArrayList<Shape3DRetained>();
        super.doSetLive(s);
        this.nodeId = this.universe.getNodeId();
        if (this.inSharedGroup) {
            for (i = 0; i < s.keys.length; ++i) {
                int m;
                shape = this instanceof OrientedShape3DRetained ? new OrientedShape3DRetained() : new Shape3DRetained();
                shape.key = s.keys[i];
                shape.localToVworld = new Transform3D[1][];
                shape.localToVworldIndex = new int[1][];
                int j = s.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                shape.localToVworld[0] = this.localToVworld[j];
                shape.localToVworldIndex[0] = this.localToVworldIndex[j];
                shape.branchGroupPath = (BranchGroupRetained[])this.branchGroupPaths.get(j);
                shape.isPickable = s.pickable[i];
                shape.isCollidable = s.collidable[i];
                this.initMirrorShape3D(s, shape, j);
                if (s.switchTargets != null && s.switchTargets[i] != null) {
                    s.switchTargets[i].addNode(shape, 0);
                    shape.closestSwitchParent = s.closestSwitchParents[i];
                    shape.closestSwitchIndex = s.closestSwitchIndices[i];
                }
                shape.switchState = s.switchStates.get(j);
                if (s.lights != null && (l = s.lights.get(j)) != null) {
                    for (m = 0; m < l.size(); ++m) {
                        shape.addLight((LightRetained)l.get(m));
                    }
                }
                if (s.fogs != null && (l = s.fogs.get(j)) != null) {
                    for (m = 0; m < l.size(); ++m) {
                        shape.addFog((FogRetained)l.get(m));
                    }
                }
                if (s.modelClips != null && (l = s.modelClips.get(j)) != null) {
                    for (m = 0; m < l.size(); ++m) {
                        shape.addModelClip((ModelClipRetained)l.get(m));
                    }
                }
                if (s.altAppearances != null && (l = s.altAppearances.get(j)) != null) {
                    for (m = 0; m < l.size(); ++m) {
                        shape.addAltApp((AlternateAppearanceRetained)l.get(m));
                    }
                }
                l = this.mirrorShape3D;
                synchronized (l) {
                    this.mirrorShape3D.add(j, shape);
                }
                msList.add(shape);
                shape.viewList = s.viewLists != null ? s.viewLists.get(j) : null;
            }
        } else {
            shape = this instanceof OrientedShape3DRetained ? new OrientedShape3DRetained() : new Shape3DRetained();
            shape.localToVworld = new Transform3D[1][];
            shape.localToVworldIndex = new int[1][];
            shape.localToVworld[0] = this.localToVworld[0];
            shape.localToVworldIndex[0] = this.localToVworldIndex[0];
            shape.branchGroupPath = (BranchGroupRetained[])this.branchGroupPaths.get(0);
            shape.isPickable = s.pickable[0];
            shape.isCollidable = s.collidable[0];
            this.initMirrorShape3D(s, shape, 0);
            if (s.lights != null) {
                l = s.lights.get(0);
                for (i = 0; i < l.size(); ++i) {
                    shape.addLight((LightRetained)l.get(i));
                }
            }
            if (s.fogs != null) {
                l = s.fogs.get(0);
                for (i = 0; i < l.size(); ++i) {
                    shape.addFog((FogRetained)l.get(i));
                }
            }
            if (s.modelClips != null) {
                l = s.modelClips.get(0);
                for (i = 0; i < l.size(); ++i) {
                    shape.addModelClip((ModelClipRetained)l.get(i));
                }
            }
            if (s.altAppearances != null) {
                l = s.altAppearances.get(0);
                for (i = 0; i < l.size(); ++i) {
                    shape.addAltApp((AlternateAppearanceRetained)l.get(i));
                }
            }
            l = this.mirrorShape3D;
            synchronized (l) {
                this.mirrorShape3D.add(shape);
            }
            msList.add(shape);
            shape.viewList = s.viewLists != null ? s.viewLists.get(0) : null;
            if (s.switchTargets != null && s.switchTargets[0] != null) {
                s.switchTargets[0].addNode(shape, 0);
                shape.closestSwitchParent = s.closestSwitchParents[0];
                shape.closestSwitchIndex = s.closestSwitchIndices[0];
            }
            shape.switchState = s.switchStates.get(0);
        }
        for (int k = 0; k < msList.size(); ++k) {
            Shape3DRetained sh = (Shape3DRetained)msList.get(k);
            if (this.appearance != null) {
                Object m = this.appearance.liveStateLock;
                synchronized (m) {
                    if (k == 0) {
                        this.appearance.setLive(this.inBackgroundGroup, s.refCount);
                        this.appearance.initMirrorObject();
                        if (this.appearance.renderingAttributes != null) {
                            this.visible = this.appearance.renderingAttributes.visible;
                        }
                    }
                    sh.appearance = (AppearanceRetained)this.appearance.mirror;
                    this.appearance.addAMirrorUser(sh);
                }
            } else {
                sh.appearance = null;
            }
            if (this.geometryList != null) {
                for (int gaCnt = 0; gaCnt < this.geometryList.size(); ++gaCnt) {
                    GeometryRetained geometry = this.geometryList.get(gaCnt);
                    if (geometry == null) continue;
                    Object m = geometry.liveStateLock;
                    synchronized (m) {
                        if (k == 0) {
                            geometry.setLive(this.inBackgroundGroup, s.refCount);
                        }
                        geometry.addUser(sh);
                        continue;
                    }
                }
            }
            if (k == 0 && this.boundsAutoCompute) {
                if (!(this.localBounds instanceof BoundingBox)) {
                    this.localBounds = new BoundingBox((Bounds)null);
                }
                this.getCombineBounds((BoundingBox)this.localBounds);
            }
            this.initializeGAtom(sh);
            GeometryAtom ga = Shape3DRetained.getGeomAtom(sh);
            s.nodeList.add(ga);
            if (s.transformTargets == null || s.transformTargets[k] == null) continue;
            s.transformTargets[k].addNode(ga, 0);
        }
        s.notifyThreads |= 0x30C0;
    }

    void clearMirrorShape() {
        int i;
        this.source = null;
        this.sourceNode = null;
        this.parent = null;
        if (this.otherAppearance != null) {
            this.otherAppearance.sgApp.removeAMirrorUser(this);
            this.otherAppearance = null;
        }
        this.appearance = null;
        this.branchGroupPath = null;
        this.isPickable = true;
        this.isCollidable = true;
        this.branchGroupPath = null;
        this.geometryList = null;
        for (i = 0; i < this.numfogs; ++i) {
            this.fogs[i] = null;
        }
        this.numfogs = 0;
        for (i = 0; i < this.numModelClips; ++i) {
            this.modelClips[i] = null;
        }
        this.numModelClips = 0;
        for (i = 0; i < this.numlights; ++i) {
            this.lights[i] = null;
        }
        this.numlights = 0;
        for (i = 0; i < this.numAltApps; ++i) {
            this.altApps[i] = null;
        }
        this.numAltApps = 0;
        this.viewList = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void clearLive(SetLiveState s) {
        int i;
        Shape3DRetained[] shapes;
        ArrayList<Shape3DRetained> msList = new ArrayList<Shape3DRetained>();
        super.clearLive(s);
        if (this.inSharedGroup) {
            ArrayList<Shape3DRetained> arrayList = this.mirrorShape3D;
            synchronized (arrayList) {
                shapes = this.mirrorShape3D.toArray(new Shape3DRetained[this.mirrorShape3D.size()]);
                for (i = 0; i < s.keys.length; ++i) {
                    for (int j = 0; j < shapes.length; ++j) {
                        Shape3DRetained shape = shapes[j];
                        if (!shape.key.equals((Object)s.keys[i])) continue;
                        this.mirrorShape3D.remove(this.mirrorShape3D.indexOf(shape));
                        if (s.switchTargets != null && s.switchTargets[i] != null) {
                            s.switchTargets[i].addNode(shape, 0);
                        }
                        msList.add(shape);
                        GeometryAtom ga = Shape3DRetained.getGeomAtom(shape);
                        s.nodeList.add(ga);
                        if (s.transformTargets == null || s.transformTargets[i] == null) continue;
                        s.transformTargets[i].addNode(ga, 0);
                    }
                }
            }
        }
        Shape3DRetained shape = this.mirrorShape3D.get(0);
        shapes = this.mirrorShape3D;
        synchronized (this.mirrorShape3D) {
            this.mirrorShape3D.remove(0);
            // ** MonitorExit[shapes] (shouldn't be in output)
            if (s.switchTargets != null && s.switchTargets[0] != null) {
                s.switchTargets[0].addNode(shape, 0);
            }
            msList.add(shape);
            GeometryAtom ga = Shape3DRetained.getGeomAtom(shape);
            s.nodeList.add(ga);
            if (s.transformTargets != null && s.transformTargets[0] != null) {
                s.transformTargets[0].addNode(ga, 0);
            }
            for (int k = 0; k < msList.size(); ++k) {
                Object object;
                Shape3DRetained sh = (Shape3DRetained)msList.get(k);
                if (this.appearance != null) {
                    object = this.appearance.liveStateLock;
                    synchronized (object) {
                        if (k == 0) {
                            this.appearance.clearLive(s.refCount);
                        }
                        this.appearance.removeAMirrorUser(sh);
                    }
                }
                if (this.geometryList == null) continue;
                for (int gaCnt = 0; gaCnt < this.geometryList.size(); ++gaCnt) {
                    GeometryRetained geometry = this.geometryList.get(gaCnt);
                    if (geometry == null) continue;
                    object = geometry.liveStateLock;
                    synchronized (object) {
                        if (k == 0) {
                            geometry.clearLive(s.refCount);
                        }
                        geometry.removeUser(sh);
                        continue;
                    }
                }
            }
            s.notifyThreads |= 0x30C0;
            if (!this.source.isLive()) {
                for (i = 0; i < this.numfogs; ++i) {
                    this.fogs[i] = null;
                }
                this.numfogs = 0;
                for (i = 0; i < this.numModelClips; ++i) {
                    this.modelClips[i] = null;
                }
                this.numModelClips = 0;
                for (i = 0; i < this.numlights; ++i) {
                    this.lights[i] = null;
                }
                this.numlights = 0;
                for (i = 0; i < this.numAltApps; ++i) {
                    this.altApps[i] = null;
                }
                this.numAltApps = 0;
            }
            return;
        }
    }

    @Override
    boolean isStatic() {
        return !this.source.getCapability(15) && !this.source.getCapability(13) && !this.source.getCapability(19);
    }

    boolean staticXformCanBeApplied() {
        if (this.isPickable || this.isCollidable || this.source.getCapability(6) || this.source.getCapability(8)) {
            return false;
        }
        if (this.appearance != null && this.appearance.transparencyAttributes != null && this.appearance.transparencyAttributes.transparencyMode != 4) {
            return false;
        }
        for (int i = 0; i < this.geometryList.size(); ++i) {
            GeometryRetained geo = this.geometryList.get(i);
            if (geo == null) continue;
            if (geo.refCnt > 1) {
                return false;
            }
            boolean alphaEditable = this.isAlphaEditable(geo);
            if (geo instanceof GeometryArrayRetained) {
                boolean bl = geo.isEditable = !((GeometryArrayRetained)geo).isWriteStatic();
                if (geo.source.getCapability(0) || geo.source.getCapability(4)) {
                    return false;
                }
            }
            if (geo.canBeInDisplayList(alphaEditable)) continue;
            return false;
        }
        return true;
    }

    @Override
    void compile(CompileState compState) {
        super.compile(compState);
        if (this.isStatic() && this.staticXformCanBeApplied()) {
            this.mergeFlag = 1;
            if (J3dDebug.debug) {
                ++compState.numShapesWStaticTG;
            }
        } else {
            this.mergeFlag = 0;
            compState.keepTG = true;
        }
        if (J3dDebug.debug) {
            ++compState.numShapes;
        }
        if (this.appearance != null) {
            this.appearance.compile(compState);
            if (this.appearance.isStatic()) {
                AppearanceRetained newApp;
                this.appearance = newApp = compState.getAppearance(this.appearance);
            }
        }
        for (int i = 0; i < this.geometryList.size(); ++i) {
            GeometryRetained geo = this.geometryList.get(i);
            if (geo == null) continue;
            geo.compile(compState);
        }
    }

    @Override
    void merge(CompileState compState) {
        if (this.mergeFlag == 0) {
            TransformGroupRetained saveStaticTransform = compState.staticTransform;
            compState.staticTransform = null;
            super.merge(compState);
            compState.staticTransform = saveStaticTransform;
        } else {
            super.merge(compState);
        }
        if (this.shapeIsMergeable(compState)) {
            compState.addShape(this);
        }
    }

    boolean shapeIsMergeable(CompileState compState) {
        boolean mergeable = true;
        GeometryRetained geometry = null;
        int i = 0;
        if (this.staticTransform != null) {
            return false;
        }
        if (this.parent instanceof OrderedGroupRetained || this.parent instanceof SwitchRetained) {
            return false;
        }
        for (int index = 0; geometry == null && index < this.geometryList.size(); ++index) {
            geometry = this.geometryList.get(index);
        }
        if (!(geometry instanceof GeometryArrayRetained)) {
            return false;
        }
        GeometryArrayRetained firstGeo = (GeometryArrayRetained)geometry;
        for (i = index; i < this.geometryList.size() && mergeable; ++i) {
            geometry = this.geometryList.get(i);
            if (geometry == null) continue;
            GeometryArrayRetained geo = (GeometryArrayRetained)geometry;
            if (!geo.isWriteStatic()) {
                mergeable = false;
            }
            if (geo.vertexFormat == firstGeo.vertexFormat) continue;
            mergeable = false;
        }
        if (this.source.getCapability(17) || this.source.getCapability(15) || this.source.getCapability(19) || this.source.getCapability(10) || this.source.getCapability(4) || this.source.getCapability(8) || this.source.getCapability(6) || this.source.getCapability(13)) {
            mergeable = false;
        }
        return mergeable;
    }

    @Override
    void getMirrorObjects(ArrayList list, HashKey k) {
        Shape3DRetained ms;
        if (this.inSharedGroup) {
            if (k.count == 0) {
                return;
            }
            ms = this.getMirrorShape(k);
        } else {
            ms = this.mirrorShape3D.get(0);
        }
        list.add(Shape3DRetained.getGeomAtom(ms));
    }

    void addLight(LightRetained light) {
        if (this.lights == null) {
            this.lights = new LightRetained[10];
        } else if (this.lights.length == this.numlights) {
            LightRetained[] newlights = new LightRetained[this.numlights * 2];
            for (int i = 0; i < this.numlights; ++i) {
                newlights[i] = this.lights[i];
            }
            this.lights = newlights;
        }
        this.lights[this.numlights] = light;
        ++this.numlights;
    }

    void removeLight(LightRetained light) {
        int i;
        for (i = 0; i < this.numlights; ++i) {
            if (this.lights[i] != light) continue;
            this.lights[i] = null;
            break;
        }
        ++i;
        while (i < this.numlights) {
            this.lights[i - 1] = this.lights[i];
            ++i;
        }
        --this.numlights;
    }

    void addFog(FogRetained fog) {
        if (this.fogs == null) {
            this.fogs = new FogRetained[10];
        } else if (this.fogs.length == this.numfogs) {
            FogRetained[] newfogs = new FogRetained[this.numfogs * 2];
            for (int i = 0; i < this.numfogs; ++i) {
                newfogs[i] = this.fogs[i];
            }
            this.fogs = newfogs;
        }
        this.fogs[this.numfogs] = fog;
        ++this.numfogs;
    }

    void removeFog(FogRetained fog) {
        int i;
        for (i = 0; i < this.numfogs; ++i) {
            if (this.fogs[i] != fog) continue;
            this.fogs[i] = null;
            break;
        }
        ++i;
        while (i < this.numfogs) {
            this.fogs[i - 1] = this.fogs[i];
            ++i;
        }
        --this.numfogs;
    }

    void addModelClip(ModelClipRetained modelClip) {
        if (this.modelClips == null) {
            this.modelClips = new ModelClipRetained[10];
        } else if (this.modelClips.length == this.numModelClips) {
            ModelClipRetained[] newModelClips = new ModelClipRetained[this.numModelClips * 2];
            for (int i = 0; i < this.numModelClips; ++i) {
                newModelClips[i] = this.modelClips[i];
            }
            this.modelClips = newModelClips;
        }
        this.modelClips[this.numModelClips] = modelClip;
        ++this.numModelClips;
    }

    void removeModelClip(ModelClipRetained modelClip) {
        int i;
        for (i = 0; i < this.numModelClips; ++i) {
            if (this.modelClips[i] != modelClip) continue;
            this.modelClips[i] = null;
            break;
        }
        ++i;
        while (i < this.numModelClips) {
            this.modelClips[i - 1] = this.modelClips[i];
            ++i;
        }
        --this.numModelClips;
    }

    void addAltApp(AlternateAppearanceRetained aApp) {
        if (this.altApps == null) {
            this.altApps = new AlternateAppearanceRetained[10];
        } else if (this.altApps.length == this.numAltApps) {
            AlternateAppearanceRetained[] newAltApps = new AlternateAppearanceRetained[this.numAltApps * 2];
            for (int i = 0; i < this.numAltApps; ++i) {
                newAltApps[i] = this.altApps[i];
            }
            this.altApps = newAltApps;
        }
        this.altApps[this.numAltApps] = aApp;
        ++this.numAltApps;
    }

    void removeAltApp(AlternateAppearanceRetained aApp) {
        int i;
        for (i = 0; i < this.numAltApps; ++i) {
            if (this.altApps[i] != aApp) continue;
            this.altApps[i] = null;
            break;
        }
        ++i;
        while (i < this.numAltApps) {
            this.altApps[i - 1] = this.altApps[i];
            ++i;
        }
        --this.numAltApps;
    }

    @Override
    void updatePickable(HashKey[] keys, boolean[] pick) {
        super.updatePickable(keys, pick);
        if (!this.inSharedGroup) {
            Shape3DRetained shape = this.mirrorShape3D.get(0);
            shape.isPickable = pick[0];
        } else {
            int size = this.mirrorShape3D.size();
            block0: for (int j = 0; j < keys.length; ++j) {
                for (int i = 0; i < size; ++i) {
                    Shape3DRetained shape = this.mirrorShape3D.get(i);
                    if (!keys[j].equals((Object)shape.key)) continue;
                    shape.isPickable = pick[j];
                    continue block0;
                }
            }
        }
    }

    @Override
    void updateCollidable(HashKey[] keys, boolean[] collide) {
        super.updateCollidable(keys, collide);
        if (!this.inSharedGroup) {
            Shape3DRetained shape = this.mirrorShape3D.get(0);
            shape.isCollidable = collide[0];
        } else {
            int size = this.mirrorShape3D.size();
            block0: for (int j = 0; j < keys.length; ++j) {
                for (int i = 0; i < size; ++i) {
                    Shape3DRetained shape = this.mirrorShape3D.get(i);
                    if (!keys[j].equals((Object)shape.key)) continue;
                    shape.isCollidable = collide[j];
                    continue block0;
                }
            }
        }
    }

    private void sendDataChangedMessage(GeometryRetained newGeom) {
        int i;
        GeometryAtom[] newGAArray = null;
        GeometryAtom[] oldGAArray = null;
        int geometryCnt = 0;
        GeometryRetained geometry = null;
        int s3dMSize = this.mirrorShape3D.size();
        if (s3dMSize < 1) {
            return;
        }
        Shape3DRetained mS3d = this.mirrorShape3D.get(0);
        mS3d.mirrorShape3DLock.writeLock();
        GeometryAtom oldGA = mS3d.geomAtom;
        GeometryAtom newGA = new GeometryAtom();
        if (newGeom != null) {
            newGeom.addUser(mS3d);
        }
        int gSize = this.geometryList.size();
        for (i = 0; i < gSize; ++i) {
            geometry = this.geometryList.get(i);
            if (geometry == null) continue;
            newGA.geoType = geometry.geoType;
            newGA.alphaEditable = mS3d.isAlphaEditable(geometry);
            break;
        }
        if (geometry != null && geometry.geoType == 16) {
            for (i = 0; i < gSize; ++i) {
                geometry = this.geometryList.get(i);
                if (geometry != null) {
                    Text3DRetained tempT3d = (Text3DRetained)geometry;
                    geometryCnt += tempT3d.numChars;
                    continue;
                }
                ++geometryCnt;
            }
            newGA.geometryArray = new GeometryRetained[geometryCnt];
            newGA.lastLocalTransformArray = new Transform3D[geometryCnt];
            geometryCnt = 0;
        } else {
            newGA.geometryArray = new GeometryRetained[gSize];
        }
        newGA.locale = mS3d.locale;
        newGA.visible = this.visible;
        newGA.source = mS3d;
        for (int gaCnt = 0; gaCnt < gSize; ++gaCnt) {
            geometry = this.geometryList.get(gaCnt);
            if (geometry == null) {
                newGA.geometryArray[geometryCnt++] = null;
                continue;
            }
            if (geometry.geoType == 16) {
                Text3DRetained t = (Text3DRetained)geometry;
                i = 0;
                while (i < t.numChars) {
                    GeometryArrayRetained geo = t.geometryList[i];
                    if (geo != null) {
                        newGA.geometryArray[geometryCnt] = geo;
                        newGA.lastLocalTransformArray[geometryCnt] = t.charTransforms[i];
                    } else {
                        newGA.geometryArray[geometryCnt] = null;
                        newGA.lastLocalTransformArray[geometryCnt] = null;
                    }
                    ++i;
                    ++geometryCnt;
                }
                continue;
            }
            newGA.geometryArray[geometryCnt++] = geometry;
        }
        oldGAArray = new GeometryAtom[s3dMSize];
        newGAArray = new GeometryAtom[s3dMSize];
        oldGAArray[0] = oldGA;
        newGAArray[0] = newGA;
        mS3d.geomAtom = newGA;
        mS3d.mirrorShape3DLock.writeUnlock();
        for (i = 1; i < s3dMSize; ++i) {
            mS3d = this.mirrorShape3D.get(i);
            mS3d.mirrorShape3DLock.writeLock();
            oldGA = mS3d.geomAtom;
            newGA = new GeometryAtom();
            if (newGeom != null) {
                newGeom.addUser(mS3d);
            }
            newGA.geoType = newGAArray[0].geoType;
            newGA.locale = mS3d.locale;
            newGA.visible = this.visible;
            newGA.source = mS3d;
            newGA.alphaEditable = newGAArray[0].alphaEditable;
            newGA.geometryArray = new GeometryRetained[newGAArray[0].geometryArray.length];
            for (int j = 0; j < newGA.geometryArray.length; ++j) {
                newGA.geometryArray[j] = newGAArray[0].geometryArray[j];
            }
            oldGAArray[i] = oldGA;
            newGAArray[i] = newGA;
            mS3d.geomAtom = newGA;
            mS3d.mirrorShape3DLock.writeUnlock();
        }
        TargetsInterface ti = ((GroupRetained)this.parent).getClosestTargetsInterface(0);
        CachedTargets[] newCtArr = null;
        if (ti != null) {
            newCtArr = new CachedTargets[s3dMSize];
            for (i = 0; i < s3dMSize; ++i) {
                CachedTargets ct = ti.getCachedTargets(0, i, -1);
                if (ct != null) {
                    newCtArr[i] = new CachedTargets();
                    newCtArr[i].copy(ct);
                    newCtArr[i].replace(oldGAArray[i], newGAArray[i], 0);
                    continue;
                }
                newCtArr[i] = null;
            }
            ti.resetCachedTargets(0, newCtArr, -1);
        }
        J3dMessage changeMessage = new J3dMessage();
        changeMessage.type = 24;
        changeMessage.threads = 8384;
        changeMessage.universe = this.universe;
        changeMessage.args[0] = this;
        changeMessage.args[1] = new Integer(1);
        changeMessage.args[2] = oldGAArray;
        changeMessage.args[3] = newGAArray;
        if (ti != null) {
            changeMessage.args[4] = ti;
            changeMessage.args[5] = newCtArr;
        }
        if (this.boundsAutoCompute) {
            this.getCombineBounds((BoundingBox)this.localBounds);
        }
        VirtualUniverse.mc.processMessage(changeMessage);
    }

    Shape3DRetained getMirrorShape(SceneGraphPath path) {
        if (!this.inSharedGroup) {
            return this.mirrorShape3D.get(0);
        }
        HashKey key = new HashKey("");
        path.getHashKey(key);
        return this.getMirrorShape(key);
    }

    Shape3DRetained getMirrorShape(HashKey key) {
        if (key == null) {
            return this.mirrorShape3D.get(0);
        }
        int i = key.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
        if (i >= 0) {
            return this.mirrorShape3D.get(i);
        }
        throw new RuntimeException("Shape3DRetained: MirrorShape Not found!");
    }

    @Override
    void setBoundsAutoCompute(boolean autoCompute) {
        if (autoCompute != this.boundsAutoCompute) {
            int size;
            if (autoCompute) {
                this.localBounds = new BoundingBox((Bounds)null);
                if (this.source.isLive() && this.geometryList != null) {
                    size = this.geometryList.size() * this.mirrorShape3D.size();
                    for (int i = 0; i < size; ++i) {
                        GeometryRetained geometry = this.geometryList.get(i);
                        geometry.incrComputeGeoBounds();
                    }
                }
                this.getCombineBounds((BoundingBox)this.localBounds);
            } else if (this.source.isLive() && this.geometryList != null) {
                size = this.geometryList.size() * this.mirrorShape3D.size();
                for (int i = 0; i < size; ++i) {
                    GeometryRetained geometry = this.geometryList.get(i);
                    geometry.decrComputeGeoBounds();
                }
            }
            super.setBoundsAutoCompute(autoCompute);
            if (this.source.isLive()) {
                J3dMessage message = new J3dMessage();
                message.type = 37;
                message.threads = 8384;
                message.universe = this.universe;
                message.args[0] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
                message.args[1] = this.localBounds;
                VirtualUniverse.mc.processMessage(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateBounds() {
        this.localBounds = new BoundingBox((Bounds)null);
        this.getCombineBounds((BoundingBox)this.localBounds);
        ArrayList<Shape3DRetained> arrayList = this.mirrorShape3D;
        synchronized (arrayList) {
            if (this.source.isLive()) {
                J3dMessage message = new J3dMessage();
                message.type = 37;
                message.threads = 8384;
                message.universe = this.universe;
                message.args[0] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
                message.args[1] = this.localBounds;
                VirtualUniverse.mc.processMessage(message);
            }
        }
    }

    boolean allowIntersect() {
        GeometryRetained ga = null;
        for (int i = 0; i < this.geometryList.size(); ++i) {
            ga = this.geometryList.get(i);
            if (ga == null || ga.source.getCapability(18)) continue;
            return false;
        }
        return true;
    }

    boolean intersectGeometryList(Shape3DRetained otherShape) {
        ArrayList<GeometryRetained> gaList = otherShape.geometryList;
        int gaSize = gaList.size();
        Transform3D otherLocalToVworld = otherShape.getCurrentLocalToVworld();
        Transform3D thisLocalToVworld = this.getCurrentLocalToVworld();
        int primaryViewIdx = -1;
        if (this instanceof OrientedShape3DRetained) {
            primaryViewIdx = this.getPrimaryViewIdx();
            thisLocalToVworld.mul(((OrientedShape3DRetained)this).getOrientedTransform(primaryViewIdx));
        }
        if (otherShape instanceof OrientedShape3DRetained) {
            if (primaryViewIdx < 0) {
                primaryViewIdx = this.getPrimaryViewIdx();
            }
            otherLocalToVworld.mul(((OrientedShape3DRetained)otherShape).getOrientedTransform(primaryViewIdx));
        }
        for (int i = this.geometryList.size() - 1; i >= 0; --i) {
            GeometryRetained geom1 = this.geometryList.get(i);
            if (geom1 == null) continue;
            for (int j = gaSize - 1; j >= 0; --j) {
                GeometryRetained geom2 = gaList.get(j);
                if (geom2 == null || !geom1.intersect(thisLocalToVworld, otherLocalToVworld, geom2)) continue;
                return true;
            }
        }
        return false;
    }

    boolean intersectGeometryList(Transform3D thisLocalToVworld, Bounds targetBound) {
        if (this instanceof OrientedShape3DRetained) {
            Transform3D orientedTransform = ((OrientedShape3DRetained)this).getOrientedTransform(this.getPrimaryViewIdx());
            thisLocalToVworld.mul(orientedTransform);
        }
        for (int i = this.geometryList.size() - 1; i >= 0; --i) {
            GeometryRetained geometry = this.geometryList.get(i);
            if (geometry == null || !geometry.intersect(thisLocalToVworld, targetBound)) continue;
            return true;
        }
        return false;
    }

    void initMirrorShape3D(SetLiveState s, MorphRetained morph, int index) {
        this.universe = morph.universe;
        this.inSharedGroup = morph.inSharedGroup;
        this.inBackgroundGroup = morph.inBackgroundGroup;
        this.geometryBackground = morph.geometryBackground;
        this.parent = morph.parent;
        this.locale = morph.locale;
        OrderedPath op = s.orderedPaths.get(index);
        this.orderedPath = op.pathElements.size() == 0 ? null : op;
        this.staticTransform = morph.staticTransform;
        if (morph.boundsAutoCompute) {
            this.localBounds.set(morph.localBounds);
        }
        this.bounds = this.localBounds;
        this.vwcBounds = new BoundingBox((Bounds)null);
        this.vwcBounds.transform(this.bounds, this.getCurrentLocalToVworld(0));
        if (morph.collisionBound == null) {
            this.collisionBound = null;
            this.collisionVwcBound = this.vwcBounds;
        } else {
            this.collisionBound = morph.collisionBound;
            this.collisionVwcBound = (Bounds)this.collisionBound.clone();
            this.collisionVwcBound.transform(this.getCurrentLocalToVworld(0));
        }
        this.appearanceOverrideEnable = morph.appearanceOverrideEnable;
        this.geometryList = new ArrayList(1);
        this.geometryList.add((GeometryArrayRetained)morph.morphedGeometryArray.retained);
        GeometryAtom gAtom = new GeometryAtom();
        gAtom.geometryArray = new GeometryRetained[1];
        gAtom.locale = this.locale;
        gAtom.visible = morph.visible;
        gAtom.source = this;
        GeometryRetained geometry = this.geometryList.get(0);
        if (geometry == null) {
            gAtom.geometryArray[0] = null;
        } else {
            gAtom.geometryArray[0] = (GeometryArrayRetained)morph.morphedGeometryArray.retained;
            gAtom.geoType = gAtom.geometryArray[0].geoType;
        }
        this.geomAtom = gAtom;
        this.sourceNode = morph;
    }

    void setMorphGeometry(Geometry geometry, ArrayList mirrorShapes) {
        int i;
        int nMirrorShapes = mirrorShapes.size();
        GeometryAtom[] oldGAArray = new GeometryAtom[nMirrorShapes];
        GeometryAtom[] newGAArray = new GeometryAtom[nMirrorShapes];
        for (i = 0; i < nMirrorShapes; ++i) {
            Shape3DRetained ms = (Shape3DRetained)mirrorShapes.get(i);
            GeometryAtom oldGA = Shape3DRetained.getGeomAtom(ms);
            ms.geometryList = new ArrayList(1);
            ms.geometryList.add((GeometryArrayRetained)geometry.retained);
            GeometryAtom newGA = new GeometryAtom();
            newGA.geometryArray = new GeometryRetained[1];
            if (geometry == null) {
                newGA.geometryArray[0] = null;
            } else {
                newGA.geometryArray[0] = (GeometryArrayRetained)geometry.retained;
                newGA.geoType = newGA.geometryArray[0].geoType;
            }
            newGA.locale = this.locale;
            newGA.visible = oldGA.visible;
            newGA.source = this;
            oldGAArray[i] = oldGA;
            newGAArray[i] = newGA;
            Shape3DRetained.setGeomAtom(ms, newGA);
        }
        TargetsInterface ti = ((GroupRetained)this.parent).getClosestTargetsInterface(0);
        CachedTargets[] newCtArr = null;
        if (ti != null) {
            newCtArr = new CachedTargets[nMirrorShapes];
            for (i = 0; i < nMirrorShapes; ++i) {
                CachedTargets ct = ti.getCachedTargets(0, i, -1);
                if (ct != null) {
                    newCtArr[i] = new CachedTargets();
                    newCtArr[i].copy(ct);
                    newCtArr[i].replace(oldGAArray[i], newGAArray[i], 0);
                    continue;
                }
                newCtArr[i] = null;
            }
        }
        J3dMessage changeMessage = new J3dMessage();
        changeMessage.type = 24;
        changeMessage.threads = 8384;
        changeMessage.universe = this.universe;
        changeMessage.args[0] = this;
        changeMessage.args[1] = new Integer(1);
        changeMessage.args[2] = oldGAArray;
        changeMessage.args[3] = newGAArray;
        if (ti != null) {
            changeMessage.args[4] = ti;
            changeMessage.args[5] = newCtArr;
        }
        VirtualUniverse.mc.processMessage(changeMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final GeometryAtom[] getGeomAtomsArray(ArrayList<Shape3DRetained> userList) {
        int i;
        int size;
        Shape3DRetained ms = null;
        GeometryAtom[] gaArr = null;
        int nullCnt = 0;
        ArrayList<Shape3DRetained> arrayList = userList;
        synchronized (arrayList) {
            size = userList.size();
            gaArr = new GeometryAtom[size];
            for (i = 0; i < size; ++i) {
                ms = userList.get(i);
                ms.mirrorShape3DLock.readLock();
                if (ms.geomAtom == null) {
                    ++nullCnt;
                }
                gaArr[i] = ms.geomAtom;
                ms.mirrorShape3DLock.readUnlock();
            }
        }
        if (nullCnt == 0) {
            return gaArr;
        }
        if (nullCnt == size) {
            return null;
        }
        GeometryAtom[] newGaArr = new GeometryAtom[size - nullCnt];
        int j = 0;
        for (i = 0; i < size; ++i) {
            if (gaArr[i] == null) continue;
            newGaArr[j++] = gaArr[i];
        }
        return newGaArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final ArrayList<ArrayList<GeometryAtom>> getGeomAtomsList(ArrayList userList, ArrayList<VirtualUniverse> univList) {
        ArrayList<ArrayList<GeometryAtom>> listPerUniverse = new ArrayList<ArrayList<GeometryAtom>>();
        ArrayList<GeometryAtom> gaList = null;
        Shape3DRetained ms = null;
        boolean moreThanOneUniv = false;
        VirtualUniverse firstFndUniv = null;
        ArrayList arrayList = userList;
        synchronized (arrayList) {
            for (int i = userList.size() - 1; i >= 0; --i) {
                ms = (Shape3DRetained)userList.get(i);
                if (!moreThanOneUniv) {
                    if (firstFndUniv == null) {
                        firstFndUniv = ms.universe;
                        univList.add(ms.universe);
                        gaList = new ArrayList();
                        listPerUniverse.add(gaList);
                    } else if (firstFndUniv != ms.universe) {
                        moreThanOneUniv = true;
                        univList.add(ms.universe);
                        gaList = new ArrayList();
                        listPerUniverse.add(gaList);
                    }
                } else {
                    int index = univList.indexOf(ms.universe);
                    if (index < 0) {
                        univList.add(ms.universe);
                        gaList = new ArrayList();
                        listPerUniverse.add(gaList);
                    } else {
                        gaList = listPerUniverse.get(index);
                    }
                }
                ms.mirrorShape3DLock.readLock();
                if (ms.geomAtom != null) {
                    gaList.add(ms.geomAtom);
                }
                ms.mirrorShape3DLock.readUnlock();
            }
        }
        return listPerUniverse;
    }

    static final GeometryAtom getGeomAtom(Shape3DRetained shape) {
        shape.mirrorShape3DLock.readLock();
        GeometryAtom ga = shape.geomAtom;
        shape.mirrorShape3DLock.readUnlock();
        return ga;
    }

    static final void setGeomAtom(Shape3DRetained shape, GeometryAtom ga) {
        shape.mirrorShape3DLock.writeLock();
        shape.geomAtom = ga;
        shape.mirrorShape3DLock.writeUnlock();
    }

    boolean isAlphaEditable(GeometryRetained geo) {
        boolean alphaEditable = false;
        if (this.appearanceOverrideEnable) {
            alphaEditable = true;
        } else if (geo != null && this.appearance != null) {
            AppearanceRetained app = this.appearance;
            if (this.source.getCapability(15) || this.source.getCapability(19) || app.source.getCapability(13) || app.source.getCapability(11) || app.renderingAttributes != null && (app.renderingAttributes.source.getCapability(3) || app.renderingAttributes.source.getCapability(10)) || app.transparencyAttributes != null && (app.transparencyAttributes.source.getCapability(1) || app.transparencyAttributes.source.getCapability(3))) {
                alphaEditable = true;
            } else if (geo instanceof GeometryArrayRetained && (app.source.getCapability(7) || app.textureAttributes != null && app.textureAttributes.source.getCapability(1))) {
                alphaEditable = true;
            } else if (geo instanceof RasterRetained && (((RasterRetained)geo).type & 1) != 0 && ((RasterRetained)geo).source.getCapability(5)) {
                alphaEditable = true;
            }
        }
        return alphaEditable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getCombineBounds(BoundingBox bounds) {
        if (this.geometryList != null) {
            BoundingBox bbox = null;
            if (this.staticTransform != null) {
                bbox = new BoundingBox((Bounds)null);
            }
            BoundingBox boundingBox = bounds;
            synchronized (boundingBox) {
                bounds.setLower(1.0, 1.0, 1.0);
                bounds.setUpper(-1.0, -1.0, -1.0);
                for (int i = 0; i < this.geometryList.size(); ++i) {
                    GeometryRetained geometry = this.geometryList.get(i);
                    if (geometry == null || geometry.geoType == -1) continue;
                    BoundingBox boundingBox2 = geometry.geoBounds;
                    synchronized (boundingBox2) {
                        if (this.staticTransform != null) {
                            bbox.set(geometry.geoBounds);
                            bbox.transform(this.staticTransform.transform);
                            bounds.combine(bbox);
                        } else {
                            bounds.combine(geometry.geoBounds);
                        }
                        continue;
                    }
                }
            }
            if (this instanceof OrientedShape3DRetained) {
                double maxVal = Math.abs(bounds.lower.x);
                double tempVal = Math.abs(bounds.upper.x);
                if (tempVal > maxVal) {
                    maxVal = tempVal;
                }
                if ((tempVal = Math.abs(bounds.lower.y)) > maxVal) {
                    maxVal = tempVal;
                }
                if ((tempVal = Math.abs(bounds.upper.y)) > maxVal) {
                    maxVal = tempVal;
                }
                if ((tempVal = Math.abs(bounds.lower.z)) > maxVal) {
                    maxVal = tempVal;
                }
                if ((tempVal = Math.abs(bounds.upper.z)) > maxVal) {
                    maxVal = tempVal;
                }
                bounds.setLower(-maxVal, -maxVal, -maxVal);
                bounds.setUpper(maxVal, maxVal, maxVal);
            }
        }
    }

    boolean isEquivalent(Shape3DRetained shape) {
        if (this.appearance != shape.appearance || this.appearanceOverrideEnable != shape.appearanceOverrideEnable || this.isPickable != shape.isPickable || this.isCollidable != shape.isCollidable) {
            return false;
        }
        if (this.boundsAutoCompute) {
            if (!shape.boundsAutoCompute) {
                return false;
            }
        } else if (this.localBounds != null) {
            if (shape.localBounds != null) {
                return this.localBounds.equals(shape.localBounds);
            }
        } else if (shape.localBounds != null) {
            return false;
        }
        if (this.collisionBound != null) {
            if (shape.collisionBound == null) {
                return false;
            }
            return this.collisionBound.equals(shape.collisionBound);
        }
        return shape.collisionBound == null;
    }

    void initializeGAtom(Shape3DRetained ms) {
        int gaCnt;
        int geometryCnt = 0;
        int gSize = this.geometryList.size();
        GeometryRetained geometry = null;
        ms.bounds = this.localBounds;
        ms.vwcBounds = new BoundingBox((Bounds)null);
        ms.vwcBounds.transform(ms.bounds, ms.getCurrentLocalToVworld(0));
        if (this.collisionBound == null) {
            ms.collisionBound = null;
            ms.collisionVwcBound = ms.vwcBounds;
        } else {
            ms.collisionBound = this.collisionBound;
            ms.collisionVwcBound = (Bounds)ms.collisionBound.clone();
            ms.collisionVwcBound.transform(ms.getCurrentLocalToVworld(0));
        }
        GeometryAtom gAtom = new GeometryAtom();
        for (gaCnt = 0; gaCnt < gSize; ++gaCnt) {
            geometry = this.geometryList.get(gaCnt);
            if (geometry == null) continue;
            gAtom.geoType = geometry.geoType;
            gAtom.alphaEditable = ms.isAlphaEditable(geometry);
            break;
        }
        if (geometry != null && geometry.geoType == 16) {
            for (gaCnt = 0; gaCnt < gSize; ++gaCnt) {
                geometry = this.geometryList.get(gaCnt);
                if (geometry != null) {
                    Text3DRetained tempT3d = (Text3DRetained)geometry;
                    geometryCnt += tempT3d.numChars;
                    continue;
                }
                ++geometryCnt;
            }
            gAtom.geometryArray = new GeometryRetained[geometryCnt];
            gAtom.lastLocalTransformArray = new Transform3D[geometryCnt];
            geometryCnt = 0;
        } else {
            gAtom.geometryArray = new GeometryRetained[gSize];
        }
        for (gaCnt = 0; gaCnt < this.geometryList.size(); ++gaCnt) {
            geometry = this.geometryList.get(gaCnt);
            if (geometry == null) {
                gAtom.geometryArray[gaCnt] = null;
                continue;
            }
            if (geometry.geoType == 16) {
                Text3DRetained t = (Text3DRetained)geometry;
                int i = 0;
                while (i < t.numChars) {
                    GeometryArrayRetained geo = t.geometryList[i];
                    if (geo != null) {
                        gAtom.geometryArray[geometryCnt] = geo;
                        gAtom.lastLocalTransformArray[geometryCnt] = t.charTransforms[i];
                    } else {
                        gAtom.geometryArray[geometryCnt] = null;
                        gAtom.lastLocalTransformArray[geometryCnt] = null;
                    }
                    ++i;
                    ++geometryCnt;
                }
                continue;
            }
            gAtom.geometryArray[gaCnt] = geometry;
        }
        gAtom.locale = ms.locale;
        gAtom.visible = this.visible;
        gAtom.source = ms;
        ms.geomAtom = gAtom;
    }

    void checkEquivalenceClass(Geometry geometry, int index) {
        if (geometry != null) {
            for (int i = this.geometryList.size() - 1; i >= 0; --i) {
                GeometryRetained geomRetained = this.geometryList.get(i);
                if (geomRetained == null || index == i) continue;
                if (geomRetained.isEquivalenceClass((GeometryRetained)geometry.retained)) break;
                throw new IllegalArgumentException(J3dI18N.getString("Shape3DRetained5"));
            }
        }
    }

    int indexOfGeometry(Geometry geometry) {
        if (geometry != null) {
            return this.geometryList.indexOf(geometry.retained);
        }
        return this.geometryList.indexOf(null);
    }

    void removeGeometry(Geometry geometry) {
        int ind = this.indexOfGeometry(geometry);
        if (ind >= 0) {
            this.removeGeometry(ind);
        }
    }

    void removeAllGeometries() {
        int n = this.geometryList.size();
        GeometryRetained oldGeom = null;
        if (((Shape3D)this.source).isLive()) {
            for (int index = n - 1; index >= 0; --index) {
                oldGeom = this.geometryList.get(index);
                if (oldGeom != null) {
                    oldGeom.clearLive(this.refCount);
                    oldGeom.decRefCnt();
                    for (int i = 0; i < this.mirrorShape3D.size(); ++i) {
                        Shape3DRetained mShape = this.mirrorShape3D.get(i);
                        oldGeom.removeUser(mShape);
                    }
                }
                this.geometryList.remove(index);
            }
            this.sendDataChangedMessage(null);
        } else {
            for (int index = n - 1; index >= 0; --index) {
                oldGeom = this.geometryList.get(index);
                if (oldGeom != null) {
                    oldGeom.decRefCnt();
                }
                this.geometryList.remove(index);
            }
        }
        this.dirtyBoundsCache();
    }

    boolean willRemainOpaque(int geoType) {
        return this.appearance == null || this.appearance.isStatic() && this.appearance.isOpaque(geoType);
    }

    @Override
    void handleFrequencyChange(int bit) {
        int mask = 0;
        if (bit == 13) {
            mask = 1;
        } else if (bit == 15) {
            mask = 2;
        } else if (bit == 19) {
            mask = 16;
        }
        if (mask != 0) {
            if (this.source.getCapabilityIsFrequent(bit)) {
                this.changedFrequent |= mask;
            } else if (!this.source.isLive()) {
                this.changedFrequent &= ~mask;
            }
        }
    }

    boolean isAlphaFrequentlyEditable(GeometryRetained geo) {
        boolean alphaFrequentlyEditable = false;
        if (this.appearanceOverrideEnable) {
            alphaFrequentlyEditable = true;
        } else if (geo != null && this.appearance != null) {
            AppearanceRetained app = this.appearance;
            if ((this.changedFrequent & 0x12) != 0 || (app.changedFrequent & 0x60) != 0 || app.renderingAttributes != null && (app.renderingAttributes.changedFrequent & 0x28) != 0 || app.transparencyAttributes != null && app.transparencyAttributes.changedFrequent != 0) {
                alphaFrequentlyEditable = true;
            } else if (geo instanceof GeometryArrayRetained && (app.changedFrequent & 8) != 0 || app.textureAttributes != null && (app.textureAttributes.changedFrequent & 1) != 0) {
                alphaFrequentlyEditable = true;
            } else if (geo instanceof RasterRetained && (((RasterRetained)geo).type & 1) != 0 && ((RasterRetained)geo).cachedChangedFrequent != 0) {
                alphaFrequentlyEditable = true;
            }
        }
        return alphaFrequentlyEditable;
    }

    int getPrimaryViewIdx() {
        UnorderList viewList = VirtualUniverse.mc.cloneView();
        View[] views = (View[])viewList.toArray(false);
        int size = viewList.arraySize();
        for (int i = 0; i < size; ++i) {
            if (!views[i].primaryView) continue;
            return views[i].viewIndex;
        }
        return 0;
    }

    @Override
    void searchGeometryAtoms(UnorderList list) {
        list.add(Shape3DRetained.getGeomAtom(this.getMirrorShape(this.key)));
    }
}

