/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.CapabilityNotSetException;
import org.scijava.java3d.HashKey;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.Link;
import org.scijava.java3d.LinkRetained;
import org.scijava.java3d.Locale;
import org.scijava.java3d.Node;
import org.scijava.java3d.NodeRetained;
import org.scijava.java3d.Shape3D;
import org.scijava.java3d.SharedGroupRetained;
import org.scijava.java3d.Transform3D;
import org.scijava.vecmath.Point3d;
import org.scijava.vecmath.Point4d;

public class SceneGraphPath {
    Locale root = null;
    Node[] interior = null;
    Node item = null;
    Transform3D transform = new Transform3D();
    Point3d intersectPoint = new Point3d();
    double pickDistance;

    public SceneGraphPath() {
    }

    public SceneGraphPath(Locale root, Node object) {
        this.item = object;
        this.root = root;
    }

    public SceneGraphPath(Locale root, Node[] nodes, Node object) {
        this.item = object;
        this.root = root;
        this.interior = new Node[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            this.interior[i] = nodes[i];
        }
    }

    SceneGraphPath(SceneGraphPath sgp) {
        this.set(sgp);
    }

    public final void set(SceneGraphPath newPath) {
        this.root = newPath.root;
        this.item = newPath.item;
        this.transform.set(newPath.transform);
        if (newPath.interior != null && newPath.interior.length > 0) {
            this.interior = new Node[newPath.interior.length];
            for (int i = 0; i < this.interior.length; ++i) {
                this.interior[i] = newPath.interior[i];
            }
        } else {
            this.interior = null;
        }
    }

    public final void setLocale(Locale newLocale) {
        this.root = newLocale;
    }

    public final void setObject(Node object) {
        this.item = object;
    }

    public final void setNodes(Node[] nodes) {
        if (nodes != null && nodes.length > 0) {
            this.interior = new Node[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                this.interior[i] = nodes[i];
            }
        } else {
            this.interior = null;
        }
    }

    public final void setNode(int index, Node newNode) {
        if (this.interior == null) {
            throw new NullPointerException(J3dI18N.getString("SceneGraphPath0"));
        }
        this.interior[index] = newNode;
    }

    public final void setTransform(Transform3D trans) {
        this.transform.set(trans);
    }

    public final Transform3D getTransform() {
        return new Transform3D(this.transform);
    }

    public final Locale getLocale() {
        return this.root;
    }

    public final Node getObject() {
        return this.item;
    }

    public final int nodeCount() {
        if (this.interior == null) {
            return 0;
        }
        return this.interior.length;
    }

    public final Node getNode(int index) {
        if (this.interior == null) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("SceneGraphPath1"));
        }
        return this.interior[index];
    }

    public boolean equals(SceneGraphPath testPath) {
        boolean result;
        block8: {
            result = true;
            try {
                if (testPath == null || this.root != testPath.root || this.item != testPath.item) {
                    return false;
                }
                result = this.transform.equals(testPath.transform);
                if (!result) {
                    return false;
                }
                if (this.interior == null || testPath.interior == null) {
                    if (this.interior != testPath.interior) {
                        return false;
                    }
                    result = this.root == testPath.root && this.item == testPath.item;
                    break block8;
                }
                if (this.interior.length == testPath.interior.length) {
                    for (int i = 0; i < this.interior.length; ++i) {
                        if (this.interior[i] == testPath.interior[i]) continue;
                        return false;
                    }
                    break block8;
                }
                return false;
            }
            catch (NullPointerException e2) {
                return false;
            }
        }
        return result;
    }

    public boolean equals(Object o1) {
        boolean result = true;
        try {
            SceneGraphPath testPath = (SceneGraphPath)o1;
            if (testPath == null || this.root != testPath.root || this.item != testPath.item) {
                return false;
            }
            result = this.transform.equals(testPath.transform);
            if (!result) {
                return false;
            }
            if (this.interior == null || testPath.interior == null) {
                if (this.interior != testPath.interior) {
                    return false;
                }
                result = this.root == testPath.root && this.item == testPath.item;
            } else if (this.interior.length == testPath.interior.length) {
                for (int i = 0; i < this.interior.length; ++i) {
                    if (this.interior[i] == testPath.interior[i]) continue;
                    return false;
                }
            } else {
                return false;
            }
            return result;
        }
        catch (NullPointerException e2) {
            return false;
        }
        catch (ClassCastException e1) {
            return false;
        }
    }

    public int hashCode() {
        HashKey key = new HashKey(250);
        if (this.interior != null && this.item != null) {
            for (int i = 0; i < this.interior.length; ++i) {
                key.append(LinkRetained.plus).append(this.item.toString());
            }
        }
        return key.hashCode() + this.transform.hashCode();
    }

    public final boolean isSamePath(SceneGraphPath testPath) {
        int count = 0;
        if (testPath == null || testPath.item != this.item || this.root != testPath.root) {
            return false;
        }
        if (this.interior != null && testPath.interior != null) {
            block0: for (int i = 0; i < this.interior.length; ++i) {
                if (!(this.interior[i] instanceof Link)) continue;
                while (count < testPath.interior.length) {
                    if (testPath.interior[count] instanceof Link) {
                        if (testPath.interior[count] != this.interior[i]) {
                            return false;
                        }
                        ++count;
                        continue block0;
                    }
                    if (++count != testPath.interior.length) continue;
                    return false;
                }
            }
            while (count < testPath.interior.length) {
                if (testPath.interior[count] instanceof Link) {
                    return false;
                }
                ++count;
            }
        } else if (this.interior != testPath.interior) {
            return false;
        }
        return true;
    }

    public String toString() {
        Object obj;
        StringBuffer str = new StringBuffer();
        if (this.root == null && this.interior == null && this.item == null) {
            return super.toString();
        }
        if (this.root != null) {
            str.append(this.root + " : ");
        }
        if (this.interior != null) {
            for (int i = 0; i < this.interior.length; ++i) {
                str.append(this.interior[i].getClass().getName());
                obj = this.interior[i].getUserData();
                if (obj == null) {
                    str.append(" : ");
                    continue;
                }
                str.append(", " + obj + " : ");
            }
        }
        if (this.item != null) {
            str.append(this.item.getClass().getName());
            obj = this.item.getUserData();
            if (obj != null) {
                str.append(", " + obj);
            }
            try {
                if (this.item.getClass().getName().equals("org.scijava.java3d.Shape3D")) {
                    str.append(((Shape3D)this.item).getGeometry());
                }
            }
            catch (CapabilityNotSetException capabilityNotSetException) {
                // empty catch block
            }
        }
        str.append("\nLocalToVworld Transform:\n" + this.transform);
        return new String(str);
    }

    boolean validate() {
        int idx;
        NodeRetained node = (NodeRetained)this.item.retained;
        Locale locale = node.locale;
        if (this.root != null) {
            if (this.item.isLive() && locale != this.root) {
                return false;
            }
        } else {
            this.root = locale;
        }
        int n = idx = this.interior == null ? 0 : this.interior.length;
        do {
            if (node instanceof SharedGroupRetained) {
                if (this.interior == null) {
                    return false;
                }
                while (--idx > 0 && !((SharedGroupRetained)node).parents.contains(this.interior[idx].retained)) {
                }
                if (idx < 0) {
                    return false;
                }
                node = (NodeRetained)this.interior[idx].retained;
                continue;
            }
            node = node.parent;
        } while (node != null);
        return true;
    }

    void getHashKey(HashKey key) {
        if (this.interior != null) {
            key.reset();
            key.append(this.root.nodeId);
            for (int i = 0; i < this.interior.length; ++i) {
                Node node = this.interior[i];
                if (!node.isLive()) {
                    throw new RuntimeException(J3dI18N.getString("SceneGraphPath3"));
                }
                NodeRetained nodeR = (NodeRetained)node.retained;
                if (nodeR.nodeType != 9) continue;
                key.append("+").append(nodeR.nodeId);
            }
        }
    }

    boolean validate(HashKey key) {
        NodeRetained currentNR;
        if (this.root == null) {
            throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath2"));
        }
        if (this.item == null) {
            throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath10"));
        }
        if (!this.item.isLive()) {
            throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath3"));
        }
        try {
            this.getHashKey(key);
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        NodeRetained nextNR = null;
        boolean count = false;
        NodeRetained bottomNR = (NodeRetained)this.item.retained;
        if (this.interior != null) {
            for (int i = this.interior.length - 1; i >= 0; --i) {
                nextNR = (NodeRetained)this.interior[i].retained;
                currentNR = bottomNR.parent;
                if (currentNR == null && bottomNR instanceof SharedGroupRetained) {
                    if (((SharedGroupRetained)bottomNR).parents.contains(nextNR)) {
                        currentNR = nextNR;
                    } else {
                        throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath5"));
                    }
                }
                while (currentNR != nextNR) {
                    if (currentNR == null) {
                        throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath11"));
                    }
                    if (currentNR instanceof SharedGroupRetained) {
                        if (((SharedGroupRetained)currentNR).parents.contains(nextNR)) {
                            currentNR = nextNR;
                            continue;
                        }
                        throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath5"));
                    }
                    currentNR = currentNR.parent;
                }
                bottomNR = currentNR;
            }
        }
        if ((currentNR = bottomNR.parent) == null && bottomNR instanceof SharedGroupRetained) {
            throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath5"));
        }
        while (currentNR != null) {
            if (currentNR instanceof LinkRetained) {
                throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath5"));
            }
            bottomNR = currentNR;
            currentNR = currentNR.parent;
            if (currentNR != null || !(bottomNR instanceof SharedGroupRetained)) continue;
            throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath5"));
        }
        Node currentNode = (Node)bottomNR.source;
        if (!this.root.branchGroups.contains(currentNode)) {
            throw new IllegalArgumentException(J3dI18N.getString("SceneGraphPath9"));
        }
        return true;
    }

    double getDistanceFrom(Point3d origin) {
        return this.intersectPoint.distance(origin);
    }

    double getDistance() {
        return this.pickDistance;
    }

    final void setIntersectPoint(Point3d point) {
        this.intersectPoint.set(point);
    }

    final void setIntersectPointDis(Point4d pickLocation) {
        this.intersectPoint.x = pickLocation.x;
        this.intersectPoint.y = pickLocation.y;
        this.intersectPoint.z = pickLocation.z;
        this.pickDistance = pickLocation.w;
    }

    final Point3d getIntersectPoint() {
        return this.intersectPoint;
    }
}

