/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.Alpha;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.Node;
import org.scijava.java3d.PathInterpolator;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransformGroup;
import org.scijava.java3d.WakeupCriterion;
import org.scijava.java3d.WakeupOnElapsedFrames;
import org.scijava.vecmath.Matrix4d;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Quat4f;
import org.scijava.vecmath.Vector3f;

public class RotPosScalePathInterpolator
extends PathInterpolator {
    private Transform3D rotation = new Transform3D();
    private Vector3f pos = new Vector3f();
    private Quat4f tQuat = new Quat4f();
    private Matrix4d tMat = new Matrix4d();
    private Matrix4d sMat = new Matrix4d();
    private Quat4f[] quats;
    private Point3f[] positions;
    private float[] scales;
    private float prevInterpolationValue = Float.NaN;
    private float prevAlphaValue = Float.NaN;
    private WakeupCriterion passiveWakeupCriterion = new WakeupOnElapsedFrames(0, true);

    RotPosScalePathInterpolator() {
    }

    public RotPosScalePathInterpolator(Alpha alpha, TransformGroup target, Transform3D axisOfTransform, float[] knots, Quat4f[] quats, Point3f[] positions, float[] scales) {
        super(alpha, target, axisOfTransform, knots);
        if (knots.length != quats.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotPosScalePathInterpolator1"));
        }
        if (knots.length != positions.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotPosScalePathInterpolator0"));
        }
        if (knots.length != scales.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotPosScalePathInterpolator2"));
        }
        this.setPathArrays(quats, positions, scales);
    }

    public void setQuat(int index, Quat4f quat) {
        this.quats[index].set(quat);
    }

    public void getQuat(int index, Quat4f quat) {
        quat.set(this.quats[index]);
    }

    public void setPosition(int index, Point3f position) {
        this.positions[index].set(position);
    }

    public void getPosition(int index, Point3f position) {
        position.set(this.positions[index]);
    }

    public void setScale(int index, float scale) {
        this.scales[index] = scale;
    }

    public float getScale(int index) {
        return this.scales[index];
    }

    public void setPathArrays(float[] knots, Quat4f[] quats, Point3f[] positions, float[] scales) {
        if (knots.length != quats.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotPosScalePathInterpolator1"));
        }
        if (knots.length != positions.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotPosScalePathInterpolator0"));
        }
        if (knots.length != scales.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotPosScalePathInterpolator2"));
        }
        this.setKnots(knots);
        this.setPathArrays(quats, positions, scales);
    }

    private void setPathArrays(Quat4f[] quats, Point3f[] positions, float[] scales) {
        int i;
        this.quats = new Quat4f[quats.length];
        for (i = 0; i < quats.length; ++i) {
            this.quats[i] = new Quat4f();
            this.quats[i].set(quats[i]);
        }
        this.positions = new Point3f[positions.length];
        for (i = 0; i < positions.length; ++i) {
            this.positions[i] = new Point3f();
            this.positions[i].set(positions[i]);
        }
        this.scales = new float[scales.length];
        for (i = 0; i < scales.length; ++i) {
            this.scales[i] = scales[i];
        }
    }

    public void getQuats(Quat4f[] quats) {
        for (int i = 0; i < this.quats.length; ++i) {
            quats[i].set(this.quats[i]);
        }
    }

    public void getPositions(Point3f[] positions) {
        for (int i = 0; i < this.positions.length; ++i) {
            positions[i].set(this.positions[i]);
        }
    }

    public void getScales(float[] scales) {
        for (int i = 0; i < this.scales.length; ++i) {
            scales[i] = this.scales[i];
        }
    }

    public void setAxisOfRotPosScale(Transform3D axisOfRotPosScale) {
        this.setTransformAxis(axisOfRotPosScale);
    }

    public Transform3D getAxisOfRotPosScale() {
        return this.getTransformAxis();
    }

    @Override
    public void computeTransform(float alphaValue, Transform3D transform) {
        float scale;
        this.computePathInterpolation(alphaValue);
        if (this.currentKnotIndex == 0 && this.currentInterpolationValue == 0.0f) {
            this.tQuat.x = this.quats[0].x;
            this.tQuat.y = this.quats[0].y;
            this.tQuat.z = this.quats[0].z;
            this.tQuat.w = this.quats[0].w;
            this.pos.x = this.positions[0].x;
            this.pos.y = this.positions[0].y;
            this.pos.z = this.positions[0].z;
            scale = this.scales[0];
        } else {
            double quatDot = this.quats[this.currentKnotIndex].x * this.quats[this.currentKnotIndex + 1].x + this.quats[this.currentKnotIndex].y * this.quats[this.currentKnotIndex + 1].y + this.quats[this.currentKnotIndex].z * this.quats[this.currentKnotIndex + 1].z + this.quats[this.currentKnotIndex].w * this.quats[this.currentKnotIndex + 1].w;
            if (quatDot < 0.0) {
                this.tQuat.x = this.quats[this.currentKnotIndex].x + (-this.quats[this.currentKnotIndex + 1].x - this.quats[this.currentKnotIndex].x) * this.currentInterpolationValue;
                this.tQuat.y = this.quats[this.currentKnotIndex].y + (-this.quats[this.currentKnotIndex + 1].y - this.quats[this.currentKnotIndex].y) * this.currentInterpolationValue;
                this.tQuat.z = this.quats[this.currentKnotIndex].z + (-this.quats[this.currentKnotIndex + 1].z - this.quats[this.currentKnotIndex].z) * this.currentInterpolationValue;
                this.tQuat.w = this.quats[this.currentKnotIndex].w + (-this.quats[this.currentKnotIndex + 1].w - this.quats[this.currentKnotIndex].w) * this.currentInterpolationValue;
            } else {
                this.tQuat.x = this.quats[this.currentKnotIndex].x + (this.quats[this.currentKnotIndex + 1].x - this.quats[this.currentKnotIndex].x) * this.currentInterpolationValue;
                this.tQuat.y = this.quats[this.currentKnotIndex].y + (this.quats[this.currentKnotIndex + 1].y - this.quats[this.currentKnotIndex].y) * this.currentInterpolationValue;
                this.tQuat.z = this.quats[this.currentKnotIndex].z + (this.quats[this.currentKnotIndex + 1].z - this.quats[this.currentKnotIndex].z) * this.currentInterpolationValue;
                this.tQuat.w = this.quats[this.currentKnotIndex].w + (this.quats[this.currentKnotIndex + 1].w - this.quats[this.currentKnotIndex].w) * this.currentInterpolationValue;
            }
            this.pos.x = this.positions[this.currentKnotIndex].x + (this.positions[this.currentKnotIndex + 1].x - this.positions[this.currentKnotIndex].x) * this.currentInterpolationValue;
            this.pos.y = this.positions[this.currentKnotIndex].y + (this.positions[this.currentKnotIndex + 1].y - this.positions[this.currentKnotIndex].y) * this.currentInterpolationValue;
            this.pos.z = this.positions[this.currentKnotIndex].z + (this.positions[this.currentKnotIndex + 1].z - this.positions[this.currentKnotIndex].z) * this.currentInterpolationValue;
            scale = this.scales[this.currentKnotIndex] + (this.scales[this.currentKnotIndex + 1] - this.scales[this.currentKnotIndex]) * this.currentInterpolationValue;
        }
        this.tQuat.normalize();
        this.sMat.set(scale);
        this.tMat.set(this.tQuat);
        this.tMat.mul(this.sMat);
        this.tMat.m03 = this.pos.x;
        this.tMat.m13 = this.pos.y;
        this.tMat.m23 = this.pos.z;
        this.rotation.set(this.tMat);
        transform.mul(this.axis, this.rotation);
        transform.mul(transform, this.axisInverse);
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        RotPosScalePathInterpolator ri = new RotPosScalePathInterpolator();
        ri.duplicateNode(this, forceDuplicate);
        return ri;
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        RotPosScalePathInterpolator ri = (RotPosScalePathInterpolator)originalNode;
        int len = ri.getArrayLengths();
        this.positions = new Point3f[len];
        this.quats = new Quat4f[len];
        this.scales = new float[len];
        Point3f point = new Point3f();
        Quat4f quat = new Quat4f();
        for (int i = 0; i < len; ++i) {
            this.positions[i] = new Point3f();
            ri.getPosition(i, point);
            this.setPosition(i, point);
            this.quats[i] = new Quat4f();
            ri.getQuat(i, quat);
            this.setQuat(i, quat);
            this.setScale(i, ri.getScale(i));
        }
    }
}

