/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import org.scijava.java3d.Bounds;
import org.scijava.java3d.Canvas3D;
import org.scijava.java3d.DepthComponent;
import org.scijava.java3d.DepthComponentIntRetained;
import org.scijava.java3d.DepthComponentRetained;
import org.scijava.java3d.GeometryRetained;
import org.scijava.java3d.ImageComponent;
import org.scijava.java3d.ImageComponent2D;
import org.scijava.java3d.ImageComponent2DRetained;
import org.scijava.java3d.ImageComponentRetained;
import org.scijava.java3d.ImageComponentUpdateInfo;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.J3dMessage;
import org.scijava.java3d.PickInfo;
import org.scijava.java3d.PickShape;
import org.scijava.java3d.RenderAtom;
import org.scijava.java3d.RenderMolecule;
import org.scijava.java3d.Shape3DRetained;
import org.scijava.java3d.Texture2D;
import org.scijava.java3d.Texture2DRetained;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.VirtualUniverse;
import org.scijava.vecmath.Point2d;
import org.scijava.vecmath.Point2i;
import org.scijava.vecmath.Point3d;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Point4d;

class RasterRetained
extends GeometryRetained {
    int type = 1;
    private int clipMode = 0;
    private Point3f position = new Point3f();
    private int xSrcOffset = 0;
    private int ySrcOffset = 0;
    private int width = 0;
    private int height = 0;
    private int xDstOffset = 0;
    private int yDstOffset = 0;
    ImageComponent2DRetained image = null;
    Texture2DRetained texture = null;
    DepthComponentRetained depthComponent = null;

    RasterRetained() {
        this.geoType = 15;
    }

    final void setPosition(Point3f pos) {
        this.geomLock.getLock();
        this.position.x = pos.x;
        this.position.y = pos.y;
        this.position.z = pos.z;
        this.geomLock.unLock();
        this.sendChangedMessage(64, null, null);
    }

    final void getPosition(Point3f pos) {
        pos.x = this.position.x;
        pos.y = this.position.y;
        pos.z = this.position.z;
    }

    final void setType(int type) {
        this.geomLock.getLock();
        this.type = type;
        this.geomLock.unLock();
    }

    final int getType() {
        return this.type;
    }

    final void setClipMode(int clipMode) {
        this.geomLock.getLock();
        this.clipMode = clipMode;
        this.geomLock.unLock();
        this.computeBoundingBox();
        if (this.source.isLive()) {
            int un = this.userLists.size();
            for (int i = 0; i < un; ++i) {
                ArrayList shapeList = (ArrayList)this.userLists.get(i);
                int sn = shapeList.size();
                for (int j = 0; j < sn; ++j) {
                    Shape3DRetained ms = (Shape3DRetained)shapeList.get(j);
                    Shape3DRetained shape = (Shape3DRetained)ms.sourceNode;
                    shape.setBoundsAutoCompute(false);
                    shape.setBounds(this.geoBounds);
                }
            }
        }
    }

    final int getClipMode() {
        return this.clipMode;
    }

    final void setSrcOffset(int xSrcOffset, int ySrcOffset) {
        this.geomLock.getLock();
        this.xSrcOffset = xSrcOffset;
        this.ySrcOffset = ySrcOffset;
        this.geomLock.unLock();
    }

    final void getSrcOffset(Point srcOffset) {
        srcOffset.setLocation(this.xSrcOffset, this.ySrcOffset);
    }

    final void setSize(int width, int height) {
        this.geomLock.getLock();
        this.width = width;
        this.height = height;
        this.geomLock.unLock();
    }

    final void getSize(Dimension size) {
        size.setSize(this.width, this.height);
    }

    final void setDstOffset(int xDstOffset, int yDstOffset) {
        this.geomLock.getLock();
        this.xDstOffset = xDstOffset;
        this.yDstOffset = yDstOffset;
        this.geomLock.unLock();
    }

    final void getDstOffset(Point dstOffset) {
        dstOffset.setLocation(this.xDstOffset, this.yDstOffset);
    }

    final void initImage(ImageComponent2D img) {
        int texFormat;
        if (img == null) {
            this.image = null;
            this.texture = null;
            return;
        }
        this.image = (ImageComponent2DRetained)img.retained;
        this.image.setEnforceNonPowerOfTwoSupport(true);
        switch (this.image.getNumberOfComponents()) {
            case 1: {
                texFormat = 1;
                break;
            }
            case 2: {
                texFormat = 4;
                break;
            }
            case 3: {
                texFormat = 5;
                break;
            }
            case 4: {
                texFormat = 6;
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
        Texture2D tex2D = new Texture2D(1, texFormat, img.getWidth(), img.getHeight());
        this.texture = (Texture2DRetained)tex2D.retained;
        this.texture.setUseAsRaster(true);
        this.image.addUser(this.texture);
        this.texture.initImage(0, img);
    }

    final void setImage(ImageComponent2D img) {
        if (img != null && img.getImageClass() == ImageComponent.ImageClass.NIO_IMAGE_BUFFER) {
            throw new IllegalArgumentException(J3dI18N.getString("Background14"));
        }
        Texture2DRetained oldTex = this.texture;
        if (this.source.isLive() && this.texture != null) {
            this.texture.clearLive(this.refCount);
        }
        this.geomLock.getLock();
        this.initImage(img);
        this.geomLock.unLock();
        if (this.source.isLive()) {
            if (this.texture != null) {
                this.texture.setLive(this.inBackgroundGroup, this.refCount);
            }
            this.sendChangedMessage(1152, oldTex, this.texture);
        }
    }

    final ImageComponent2D getImage() {
        return this.image == null ? null : (ImageComponent2D)this.image.source;
    }

    final void setDepthComponent(DepthComponent depthComponent) {
        this.geomLock.getLock();
        if (this.source.isLive()) {
            if (this.depthComponent != null) {
                this.depthComponent.clearLive(this.refCount);
            }
            if (depthComponent != null) {
                ((DepthComponentRetained)depthComponent.retained).setLive(this.inBackgroundGroup, this.refCount);
            }
        }
        this.depthComponent = depthComponent == null ? null : (DepthComponentRetained)depthComponent.retained;
        this.geomLock.unLock();
    }

    final DepthComponent getDepthComponent() {
        return this.depthComponent == null ? null : (DepthComponent)this.depthComponent.source;
    }

    @Override
    void setLive(boolean inBackgroundGroup, int refCount) {
        super.doSetLive(inBackgroundGroup, refCount);
        if (this.texture != null) {
            this.texture.setLive(inBackgroundGroup, refCount);
        }
        if (this.depthComponent != null) {
            this.depthComponent.setLive(inBackgroundGroup, refCount);
        }
        this.isEditable = this.source.getCapability(3) || this.source.getCapability(1) || (this.type & 1) != 0 && this.source.getCapability(5) || (this.type & 2) != 0 && this.source.getCapability(7) || this.source.getCapability(9);
        super.markAsLive();
    }

    @Override
    void clearLive(int refCount) {
        super.clearLive(refCount);
        if (this.texture != null) {
            this.texture.clearLive(refCount);
        }
        if (this.depthComponent != null) {
            this.depthComponent.clearLive(refCount);
        }
    }

    @Override
    void computeBoundingBox() {
        if (this.clipMode == 1) {
            Point3d minBounds = new Point3d(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            Point3d maxBounds = new Point3d(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            this.geoBounds.setUpper(maxBounds);
            this.geoBounds.setLower(minBounds);
        } else {
            Point3d center = new Point3d();
            center.x = this.position.x;
            center.y = this.position.y;
            center.z = this.position.z;
            this.geoBounds.setUpper(center);
            this.geoBounds.setLower(center);
        }
    }

    @Override
    void update() {
        this.computeBoundingBox();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendChangedMessage(int threads, Object arg1, Object arg2) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                ArrayList arrayList = this.universeList;
                synchronized (arrayList) {
                    int numMessages = this.universeList.size();
                    J3dMessage[] m = new J3dMessage[numMessages];
                    for (int i = 0; i < numMessages; ++i) {
                        m[i] = new J3dMessage();
                        m[i].type = 17;
                        m[i].threads = threads;
                        m[i].args[0] = Shape3DRetained.getGeomAtomsArray((ArrayList)this.userLists.get(i));
                        m[i].args[1] = this;
                        Object[] obj = new Object[]{arg1, arg2};
                        m[i].args[2] = obj;
                        m[i].args[3] = new Integer(this.changedFrequent);
                        m[i].universe = (VirtualUniverse)this.universeList.get(i);
                    }
                    VirtualUniverse.mc.processMessage(m);
                }
            }
        }
    }

    @Override
    void execute(Canvas3D cv, RenderAtom ra, boolean isNonUniformScale, boolean updateAlpha, float alpha, int screen, boolean ignoreVertexColors) {
        Point3d adjPos = new Point3d();
        adjPos.set(this.position);
        Point2d winCoord = new Point2d();
        Transform3D localToImagePlate = new Transform3D();
        Point3d clipCoord = this.computeWinCoord(cv, ra, winCoord, adjPos, localToImagePlate);
        if (clipCoord == null) {
            return;
        }
        if (this.clipMode == 0 && !this.isRasterClipPositionInside(clipCoord)) {
            return;
        }
        winCoord.x += (double)this.xDstOffset;
        winCoord.y += (double)this.yDstOffset;
        if (this.type == 1 || this.type == 3) {
            float devCoordZ = (float)(clipCoord.z * 0.5 - 0.5);
            if (this.texture != null) {
                cv.updateTextureForRaster(this.texture);
                cv.textureFill(this, winCoord, devCoordZ, alpha);
                cv.restoreTextureBin();
            }
        }
        if (this.type == 2 || this.type == 3) {
            Point2i srcOffset = new Point2i(this.xSrcOffset, this.ySrcOffset);
            if (this.clipMode == 1) {
                this.clipImage(cv, ra, winCoord, srcOffset);
            }
            this.computeObjCoord(cv, winCoord, adjPos, localToImagePlate);
            cv.executeRasterDepth(cv.ctx, (float)adjPos.x, (float)adjPos.y, (float)adjPos.z, srcOffset.x, srcOffset.y, this.width, this.height, this.depthComponent.width, this.depthComponent.height, this.depthComponent.type, ((DepthComponentIntRetained)this.depthComponent).depthData);
        }
    }

    private void clipImage(Canvas3D canvas, RenderAtom ra, Point2d winCoord, Point2i srcOffset) {
        if (winCoord.x > 0.0 && winCoord.y > 0.0) {
            return;
        }
        if (winCoord.x < 1.0) {
            srcOffset.x = (int)(-winCoord.x) + 1;
            winCoord.x = 1.0;
        }
        if (winCoord.y < 1.0) {
            srcOffset.y = (int)(-winCoord.y) + 1;
            winCoord.y = 1.0;
        }
        if (srcOffset.x < this.xSrcOffset) {
            srcOffset.x = this.xSrcOffset;
        }
        if (srcOffset.y < this.ySrcOffset) {
            srcOffset.y = this.ySrcOffset;
        }
    }

    private boolean isRasterClipPositionInside(Point3d clipCoord) {
        return clipCoord.x >= -1.0 && clipCoord.x <= 1.0 && clipCoord.y >= -1.0 && clipCoord.y <= 1.0;
    }

    private void computeObjCoord(Canvas3D canvas, Point2d winCoord, Point3d objCoord, Transform3D localToImagePlate) {
        canvas.getPixelLocationInImagePlate(winCoord.x, winCoord.y, objCoord.z, objCoord);
        localToImagePlate.invert();
        localToImagePlate.transform(objCoord);
    }

    private Point3d computeWinCoord(Canvas3D canvas, RenderAtom ra, Point2d winCoord, Point3d objCoord, Transform3D localToImagePlate) {
        RenderMolecule rm = ra.renderMolecule;
        if (rm == null) {
            return null;
        }
        Transform3D lvw = rm.localToVworld[rm.localToVworldIndex[0]];
        Point3d clipCoord3 = new Point3d();
        clipCoord3.set(objCoord);
        Point4d clipCoord4 = new Point4d();
        lvw.transform(clipCoord3);
        canvas.vworldToEc.transform(clipCoord3);
        canvas.projTrans.transform(clipCoord3, clipCoord4);
        if (clipCoord4.w <= 0.0 || clipCoord4.z > clipCoord4.w || -clipCoord4.z > clipCoord4.w) {
            return null;
        }
        double invW = 1.0 / clipCoord4.w;
        clipCoord3.x = clipCoord4.x * invW;
        clipCoord3.y = clipCoord4.y * invW;
        clipCoord3.z = clipCoord4.z * invW;
        canvas.getLastVworldToImagePlate(localToImagePlate);
        localToImagePlate.mul(lvw);
        localToImagePlate.transform(objCoord);
        canvas.getPixelLocationFromImagePlate(objCoord, winCoord);
        return clipCoord3;
    }

    @Override
    int getClassType() {
        return 5;
    }

    void notifyImageComponentImageChanged(ImageComponentRetained image, ImageComponentUpdateInfo value) {
    }

    @Override
    boolean intersect(PickShape pickShape, PickInfo pickInfo, int flags, Point3d iPnt, GeometryRetained geom, int geomIndex) {
        return false;
    }

    @Override
    boolean intersect(Bounds targetBound) {
        return false;
    }

    @Override
    boolean intersect(Point3d[] pnts) {
        return false;
    }

    @Override
    boolean intersect(Transform3D thisToOtherVworld, GeometryRetained geom) {
        return false;
    }

    @Override
    boolean intersect(Transform3D thisLocalToVworld, Transform3D otherLocalToVworld, GeometryRetained geom) {
        return false;
    }

    @Override
    boolean intersect(Transform3D thisLocalToVworld, Bounds targetBound) {
        return false;
    }

    @Override
    void handleFrequencyChange(int bit) {
        if (bit == 5) {
            this.setFrequencyChangeMask(bit, 1);
        }
    }
}

