/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.Alpha;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.Node;
import org.scijava.java3d.PathInterpolator;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransformGroup;
import org.scijava.java3d.WakeupCriterion;
import org.scijava.java3d.WakeupOnElapsedFrames;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Vector3f;

public class PositionPathInterpolator
extends PathInterpolator {
    private Transform3D position = new Transform3D();
    private Vector3f pos = new Vector3f();
    private Point3f[] positions;
    private float prevInterpolationValue = Float.NaN;
    private float prevAlphaValue = Float.NaN;
    private WakeupCriterion passiveWakeupCriterion = new WakeupOnElapsedFrames(0, true);

    PositionPathInterpolator() {
    }

    public PositionPathInterpolator(Alpha alpha, TransformGroup target, Transform3D axisOfTransform, float[] knots, Point3f[] positions) {
        super(alpha, target, axisOfTransform, knots);
        if (knots.length != positions.length) {
            throw new IllegalArgumentException(J3dI18N.getString("PositionPathInterpolator0"));
        }
        this.setPathArrays(positions);
    }

    public void setPosition(int index, Point3f position) {
        this.positions[index].set(position);
    }

    public void getPosition(int index, Point3f position) {
        position.set(this.positions[index]);
    }

    public void setPathArrays(float[] knots, Point3f[] positions) {
        if (knots.length != positions.length) {
            throw new IllegalArgumentException(J3dI18N.getString("PositionPathInterpolator0"));
        }
        this.setKnots(knots);
        this.setPathArrays(positions);
    }

    private void setPathArrays(Point3f[] positions) {
        this.positions = new Point3f[positions.length];
        for (int i = 0; i < positions.length; ++i) {
            this.positions[i] = new Point3f();
            this.positions[i].set(positions[i]);
        }
    }

    public void getPositions(Point3f[] positions) {
        for (int i = 0; i < this.positions.length; ++i) {
            positions[i].set(this.positions[i]);
        }
    }

    public void setAxisOfTranslation(Transform3D axisOfTranslation) {
        this.setTransformAxis(axisOfTranslation);
    }

    public Transform3D getAxisOfTranslation() {
        return this.getTransformAxis();
    }

    @Override
    public void computeTransform(float alphaValue, Transform3D transform) {
        this.computePathInterpolation(alphaValue);
        if (this.currentKnotIndex == 0 && this.currentInterpolationValue == 0.0f) {
            this.pos.x = this.positions[0].x;
            this.pos.y = this.positions[0].y;
            this.pos.z = this.positions[0].z;
        } else {
            this.pos.x = this.positions[this.currentKnotIndex].x + (this.positions[this.currentKnotIndex + 1].x - this.positions[this.currentKnotIndex].x) * this.currentInterpolationValue;
            this.pos.y = this.positions[this.currentKnotIndex].y + (this.positions[this.currentKnotIndex + 1].y - this.positions[this.currentKnotIndex].y) * this.currentInterpolationValue;
            this.pos.z = this.positions[this.currentKnotIndex].z + (this.positions[this.currentKnotIndex + 1].z - this.positions[this.currentKnotIndex].z) * this.currentInterpolationValue;
        }
        this.position.setIdentity();
        this.position.setTranslation(this.pos);
        transform.mul(this.axis, this.position);
        transform.mul(transform, this.axisInverse);
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        PositionPathInterpolator ppi = new PositionPathInterpolator();
        ppi.duplicateNode(this, forceDuplicate);
        return ppi;
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        PositionPathInterpolator pi = (PositionPathInterpolator)originalNode;
        int len = pi.getArrayLengths();
        this.positions = new Point3f[len];
        Point3f dupPoint = new Point3f();
        for (int i = 0; i < len; ++i) {
            this.positions[i] = new Point3f();
            pi.getPosition(i, dupPoint);
            this.setPosition(i, dupPoint);
        }
    }
}

