/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.BoundingBox;
import org.scijava.java3d.BoundingPolytope;
import org.scijava.java3d.BoundingSphere;
import org.scijava.java3d.Bounds;
import org.scijava.java3d.PickCone;
import org.scijava.java3d.PickCylinder;
import org.scijava.java3d.PickShape;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.Utils;
import org.scijava.vecmath.Point3d;
import org.scijava.vecmath.Point4d;
import org.scijava.vecmath.Vector3d;

public final class PickConeRay
extends PickCone {
    public PickConeRay() {
    }

    public PickConeRay(Point3d origin, Vector3d direction, double spreadAngle) {
        this.origin = new Point3d(origin);
        this.direction = new Vector3d(direction);
        this.spreadAngle = spreadAngle;
    }

    public void set(Point3d origin, Vector3d direction, double spreadAngle) {
        this.origin.set(origin);
        this.direction.set(direction);
        this.spreadAngle = spreadAngle;
    }

    @Override
    final boolean intersect(Bounds bounds, Point4d pickPos) {
        Point4d iPnt = new Point4d();
        Vector3d vector = new Vector3d();
        Point3d rayPt = new Point3d();
        if (bounds instanceof BoundingSphere) {
            Point3d sphCenter = ((BoundingSphere)bounds).getCenter();
            double sphRadius = ((BoundingSphere)bounds).getRadius();
            double sqDist = Utils.ptToRaySquare(sphCenter, this.origin, this.direction, rayPt);
            vector.sub(rayPt, this.origin);
            double distance = vector.length();
            double radius = this.getRadius(distance);
            return sqDist <= (sphRadius + radius) * (sphRadius + radius);
        }
        if (bounds instanceof BoundingBox) {
            Point3d lower = new Point3d();
            ((BoundingBox)bounds).getLower(lower);
            Point3d center = ((BoundingBox)bounds).getCenter();
            double sqDist = Utils.ptToRaySquare(center, this.origin, this.direction, rayPt);
            vector.sub(rayPt, this.origin);
            double distance = vector.length();
            double radius = this.getRadius(distance);
            double temp = center.x - lower.x + radius;
            double boxRadiusSquared = temp * temp;
            temp = center.y - lower.y + radius;
            boxRadiusSquared += temp * temp;
            temp = center.z - lower.z + radius;
            boxRadiusSquared += temp * temp;
            if (sqDist > boxRadiusSquared) {
                return false;
            }
            if (sqDist < radius * radius) {
                return true;
            }
            if (((BoundingBox)bounds).intersect(this.origin, this.direction, iPnt)) {
                return true;
            }
            Point3d upper = new Point3d();
            ((BoundingBox)bounds).getUpper(upper);
            Point3d[][] edges = new Point3d[][]{{upper, new Point3d(lower.x, upper.y, upper.z)}, {new Point3d(lower.x, upper.y, upper.z), new Point3d(lower.x, lower.y, upper.z)}, {new Point3d(lower.x, lower.y, upper.z), new Point3d(upper.x, lower.y, upper.z)}, {new Point3d(upper.x, lower.y, upper.z), upper}, {lower, new Point3d(lower.x, upper.y, lower.z)}, {new Point3d(lower.x, upper.y, lower.z), new Point3d(upper.x, upper.y, lower.z)}, {new Point3d(upper.x, upper.y, lower.z), new Point3d(upper.x, lower.y, lower.z)}, {new Point3d(upper.x, lower.y, lower.z), lower}, {lower, new Point3d(lower.x, lower.y, upper.z)}, {new Point3d(lower.x, upper.y, lower.z), new Point3d(lower.x, upper.y, upper.z)}, {new Point3d(upper.x, upper.y, lower.z), new Point3d(upper.x, upper.y, upper.z)}, {new Point3d(upper.x, lower.y, lower.z), new Point3d(upper.x, lower.y, upper.z)}};
            for (int i = 0; i < edges.length; ++i) {
                double distToEdge = Utils.rayToSegment(this.origin, this.direction, edges[i][0], edges[i][1], rayPt, null, null);
                vector.sub(rayPt, this.origin);
                distance = vector.length();
                radius = this.getRadius(distance);
                if (!(distToEdge <= radius * radius)) continue;
                return true;
            }
            return false;
        }
        if (bounds instanceof BoundingPolytope) {
            Point3d sphCenter = new Point3d();
            BoundingSphere bsphere = new BoundingSphere(bounds);
            bsphere.getCenter(sphCenter);
            double sphRadius = bsphere.getRadius();
            double sqDist = Utils.ptToRaySquare(sphCenter, this.origin, this.direction, rayPt);
            vector.sub(rayPt, this.origin);
            double distance = vector.length();
            double radius = this.getRadius(distance);
            if (sqDist > (sphRadius + radius) * (sphRadius + radius)) {
                return false;
            }
            if (bounds.intersect(this.origin, this.direction, iPnt)) {
                return true;
            }
            BoundingPolytope ptope = (BoundingPolytope)bounds;
            Point3d midpt = new Point3d();
            for (int i = 0; i < ptope.nVerts; ++i) {
                int j = i;
                while (i < ptope.nVerts) {
                    midpt.x = (ptope.verts[i].x + ptope.verts[j].x) * 0.5;
                    midpt.y = (ptope.verts[i].y + ptope.verts[j].y) * 0.5;
                    midpt.z = (ptope.verts[i].z + ptope.verts[j].z) * 0.5;
                    if (PickCylinder.pointInPolytope(ptope, midpt.x, midpt.y, midpt.z)) {
                        double distToEdge = Utils.rayToSegment(this.origin, this.direction, ptope.verts[i], ptope.verts[j], rayPt, null, null);
                        vector.sub(rayPt, this.origin);
                        distance = vector.length();
                        radius = this.getRadius(distance);
                        if (distToEdge <= radius * radius) {
                            return true;
                        }
                    }
                    ++i;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    PickShape transform(Transform3D t3d) {
        Point3d end = new Point3d();
        PickConeRay newPCR = new PickConeRay();
        newPCR.origin.x = this.origin.x;
        newPCR.origin.y = this.origin.y;
        newPCR.origin.z = this.origin.z;
        newPCR.spreadAngle = this.spreadAngle;
        end.x = this.origin.x + this.direction.x;
        end.y = this.origin.y + this.direction.y;
        end.z = this.origin.z + this.direction.z;
        t3d.transform(newPCR.origin);
        t3d.transform(end);
        newPCR.direction.x = end.x - newPCR.origin.x;
        newPCR.direction.y = end.y - newPCR.origin.y;
        newPCR.direction.z = end.z - newPCR.origin.z;
        newPCR.direction.normalize();
        return newPCR;
    }
}

