/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.util.Enumeration;
import org.scijava.java3d.Alpha;
import org.scijava.java3d.Interpolator;
import org.scijava.java3d.Material;
import org.scijava.java3d.Node;
import org.scijava.java3d.NodeReferenceTable;
import org.scijava.java3d.WakeupCriterion;
import org.scijava.java3d.WakeupOnElapsedFrames;
import org.scijava.vecmath.Color3f;

public class ColorInterpolator
extends Interpolator {
    Material target;
    Color3f startColor = new Color3f();
    Color3f endColor = new Color3f();
    Color3f newColor = new Color3f();
    private float prevAlphaValue = Float.NaN;
    private int prevColorTarget = -1;
    private WakeupCriterion passiveWakeupCriterion = new WakeupOnElapsedFrames(0, true);

    ColorInterpolator() {
    }

    public ColorInterpolator(Alpha alpha, Material target) {
        super(alpha);
        this.target = target;
        this.startColor.set(0.0f, 0.0f, 0.0f);
        this.endColor.set(1.0f, 1.0f, 1.0f);
    }

    public ColorInterpolator(Alpha alpha, Material target, Color3f startColor, Color3f endColor) {
        super(alpha);
        this.target = target;
        this.startColor.set(startColor);
        this.endColor.set(endColor);
    }

    public void setStartColor(Color3f color) {
        this.startColor.set(color);
        this.prevAlphaValue = Float.NaN;
    }

    public void getStartColor(Color3f color) {
        color.set(this.startColor);
    }

    public void setEndColor(Color3f color) {
        this.endColor.set(color);
        this.prevAlphaValue = Float.NaN;
    }

    public void getEndColor(Color3f color) {
        color.set(this.endColor);
    }

    public void setTarget(Material target) {
        this.target = target;
        this.prevAlphaValue = Float.NaN;
    }

    public Material getTarget() {
        return this.target;
    }

    @Override
    public void processStimulus(Enumeration criteria) {
        WakeupCriterion criterion = this.passiveWakeupCriterion;
        if (this.alpha != null) {
            float value = this.alpha.value();
            int colorTarget = 2;
            if (this.target.getCapability(0)) {
                colorTarget = this.target.getColorTarget();
            }
            if (value != this.prevAlphaValue || colorTarget != this.prevColorTarget) {
                this.newColor.x = (1.0f - value) * this.startColor.x + value * this.endColor.x;
                this.newColor.y = (1.0f - value) * this.startColor.y + value * this.endColor.y;
                this.newColor.z = (1.0f - value) * this.startColor.z + value * this.endColor.z;
                switch (colorTarget) {
                    case 0: {
                        this.target.setAmbientColor(this.newColor);
                        break;
                    }
                    case 4: {
                        this.target.setAmbientColor(this.newColor);
                    }
                    case 2: {
                        this.target.setDiffuseColor(this.newColor);
                        break;
                    }
                    case 1: {
                        this.target.setEmissiveColor(this.newColor);
                        break;
                    }
                    case 3: {
                        this.target.setSpecularColor(this.newColor);
                    }
                }
                this.prevAlphaValue = value;
                this.prevColorTarget = colorTarget;
            }
            if (!this.alpha.finished() && !this.alpha.isPaused()) {
                criterion = this.defaultWakeupCriterion;
            }
        }
        this.wakeupOn(criterion);
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        ColorInterpolator ci = new ColorInterpolator();
        ci.duplicateNode(this, forceDuplicate);
        return ci;
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        ColorInterpolator ci = (ColorInterpolator)originalNode;
        ci.getStartColor(this.startColor);
        ci.getEndColor(this.endColor);
        this.setTarget(ci.getTarget());
    }

    @Override
    public void updateNodeReferences(NodeReferenceTable referenceTable) {
        super.updateNodeReferences(referenceTable);
        Material nc = this.getTarget();
        if (nc != null) {
            this.setTarget((Material)referenceTable.getNewObjectReference(nc));
        }
    }
}

