/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.awt.Rectangle;
import org.scijava.java3d.BoundingBox;
import org.scijava.java3d.Canvas3D;
import org.scijava.java3d.RenderBin;
import org.scijava.java3d.ScreenViewCache;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.ViewCache;
import org.scijava.vecmath.Matrix4d;
import org.scijava.vecmath.Point2d;
import org.scijava.vecmath.Point3d;
import org.scijava.vecmath.Point4d;
import org.scijava.vecmath.SingularMatrixException;
import org.scijava.vecmath.Vector3d;
import org.scijava.vecmath.Vector4d;

class CanvasViewCache {
    private static Object debugLock = new Object();
    private Canvas3D canvas;
    int cvcDirtyMask = 0;
    private ScreenViewCache screenViewCache;
    private ViewCache viewCache;
    private int awtCanvasX;
    private int awtCanvasY;
    private int awtCanvasWidth;
    private int awtCanvasHeight;
    private RenderBin renderBin;
    private boolean useStereo;
    private int monoscopicViewPolicy;
    private Point3d leftManualEyeInImagePlate = new Point3d();
    private Point3d rightManualEyeInImagePlate = new Point3d();
    double physicalScreenWidth;
    double physicalScreenHeight;
    int screenWidth;
    int screenHeight;
    double metersPerPixelX;
    double metersPerPixelY;
    private int canvasX;
    private int canvasY;
    private int canvasWidth;
    private int canvasHeight;
    private int effectiveMonoscopicViewPolicy;
    private Transform3D leftProjection = new Transform3D();
    private Transform3D rightProjection = new Transform3D();
    private Transform3D infLeftProjection = new Transform3D();
    private Transform3D infRightProjection = new Transform3D();
    private Transform3D leftVpcToEc = new Transform3D();
    private Transform3D rightVpcToEc = new Transform3D();
    private Transform3D infLeftVpcToEc = new Transform3D();
    private Transform3D infRightVpcToEc = new Transform3D();
    private Transform3D leftEcToVpc = new Transform3D();
    private Transform3D rightEcToVpc = new Transform3D();
    private Transform3D infLeftEcToVpc = new Transform3D();
    private Transform3D infRightEcToVpc = new Transform3D();
    private Vector4d[] leftFrustumPlanes = new Vector4d[6];
    private Vector4d[] rightFrustumPlanes = new Vector4d[6];
    private Point4d[] leftFrustumPoints = new Point4d[8];
    private Point4d[] rightFrustumPoints = new Point4d[8];
    private Transform3D headTrackerToLeftImagePlate = new Transform3D();
    private Transform3D headTrackerToRightImagePlate = new Transform3D();
    private Point3d leftTrackedEyeInImagePlate = new Point3d();
    private Point3d rightTrackedEyeInImagePlate = new Point3d();
    private Point3d leftEyeInImagePlate = new Point3d();
    private Point3d rightEyeInImagePlate = new Point3d();
    private Point3d centerEyeInImagePlate = new Point3d();
    private double nominalEyeOffset;
    private double physicalWindowXLeft;
    private double physicalWindowYBottom;
    private double physicalWindowXRight;
    private double physicalWindowYTop;
    private double physicalWindowWidth;
    private double physicalWindowHeight;
    private Point3d physicalWindowCenter = new Point3d();
    private double screenScale;
    private double windowScale;
    private double viewPlatformScale;
    private Transform3D leftCcToVworld = new Transform3D();
    private Transform3D rightCcToVworld = new Transform3D();
    private Transform3D coexistenceToLeftPlate = new Transform3D();
    private Transform3D coexistenceToRightPlate = new Transform3D();
    private Transform3D vpcToCoexistence = new Transform3D();
    private Transform3D vpcToLeftPlate = new Transform3D();
    private Transform3D vpcToRightPlate = new Transform3D();
    private Transform3D leftPlateToVpc = new Transform3D();
    private Transform3D rightPlateToVpc = new Transform3D();
    private Transform3D vworldToLeftPlate = new Transform3D();
    private Transform3D lastVworldToLeftPlate = new Transform3D();
    private Transform3D vworldToRightPlate = new Transform3D();
    private Transform3D leftPlateToVworld = new Transform3D();
    private Transform3D rightPlateToVworld = new Transform3D();
    private Transform3D headToLeftImagePlate = new Transform3D();
    private Transform3D headToRightImagePlate = new Transform3D();
    private Transform3D vworldToTrackerBase = new Transform3D();
    private Transform3D tempTrans = new Transform3D();
    private Transform3D headToVworld = new Transform3D();
    private Vector3d coexistenceCenter = new Vector3d();
    private double vworldToCoexistenceScale;
    private double infVworldToCoexistenceScale;
    private Transform3D tMat1 = new Transform3D();
    private Transform3D tMat2 = new Transform3D();
    private Vector3d tVec1 = new Vector3d();
    private Vector3d tVec2 = new Vector3d();
    private Vector3d tVec3 = new Vector3d();
    private Point3d tPnt1 = new Point3d();
    private Point3d tPnt2 = new Point3d();
    private Matrix4d tMatrix = new Matrix4d();
    private Transform3D vworldToVpc = new Transform3D();
    private Transform3D vpcToVworld = new Transform3D();
    private Transform3D infVworldToVpc = new Transform3D();
    private boolean lastDoInfinite = false;
    private boolean updateLastTime = false;

    void getCanvasPositionAndSize() {
        this.awtCanvasX = this.canvas.newPosition.x;
        this.awtCanvasY = this.canvas.newPosition.y;
        this.awtCanvasWidth = this.canvas.newSize.width;
        this.awtCanvasHeight = this.canvas.newSize.height;
        if (this.awtCanvasWidth <= 0 || this.awtCanvasHeight <= 0) {
            this.awtCanvasWidth = 1;
            this.awtCanvasHeight = 1;
        }
    }

    void computefrustumBBox(BoundingBox frustumBBox) {
        int i;
        for (i = 0; i < this.leftFrustumPoints.length; ++i) {
            if (frustumBBox.lower.x > this.leftFrustumPoints[i].x) {
                frustumBBox.lower.x = this.leftFrustumPoints[i].x;
            }
            if (frustumBBox.lower.y > this.leftFrustumPoints[i].y) {
                frustumBBox.lower.y = this.leftFrustumPoints[i].y;
            }
            if (frustumBBox.lower.z > this.leftFrustumPoints[i].z) {
                frustumBBox.lower.z = this.leftFrustumPoints[i].z;
            }
            if (frustumBBox.upper.x < this.leftFrustumPoints[i].x) {
                frustumBBox.upper.x = this.leftFrustumPoints[i].x;
            }
            if (frustumBBox.upper.y < this.leftFrustumPoints[i].y) {
                frustumBBox.upper.y = this.leftFrustumPoints[i].y;
            }
            if (!(frustumBBox.upper.z < this.leftFrustumPoints[i].z)) continue;
            frustumBBox.upper.z = this.leftFrustumPoints[i].z;
        }
        if (this.useStereo) {
            for (i = 0; i < this.rightFrustumPoints.length; ++i) {
                if (frustumBBox.lower.x > this.rightFrustumPoints[i].x) {
                    frustumBBox.lower.x = this.rightFrustumPoints[i].x;
                }
                if (frustumBBox.lower.y > this.rightFrustumPoints[i].y) {
                    frustumBBox.lower.y = this.rightFrustumPoints[i].y;
                }
                if (frustumBBox.lower.z > this.rightFrustumPoints[i].z) {
                    frustumBBox.lower.z = this.rightFrustumPoints[i].z;
                }
                if (frustumBBox.upper.x < this.rightFrustumPoints[i].x) {
                    frustumBBox.upper.x = this.rightFrustumPoints[i].x;
                }
                if (frustumBBox.upper.y < this.rightFrustumPoints[i].y) {
                    frustumBBox.upper.y = this.rightFrustumPoints[i].y;
                }
                if (!(frustumBBox.upper.z < this.rightFrustumPoints[i].z)) continue;
                frustumBBox.upper.z = this.rightFrustumPoints[i].z;
            }
        }
    }

    void copyComputedCanvasViewCache(CanvasViewCache cvc, boolean doInfinite) {
        cvc.useStereo = this.useStereo;
        cvc.canvasWidth = this.canvasWidth;
        cvc.canvasHeight = this.canvasHeight;
        cvc.leftProjection.set(this.leftProjection);
        cvc.rightProjection.set(this.rightProjection);
        cvc.leftVpcToEc.set(this.leftVpcToEc);
        cvc.rightVpcToEc.set(this.rightVpcToEc);
        cvc.vpcToVworld = this.vpcToVworld;
        cvc.vworldToVpc.set(this.vworldToVpc);
        if (doInfinite) {
            cvc.infLeftProjection.set(this.infLeftProjection);
            cvc.infRightProjection.set(this.infRightProjection);
            cvc.infLeftVpcToEc.set(this.infLeftVpcToEc);
            cvc.infRightVpcToEc.set(this.infRightVpcToEc);
            cvc.infVworldToVpc.set(this.infVworldToVpc);
        }
        for (int i = 0; i < this.leftFrustumPlanes.length; ++i) {
            cvc.leftFrustumPlanes[i].x = this.leftFrustumPlanes[i].x;
            cvc.leftFrustumPlanes[i].y = this.leftFrustumPlanes[i].y;
            cvc.leftFrustumPlanes[i].z = this.leftFrustumPlanes[i].z;
            cvc.leftFrustumPlanes[i].w = this.leftFrustumPlanes[i].w;
            cvc.rightFrustumPlanes[i].x = this.rightFrustumPlanes[i].x;
            cvc.rightFrustumPlanes[i].y = this.rightFrustumPlanes[i].y;
            cvc.rightFrustumPlanes[i].z = this.rightFrustumPlanes[i].z;
            cvc.rightFrustumPlanes[i].w = this.rightFrustumPlanes[i].w;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void snapshot(boolean computeFrustum) {
        int dirtyIndex = computeFrustum ? 1 : 0;
        Object object = this.canvas.dirtyMaskLock;
        synchronized (object) {
            this.cvcDirtyMask = this.canvas.cvDirtyMask[dirtyIndex];
            this.canvas.cvDirtyMask[dirtyIndex] = 0;
        }
        this.useStereo = this.canvas.useStereo;
        this.monoscopicViewPolicy = this.canvas.monoscopicViewPolicy;
        this.leftManualEyeInImagePlate.set(this.canvas.leftManualEyeInImagePlate);
        this.rightManualEyeInImagePlate.set(this.canvas.rightManualEyeInImagePlate);
        if ((this.cvcDirtyMask & 8) != 0) {
            this.getCanvasPositionAndSize();
        }
        this.renderBin = this.canvas.view.renderBin;
    }

    synchronized void computeDerivedData(boolean currentFlag, CanvasViewCache cvc, BoundingBox frustumBBox, boolean doInfinite) {
        this.doComputeDerivedData(currentFlag, cvc, frustumBBox, doInfinite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doComputeDerivedData(boolean currentFlag, CanvasViewCache cvc, BoundingBox frustumBBox, boolean doInfinite) {
        boolean vprNotDirty;
        int scrvcDirtyMask;
        int dirtyIndex = frustumBBox != null ? 1 : 0;
        ScreenViewCache screenViewCache = this.screenViewCache;
        synchronized (screenViewCache) {
            scrvcDirtyMask = this.screenViewCache.scrvcDirtyMask[dirtyIndex];
            if (this.canvas.offScreen) {
                this.screenViewCache.scrvcDirtyMask[dirtyIndex] = 0;
            }
        }
        if (this.viewCache.vpRetained == null) {
            System.err.println("CanvasViewCache : Error! viewCache.vpRetained is null");
            return;
        }
        boolean bl = vprNotDirty = this.viewCache.vpRetained.vprDirtyMask == 0;
        if (!(this.canvas.manualRendering || !vprNotDirty || this.cvcDirtyMask != 0 || scrvcDirtyMask != 0 || this.viewCache.vcDirtyMask != 0 || this.updateLastTime && doInfinite != this.lastDoInfinite)) {
            if (frustumBBox != null) {
                this.computefrustumBBox(frustumBBox);
            }
            if (cvc != null) {
                this.copyComputedCanvasViewCache(cvc, doInfinite);
            }
            this.lastDoInfinite = doInfinite;
            this.updateLastTime = false;
            return;
        }
        this.lastDoInfinite = doInfinite;
        this.updateLastTime = true;
        if (currentFlag) {
            this.vpcToVworld.set(this.viewCache.vpRetained.getCurrentLocalToVworld(null));
        } else {
            this.vpcToVworld.set(this.viewCache.vpRetained.getLastLocalToVworld(null));
        }
        try {
            this.vworldToVpc.invert(this.vpcToVworld);
        }
        catch (SingularMatrixException e) {
            this.vworldToVpc.setIdentity();
        }
        if (doInfinite) {
            this.vworldToVpc.getRotation(this.infVworldToVpc);
        }
        this.effectiveMonoscopicViewPolicy = this.monoscopicViewPolicy == 2 ? this.viewCache.monoscopicViewPolicy : this.monoscopicViewPolicy;
        this.computeCanvasInfo();
        this.computeCoexistenceCenter();
        this.cacheEyePosition();
        this.computeVpcToCoexistence();
        this.computeCoexistenceToPlate();
        this.computeView(doInfinite);
        this.computePlateToVworld();
        if (!currentFlag) {
            this.lastVworldToLeftPlate.set(this.vworldToLeftPlate);
        }
        this.computeHeadToVworld();
        if (frustumBBox != null) {
            this.computefrustumBBox(frustumBBox);
        }
        assert (cvc == null);
        if (cvc != null) {
            this.copyComputedCanvasViewCache(cvc, doInfinite);
        }
        this.canvas.canvasDirty |= 0x8000;
    }

    private void computeCanvasInfo() {
        this.physicalScreenWidth = this.screenViewCache.physicalScreenWidth;
        this.physicalScreenHeight = this.screenViewCache.physicalScreenHeight;
        this.screenWidth = this.screenViewCache.screenWidth;
        this.screenHeight = this.screenViewCache.screenHeight;
        this.metersPerPixelX = this.screenViewCache.metersPerPixelX;
        this.metersPerPixelY = this.screenViewCache.metersPerPixelY;
        Rectangle screenBounds = this.canvas.graphicsConfiguration.getBounds();
        this.canvasX = this.awtCanvasX - screenBounds.x;
        this.canvasY = this.awtCanvasY - screenBounds.y;
        this.canvasWidth = this.awtCanvasWidth;
        this.canvasHeight = this.awtCanvasHeight;
        this.physicalWindowWidth = (double)this.canvasWidth * this.metersPerPixelX;
        this.physicalWindowHeight = (double)this.canvasHeight * this.metersPerPixelY;
        this.physicalWindowXLeft = this.metersPerPixelX * (double)this.canvasX;
        this.physicalWindowYBottom = this.metersPerPixelY * (double)(this.screenHeight - this.canvasHeight - this.canvasY);
        this.physicalWindowXRight = this.physicalWindowXLeft + this.physicalWindowWidth;
        this.physicalWindowYTop = this.physicalWindowYBottom + this.physicalWindowHeight;
        this.physicalWindowCenter.x = this.physicalWindowXLeft + this.physicalWindowWidth / 2.0;
        this.physicalWindowCenter.y = this.physicalWindowYBottom + this.physicalWindowHeight / 2.0;
        this.physicalWindowCenter.z = 0.0;
        this.computeViewPlatformScale();
        if (!this.viewCache.compatibilityModeEnable && this.viewCache.viewPolicy == 1) {
            if (!this.useStereo) {
                switch (this.effectiveMonoscopicViewPolicy) {
                    case 2: {
                        System.err.println("CanvasViewCache : Should never reach here.\nHMD_VIEW with CYCLOPEAN_EYE_VIEW is not allowed");
                        break;
                    }
                    case 0: {
                        this.headTrackerToLeftImagePlate.set(this.screenViewCache.headTrackerToLeftImagePlate);
                        break;
                    }
                    case 1: {
                        this.headTrackerToLeftImagePlate.set(this.screenViewCache.headTrackerToRightImagePlate);
                    }
                }
            } else {
                this.headTrackerToLeftImagePlate.set(this.screenViewCache.headTrackerToLeftImagePlate);
                this.headTrackerToRightImagePlate.set(this.screenViewCache.headTrackerToRightImagePlate);
            }
        }
    }

    private void computeViewPlatformScale() {
        this.screenScale = 1.0;
        this.windowScale = 1.0;
        if (!this.viewCache.compatibilityModeEnable) {
            switch (this.viewCache.screenScalePolicy) {
                case 0: {
                    this.screenScale = this.physicalScreenWidth / 2.0;
                    break;
                }
                case 1: {
                    this.screenScale = this.viewCache.screenScale;
                }
            }
            if (this.viewCache.windowResizePolicy == 1) {
                this.windowScale = this.physicalWindowWidth / this.physicalScreenWidth;
            }
        }
        this.viewPlatformScale = this.windowScale * this.screenScale;
    }

    private void cacheEyePosFixedField() {
        this.rightEyeInImagePlate.y = this.leftEyeInImagePlate.y = this.physicalWindowCenter.y;
        if (!this.useStereo) {
            switch (this.effectiveMonoscopicViewPolicy) {
                case 2: {
                    this.leftEyeInImagePlate.x = this.physicalWindowCenter.x;
                    break;
                }
                case 0: {
                    this.leftEyeInImagePlate.x = this.physicalWindowCenter.x + this.viewCache.leftEyePosInHead.x;
                    break;
                }
                case 1: {
                    this.leftEyeInImagePlate.x = this.physicalWindowCenter.x + this.viewCache.rightEyePosInHead.x;
                }
            }
            this.rightEyeInImagePlate.x = this.leftEyeInImagePlate.x;
        } else {
            this.leftEyeInImagePlate.x = this.physicalWindowCenter.x + this.viewCache.leftEyePosInHead.x;
            this.rightEyeInImagePlate.x = this.physicalWindowCenter.x + this.viewCache.rightEyePosInHead.x;
        }
        this.rightEyeInImagePlate.z = this.leftEyeInImagePlate.z = this.physicalWindowWidth / (2.0 * Math.tan(this.viewCache.fieldOfView / 2.0));
        if (this.viewCache.view.soundScheduler != null) {
            this.viewCache.view.soundScheduler.setListenerFlag(2);
        }
    }

    private void cacheEyePosWindowRelative() {
        this.rightEyeInImagePlate.y = this.leftEyeInImagePlate.y = this.physicalWindowCenter.y;
        this.rightEyeInImagePlate.z = this.leftEyeInImagePlate.z = this.leftManualEyeInImagePlate.z;
        if (!this.useStereo) {
            switch (this.effectiveMonoscopicViewPolicy) {
                case 2: {
                    this.leftEyeInImagePlate.x = this.physicalWindowCenter.x;
                    break;
                }
                case 0: {
                    this.leftEyeInImagePlate.x = this.physicalWindowCenter.x + this.viewCache.leftEyePosInHead.x;
                    break;
                }
                case 1: {
                    this.leftEyeInImagePlate.x = this.physicalWindowCenter.x + this.viewCache.rightEyePosInHead.x;
                }
            }
            this.rightEyeInImagePlate.x = this.leftEyeInImagePlate.x;
        } else {
            this.leftEyeInImagePlate.x = this.physicalWindowCenter.x + this.viewCache.leftEyePosInHead.x;
            this.rightEyeInImagePlate.x = this.physicalWindowCenter.x + this.viewCache.rightEyePosInHead.x;
            this.rightEyeInImagePlate.z = this.rightManualEyeInImagePlate.z;
        }
        if (this.viewCache.view.soundScheduler != null) {
            this.viewCache.view.soundScheduler.setListenerFlag(2);
        }
    }

    private void cacheEyePosScreenRelative(Point3d leftEye, Point3d rightEye) {
        if (!this.useStereo) {
            switch (this.effectiveMonoscopicViewPolicy) {
                case 2: {
                    this.leftEyeInImagePlate.x = (leftEye.x + rightEye.x) / 2.0;
                    this.leftEyeInImagePlate.y = (leftEye.y + rightEye.y) / 2.0;
                    this.leftEyeInImagePlate.z = (leftEye.z + rightEye.z) / 2.0;
                    break;
                }
                case 0: {
                    this.leftEyeInImagePlate.set(leftEye);
                    break;
                }
                case 1: {
                    this.leftEyeInImagePlate.set(rightEye);
                }
            }
            this.rightEyeInImagePlate.set(this.leftEyeInImagePlate);
        } else {
            this.leftEyeInImagePlate.set(leftEye);
            this.rightEyeInImagePlate.set(rightEye);
        }
        if (this.viewCache.view.soundScheduler != null) {
            this.viewCache.view.soundScheduler.setListenerFlag(2);
        }
    }

    private void cacheEyePosCoexistenceRelative(Point3d leftManualEyeInCoexistence, Point3d rightManualEyeInCoexistence) {
        this.tPnt1.set(leftManualEyeInCoexistence);
        this.viewCache.coexistenceToTrackerBase.transform(this.tPnt1);
        this.screenViewCache.trackerBaseToImagePlate.transform(this.tPnt1);
        this.tPnt1.add(this.coexistenceCenter);
        this.tPnt2.set(rightManualEyeInCoexistence);
        this.viewCache.coexistenceToTrackerBase.transform(this.tPnt2);
        this.screenViewCache.trackerBaseToImagePlate.transform(this.tPnt2);
        this.tPnt2.add(this.coexistenceCenter);
        this.cacheEyePosScreenRelative(this.tPnt1, this.tPnt2);
    }

    private void computeTrackedEyePosition() {
        if (this.viewCache.viewPolicy != 1) {
            this.headToLeftImagePlate.set(this.coexistenceCenter);
            this.headToLeftImagePlate.mul(this.screenViewCache.trackerBaseToImagePlate);
            this.headToLeftImagePlate.mul(this.viewCache.headTrackerToTrackerBase);
            this.headToLeftImagePlate.mul(this.viewCache.headToHeadTracker);
            this.headToLeftImagePlate.transform(this.viewCache.leftEyePosInHead, this.leftTrackedEyeInImagePlate);
            this.headToLeftImagePlate.transform(this.viewCache.rightEyePosInHead, this.rightTrackedEyeInImagePlate);
        } else {
            this.headToLeftImagePlate.mul(this.headTrackerToLeftImagePlate, this.viewCache.headToHeadTracker);
            this.headToLeftImagePlate.transform(this.viewCache.leftEyePosInHead, this.leftTrackedEyeInImagePlate);
            if (this.useStereo) {
                this.headToRightImagePlate.mul(this.headTrackerToRightImagePlate, this.viewCache.headToHeadTracker);
                this.headToRightImagePlate.transform(this.viewCache.rightEyePosInHead, this.rightTrackedEyeInImagePlate);
            } else {
                this.headToLeftImagePlate.transform(this.viewCache.rightEyePosInHead, this.rightTrackedEyeInImagePlate);
            }
        }
    }

    private void cacheEyePosition() {
        if (this.viewCache.compatibilityModeEnable) {
            this.cacheEyePosScreenRelative(this.leftManualEyeInImagePlate, this.rightManualEyeInImagePlate);
        } else if (this.viewCache.getDoHeadTracking()) {
            this.computeTrackedEyePosition();
            this.cacheEyePosScreenRelative(this.leftTrackedEyeInImagePlate, this.rightTrackedEyeInImagePlate);
        } else {
            switch (this.viewCache.windowEyepointPolicy) {
                case 2: {
                    this.cacheEyePosFixedField();
                    break;
                }
                case 1: {
                    this.cacheEyePosWindowRelative();
                    break;
                }
                case 0: {
                    this.cacheEyePosScreenRelative(this.leftManualEyeInImagePlate, this.rightManualEyeInImagePlate);
                    break;
                }
                case 3: {
                    this.cacheEyePosCoexistenceRelative(this.viewCache.leftManualEyeInCoexistence, this.viewCache.rightManualEyeInCoexistence);
                }
            }
        }
        this.centerEyeInImagePlate.add(this.leftEyeInImagePlate, this.rightEyeInImagePlate);
        this.centerEyeInImagePlate.scale(0.5);
        this.nominalEyeOffset = this.viewCache.windowEyepointPolicy == 2 ? this.centerEyeInImagePlate.z : this.viewCache.nominalEyeOffsetFromNominalScreen;
    }

    private void computePlateToVworld() {
        if (this.viewCache.compatibilityModeEnable) {
            this.leftPlateToVworld.setIdentity();
            this.vworldToLeftPlate.setIdentity();
        } else {
            try {
                this.leftPlateToVpc.invert(this.vpcToLeftPlate);
            }
            catch (SingularMatrixException e) {
                this.leftPlateToVpc.setIdentity();
            }
            this.leftPlateToVworld.mul(this.vpcToVworld, this.leftPlateToVpc);
            this.vworldToLeftPlate.mul(this.vpcToLeftPlate, this.vworldToVpc);
            if (this.useStereo) {
                try {
                    this.rightPlateToVpc.invert(this.vpcToRightPlate);
                }
                catch (SingularMatrixException e) {
                    this.rightPlateToVpc.setIdentity();
                }
                this.rightPlateToVworld.mul(this.vpcToVworld, this.rightPlateToVpc);
                this.vworldToRightPlate.mul(this.vpcToRightPlate, this.vworldToVpc);
            }
        }
        if (this.viewCache.view.soundScheduler != null) {
            this.viewCache.view.soundScheduler.setListenerFlag(4);
        }
    }

    private void computeHeadToVworld() {
        if (this.viewCache.compatibilityModeEnable) {
            this.headToVworld.setIdentity();
        } else {
            this.headToVworld.mul(this.leftPlateToVworld, this.headToLeftImagePlate);
        }
        if (this.viewCache.view.soundScheduler != null) {
            this.viewCache.view.soundScheduler.setListenerFlag(8);
        }
    }

    private void computeVpcToCoexistence() {
        this.tMat1.set(this.viewPlatformScale);
        if (this.viewCache.viewPolicy != 1) {
            block0 : switch (this.viewCache.coexistenceCenterInPworldPolicy) {
                case 2: {
                    switch (this.viewCache.viewAttachPolicy) {
                        case 2: {
                            this.tMat2.setIdentity();
                            break;
                        }
                        case 0: {
                            this.tVec1.set(0.0, 0.0, this.nominalEyeOffset);
                            this.tMat2.set(this.tVec1);
                            break;
                        }
                        case 1: {
                            this.tVec1.set(0.0, -this.viewCache.nominalEyeHeightFromGround, this.nominalEyeOffset);
                            this.tMat2.set(this.tVec1);
                        }
                    }
                    break;
                }
                case 0: {
                    switch (this.viewCache.viewAttachPolicy) {
                        case 2: {
                            this.tVec1.set(0.0, 0.0, -this.nominalEyeOffset);
                            this.tMat2.set(this.tVec1);
                            break;
                        }
                        case 0: {
                            this.tMat2.setIdentity();
                            break;
                        }
                        case 1: {
                            this.tVec1.set(0.0, -this.viewCache.nominalEyeHeightFromGround, 0.0);
                            this.tMat2.set(this.tVec1);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.viewCache.viewAttachPolicy) {
                        case 2: {
                            this.tVec1.set(0.0, this.viewCache.nominalEyeHeightFromGround, -this.nominalEyeOffset);
                            this.tMat2.set(this.tVec1);
                            break block0;
                        }
                        case 0: {
                            this.tVec1.set(0.0, this.viewCache.nominalEyeHeightFromGround, 0.0);
                            this.tMat2.set(this.tVec1);
                            break block0;
                        }
                        case 1: {
                            this.tMat2.setIdentity();
                        }
                    }
                }
            }
            this.vpcToCoexistence.mul(this.tMat2, this.tMat1);
        } else {
            this.vpcToCoexistence.set(this.tMat1);
        }
    }

    private void computeCoexistenceCenter() {
        if (!this.viewCache.compatibilityModeEnable && this.viewCache.viewPolicy != 1 && this.viewCache.coexistenceCenteringEnable && this.viewCache.coexistenceCenterInPworldPolicy == 2) {
            if (this.viewCache.windowMovementPolicy == 0) {
                this.coexistenceCenter.x = this.physicalScreenWidth / 2.0;
                this.coexistenceCenter.y = this.physicalScreenHeight / 2.0;
                this.coexistenceCenter.z = 0.0;
            } else {
                this.coexistenceCenter.x = this.physicalWindowCenter.x;
                this.coexistenceCenter.y = this.physicalWindowCenter.y;
                this.coexistenceCenter.z = 0.0;
            }
        } else {
            this.coexistenceCenter.set(0.0, 0.0, 0.0);
        }
    }

    private void computeCoexistenceToPlate() {
        if (this.viewCache.compatibilityModeEnable) {
            this.coexistenceToLeftPlate.setIdentity();
            return;
        }
        if (this.viewCache.viewPolicy != 1) {
            this.coexistenceToLeftPlate.set(this.coexistenceCenter);
            this.coexistenceToLeftPlate.mul(this.screenViewCache.trackerBaseToImagePlate);
            this.coexistenceToLeftPlate.mul(this.viewCache.coexistenceToTrackerBase);
            if (this.useStereo) {
                this.coexistenceToRightPlate.set(this.coexistenceToLeftPlate);
            }
        } else {
            this.coexistenceToLeftPlate.mul(this.headTrackerToLeftImagePlate, this.viewCache.trackerBaseToHeadTracker);
            this.coexistenceToLeftPlate.mul(this.viewCache.coexistenceToTrackerBase);
            if (this.useStereo) {
                this.coexistenceToRightPlate.mul(this.headTrackerToRightImagePlate, this.viewCache.trackerBaseToHeadTracker);
                this.coexistenceToRightPlate.mul(this.viewCache.coexistenceToTrackerBase);
            }
        }
    }

    private void computeView(boolean doInfinite) {
        double backClipDistance;
        int backClipPolicy;
        double Fr;
        double Fl;
        this.vworldToCoexistenceScale = this.vworldToVpc.getDistanceScale() * this.vpcToCoexistence.getDistanceScale();
        if (doInfinite) {
            this.infVworldToCoexistenceScale = this.infVworldToVpc.getDistanceScale() * this.vpcToCoexistence.getDistanceScale();
        }
        this.tempTrans.mul(this.viewCache.coexistenceToTrackerBase, this.vpcToCoexistence);
        this.vworldToTrackerBase.mul(this.tempTrans, this.vworldToVpc);
        if (this.viewCache.compatibilityModeEnable) {
            this.leftProjection.set(this.viewCache.compatLeftProjection);
            this.leftVpcToEc.set(this.viewCache.compatVpcToEc);
            this.computeFrustumPlanes(this.leftProjection, this.leftVpcToEc, this.leftFrustumPlanes, this.leftFrustumPoints, this.leftCcToVworld);
            if (this.useStereo) {
                this.rightProjection.set(this.viewCache.compatRightProjection);
                this.rightVpcToEc.set(this.viewCache.compatVpcToEc);
                this.computeFrustumPlanes(this.rightProjection, this.rightVpcToEc, this.rightFrustumPlanes, this.rightFrustumPoints, this.rightCcToVworld);
            }
            return;
        }
        double scale = this.viewCache.frontClipPolicy == 2 || this.viewCache.frontClipPolicy == 0 ? this.vworldToCoexistenceScale : this.windowScale;
        if (this.viewCache.frontClipPolicy == 3 || this.viewCache.frontClipPolicy == 2) {
            Fl = this.leftEyeInImagePlate.z + scale * -this.viewCache.frontClipDistance;
            Fr = this.rightEyeInImagePlate.z + scale * -this.viewCache.frontClipDistance;
        } else {
            Fl = scale * -this.viewCache.frontClipDistance;
            Fr = scale * -this.viewCache.frontClipDistance;
        }
        if (this.renderBin != null && this.renderBin.backClipActive) {
            backClipPolicy = 2;
            backClipDistance = this.renderBin.backClipDistanceInVworld;
        } else {
            backClipPolicy = this.viewCache.backClipPolicy;
            backClipDistance = this.viewCache.backClipDistance;
        }
        scale = backClipPolicy == 2 || backClipPolicy == 0 ? this.vworldToCoexistenceScale : this.windowScale;
        double B = backClipPolicy == 3 || backClipPolicy == 2 ? this.leftEyeInImagePlate.z + scale * -backClipDistance : scale * -backClipDistance;
        this.buildProjView(this.leftEyeInImagePlate, this.coexistenceToLeftPlate, this.vpcToLeftPlate, Fl, B, this.leftProjection, this.leftVpcToEc, false);
        this.computeFrustumPlanes(this.leftProjection, this.leftVpcToEc, this.leftFrustumPlanes, this.leftFrustumPoints, this.leftCcToVworld);
        if (this.useStereo) {
            this.buildProjView(this.rightEyeInImagePlate, this.coexistenceToRightPlate, this.vpcToRightPlate, Fr, B, this.rightProjection, this.rightVpcToEc, false);
            this.computeFrustumPlanes(this.rightProjection, this.rightVpcToEc, this.rightFrustumPlanes, this.rightFrustumPoints, this.rightCcToVworld);
        }
        if (doInfinite) {
            this.buildProjView(this.leftEyeInImagePlate, this.coexistenceToLeftPlate, this.vpcToLeftPlate, this.leftEyeInImagePlate.z - 0.05, this.leftEyeInImagePlate.z - 1.5, this.infLeftProjection, this.infLeftVpcToEc, true);
            if (this.useStereo) {
                this.buildProjView(this.rightEyeInImagePlate, this.coexistenceToRightPlate, this.vpcToRightPlate, this.rightEyeInImagePlate.z - 0.05, this.rightEyeInImagePlate.z - 1.5, this.infRightProjection, this.infRightVpcToEc, true);
            }
        }
    }

    private void analyzeProjection(Transform3D p, double xMax) {
        if (this.viewCache.projectionPolicy == 0) {
            System.err.println("PARALLEL_PROJECTION =");
        } else {
            System.err.println("PERSPECTIVE_PROJECTION =");
        }
        System.err.println(p);
        double projectionPlaneZ = (p.mat[0] * xMax + p.mat[3] - p.mat[15]) / (p.mat[14] - p.mat[2]);
        System.err.println("projection plane at z = " + projectionPlaneZ);
    }

    private void buildProjView(Point3d ep, Transform3D coe2Plate, Transform3D vpc2Plate, double F, double B, Transform3D ecToCc, Transform3D vpcToEc, boolean doInfinite) {
        double Lx = this.physicalWindowXLeft;
        double Hx = this.physicalWindowXRight;
        double Ly = this.physicalWindowYBottom;
        double Hy = this.physicalWindowYTop;
        ecToCc.setIdentity();
        if (this.viewCache.projectionPolicy == 0) {
            double inv_dx = 1.0 / (Hx - Lx);
            double inv_dy = 1.0 / (Hy - Ly);
            double inv_dz = 1.0 / (F - B);
            ecToCc.mat[0] = 2.0 * inv_dx;
            ecToCc.mat[3] = -(Hx + Lx) * inv_dx;
            ecToCc.mat[5] = 2.0 * inv_dy;
            ecToCc.mat[7] = -(Hy + Ly) * inv_dy;
            ecToCc.mat[10] = 2.0 * inv_dz;
            ecToCc.mat[11] = -(F + B) * inv_dz;
        } else {
            double inv_dx = 1.0 / (Hx - Lx);
            double inv_dy = 1.0 / (Hy - Ly);
            double rzb = 1.0 / (ep.z - B);
            double sxy = ep.z * rzb;
            ecToCc.mat[0] = sxy * 2.0 * inv_dx;
            ecToCc.mat[5] = sxy * 2.0 * inv_dy;
            ecToCc.mat[2] = rzb * (Hx + Lx - 2.0 * ep.x) * inv_dx;
            ecToCc.mat[6] = rzb * (Hy + Ly - 2.0 * ep.y) * inv_dy;
            ecToCc.mat[10] = rzb * (B + F - 2.0 * ep.z) / (B - F);
            ecToCc.mat[14] = -rzb;
            ecToCc.mat[3] = sxy * (-Hx - Lx) * inv_dx;
            ecToCc.mat[7] = sxy * (-Hy - Ly) * inv_dy;
            ecToCc.mat[11] = rzb * (B - ep.z - B * (B + F - 2.0 * ep.z) / (B - F));
            ecToCc.mat[15] = sxy;
        }
        ecToCc.setOrthoDirtyBit();
        this.tVec1.set(ep.x, ep.y, ep.z);
        this.tMat1.set(this.tVec1);
        ecToCc.mul(this.tMat1);
        if (!doInfinite) {
            vpc2Plate.mul(coe2Plate, this.vpcToCoexistence);
            this.tVec1.set(-ep.x, -ep.y, -ep.z);
            this.tMat1.set(this.tVec1);
            vpcToEc.mul(this.tMat1, vpc2Plate);
        } else {
            this.tVec1.set(-ep.x, -ep.y, -ep.z);
            this.tMat1.set(this.tVec1);
            this.tMat1.mul(this.tMat1, vpc2Plate);
            this.tMat1.getRotation(vpcToEc);
        }
    }

    private void computeFrustumPlanes(Transform3D ecToCc, Transform3D vpcToEc, Vector4d[] frustumPlanes, Point4d[] frustumPoints, Transform3D ccToVworld) {
        this.tMat2.mul(ecToCc, vpcToEc);
        ccToVworld.mul(this.tMat2, this.vworldToVpc);
        try {
            ccToVworld.invert();
        }
        catch (SingularMatrixException e) {
            ccToVworld.setIdentity();
        }
        frustumPoints[0].set(-1.0, -1.0, 1.0, 1.0);
        frustumPoints[1].set(-1.0, 1.0, 1.0, 1.0);
        frustumPoints[2].set(1.0, 1.0, 1.0, 1.0);
        frustumPoints[3].set(1.0, -1.0, 1.0, 1.0);
        frustumPoints[4].set(-1.0, -1.0, -1.0, 1.0);
        frustumPoints[5].set(-1.0, 1.0, -1.0, 1.0);
        frustumPoints[6].set(1.0, 1.0, -1.0, 1.0);
        frustumPoints[7].set(1.0, -1.0, -1.0, 1.0);
        ccToVworld.get(this.tMatrix);
        for (int i = 0; i < frustumPoints.length; ++i) {
            this.tMatrix.transform(frustumPoints[i]);
            double w_inv = 1.0 / frustumPoints[i].w;
            frustumPoints[i].x *= w_inv;
            frustumPoints[i].y *= w_inv;
            frustumPoints[i].z *= w_inv;
        }
        this.computePlaneEq(frustumPoints[0], frustumPoints[4], frustumPoints[5], frustumPoints[1], frustumPlanes[0]);
        this.computePlaneEq(frustumPoints[3], frustumPoints[2], frustumPoints[6], frustumPoints[7], frustumPlanes[1]);
        this.computePlaneEq(frustumPoints[1], frustumPoints[5], frustumPoints[6], frustumPoints[2], frustumPlanes[2]);
        this.computePlaneEq(frustumPoints[0], frustumPoints[3], frustumPoints[7], frustumPoints[4], frustumPlanes[3]);
        this.computePlaneEq(frustumPoints[0], frustumPoints[1], frustumPoints[2], frustumPoints[3], frustumPlanes[4]);
        this.computePlaneEq(frustumPoints[4], frustumPoints[7], frustumPoints[6], frustumPoints[5], frustumPlanes[5]);
    }

    private void computePlaneEq(Point4d p1, Point4d p2, Point4d p3, Point4d p4, Vector4d planeEq) {
        this.tVec1.x = p3.x - p1.x;
        this.tVec1.y = p3.y - p1.y;
        this.tVec1.z = p3.z - p1.z;
        this.tVec2.x = p2.x - p1.x;
        this.tVec2.y = p2.y - p1.y;
        this.tVec2.z = p2.z - p1.z;
        this.tVec3.cross(this.tVec2, this.tVec1);
        this.tVec3.normalize();
        planeEq.x = this.tVec3.x;
        planeEq.y = this.tVec3.y;
        planeEq.z = this.tVec3.z;
        planeEq.w = -(planeEq.x * p1.x + planeEq.y * p1.y + planeEq.z * p1.z);
    }

    int getCanvasX() {
        return this.canvasX;
    }

    int getCanvasY() {
        return this.canvasY;
    }

    int getCanvasWidth() {
        return this.canvasWidth;
    }

    int getCanvasHeight() {
        return this.canvasHeight;
    }

    double getPhysicalWindowWidth() {
        return this.physicalWindowWidth;
    }

    double getPhysicalWindowHeight() {
        return this.physicalWindowHeight;
    }

    boolean getUseStereo() {
        return this.useStereo;
    }

    Transform3D getLeftProjection() {
        return this.leftProjection;
    }

    Transform3D getRightProjection() {
        return this.rightProjection;
    }

    Transform3D getLeftVpcToEc() {
        return this.leftVpcToEc;
    }

    Transform3D getRightVpcToEc() {
        return this.rightVpcToEc;
    }

    Transform3D getLeftEcToVpc() {
        return this.leftEcToVpc;
    }

    Transform3D getRightEcToVpc() {
        return this.rightEcToVpc;
    }

    Transform3D getInfLeftProjection() {
        return this.infLeftProjection;
    }

    Transform3D getInfRightProjection() {
        return this.infLeftProjection;
    }

    Transform3D getInfLeftVpcToEc() {
        return this.infLeftVpcToEc;
    }

    Transform3D getInfRightVpcToEc() {
        return this.infRightVpcToEc;
    }

    Transform3D getInfLeftEcToVpc() {
        return this.infLeftEcToVpc;
    }

    Transform3D getInfgRightEcToVpc() {
        return this.infRightEcToVpc;
    }

    Transform3D getInfVworldToVpc() {
        return this.infVworldToVpc;
    }

    Transform3D getLeftCcToVworld() {
        return this.leftCcToVworld;
    }

    Transform3D getRightCcToVworld() {
        return this.rightCcToVworld;
    }

    Transform3D getImagePlateToVworld() {
        return this.leftPlateToVworld;
    }

    Transform3D getLastVworldToImagePlate() {
        return this.lastVworldToLeftPlate;
    }

    Transform3D getVworldToImagePlate() {
        return this.vworldToLeftPlate;
    }

    Transform3D getVworldToTrackerBase() {
        return this.vworldToTrackerBase;
    }

    double getVworldToCoexistenceScale() {
        return this.vworldToCoexistenceScale;
    }

    double getInfVworldToCoexistenceScale() {
        return this.infVworldToCoexistenceScale;
    }

    Point3d getLeftEyeInImagePlate() {
        return this.leftEyeInImagePlate;
    }

    Point3d getRightEyeInImagePlate() {
        return this.rightEyeInImagePlate;
    }

    Point3d getCenterEyeInImagePlate() {
        return this.centerEyeInImagePlate;
    }

    Transform3D getHeadToVworld() {
        return this.headToVworld;
    }

    Transform3D getVpcToVworld() {
        return this.vpcToVworld;
    }

    Transform3D getVworldToVpc() {
        return this.vworldToVpc;
    }

    double getWindowXInImagePlate(double x) {
        double xScreen = x + (double)this.canvasX;
        return this.metersPerPixelX * xScreen;
    }

    double getWindowYInImagePlate(double y) {
        double yScreen = y + (double)this.canvasY;
        return this.metersPerPixelY * ((double)(this.screenHeight - 1) - yScreen);
    }

    Vector4d[] getLeftFrustumPlanesInVworld() {
        return this.leftFrustumPlanes;
    }

    Vector4d[] getRightFrustumPlanesInVworld() {
        return this.rightFrustumPlanes;
    }

    void getPixelLocationInImagePlate(double x, double y, double z, Point3d imagePlatePoint) {
        double screenx = (x + (double)this.canvasX) * this.metersPerPixelX;
        double screeny = ((double)(this.screenHeight - 1 - this.canvasY) - y) * this.metersPerPixelY;
        if (this.viewCache.projectionPolicy == 1 && this.centerEyeInImagePlate.z != 0.0) {
            double zScale = 1.0 - z / this.centerEyeInImagePlate.z;
            imagePlatePoint.x = (screenx - this.centerEyeInImagePlate.x) * zScale + this.centerEyeInImagePlate.x;
            imagePlatePoint.y = (screeny - this.centerEyeInImagePlate.y) * zScale + this.centerEyeInImagePlate.y;
        } else {
            imagePlatePoint.x = screenx;
            imagePlatePoint.y = screeny;
        }
        imagePlatePoint.z = z;
    }

    void getPixelLocationFromImagePlate(Point3d imagePlatePoint, Point2d pixelLocation) {
        double screenY;
        double screenX;
        if (this.viewCache.projectionPolicy == 1) {
            this.tVec1.sub(imagePlatePoint, this.centerEyeInImagePlate);
            if (this.tVec1.z != 0.0) {
                double zScale = this.centerEyeInImagePlate.z / -this.tVec1.z;
                screenX = this.centerEyeInImagePlate.x + this.tVec1.x * zScale;
                screenY = this.centerEyeInImagePlate.y + this.tVec1.y * zScale;
            } else {
                screenX = imagePlatePoint.x;
                screenY = imagePlatePoint.y;
            }
        } else {
            screenX = imagePlatePoint.x;
            screenY = imagePlatePoint.y;
        }
        pixelLocation.x = screenX / this.screenViewCache.metersPerPixelX - (double)this.canvasX;
        pixelLocation.y = (double)(this.screenViewCache.screenHeight - 1) - screenY / this.screenViewCache.metersPerPixelY - (double)this.canvasY;
    }

    CanvasViewCache(Canvas3D canvas, ScreenViewCache screenViewCache, ViewCache viewCache) {
        int i;
        this.canvas = canvas;
        this.screenViewCache = screenViewCache;
        this.viewCache = viewCache;
        for (i = 0; i < this.leftFrustumPlanes.length; ++i) {
            this.leftFrustumPlanes[i] = new Vector4d();
            this.rightFrustumPlanes[i] = new Vector4d();
        }
        for (i = 0; i < this.leftFrustumPoints.length; ++i) {
            this.leftFrustumPoints[i] = new Point4d();
            this.rightFrustumPoints[i] = new Point4d();
        }
        if (canvas != null) {
            this.leftEyeInImagePlate.set(canvas.leftManualEyeInImagePlate);
            this.rightEyeInImagePlate.set(canvas.rightManualEyeInImagePlate);
            this.centerEyeInImagePlate.add(this.leftEyeInImagePlate, this.rightEyeInImagePlate);
            this.centerEyeInImagePlate.scale(0.5);
        }
    }

    synchronized void setCanvas(Canvas3D c) {
        this.canvas = c;
    }

    synchronized void setScreenViewCache(ScreenViewCache svc) {
        this.screenViewCache = svc;
    }

    synchronized void setViewCache(ViewCache vc) {
        this.viewCache = vc;
    }
}

