/*
 * Decompiled with CFR 0.152.
 */
package org.openjsse.sun.security.provider;

import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.AccessController;
import sun.misc.Unsafe;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

final class ByteArrayAccess {
    private static final Unsafe unsafe;
    private static final boolean littleEndianUnaligned;
    private static final boolean bigEndian;
    private static final int byteArrayOfs;

    private ByteArrayAccess() {
    }

    private static boolean unaligned() {
        String arch = AccessController.doPrivileged(new GetPropertyAction("os.arch", ""));
        return arch.equals("i386") || arch.equals("x86") || arch.equals("amd64") || arch.equals("x86_64") || arch.equals("ppc64") || arch.equals("ppc64le");
    }

    static void b2iLittle(byte[] in, int inOfs, int[] out, int outOfs, int len) {
        if (inOfs < 0 || in.length - inOfs < len || outOfs < 0 || out.length - outOfs < len / 4) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (littleEndianUnaligned) {
            len += (inOfs += byteArrayOfs);
            while (inOfs < len) {
                out[outOfs++] = unsafe.getInt(in, inOfs);
                inOfs += 4;
            }
        } else if (bigEndian && (inOfs & 3) == 0) {
            len += (inOfs += byteArrayOfs);
            while (inOfs < len) {
                out[outOfs++] = Integer.reverseBytes(unsafe.getInt(in, inOfs));
                inOfs += 4;
            }
        } else {
            len += inOfs;
            while (inOfs < len) {
                out[outOfs++] = in[inOfs] & 0xFF | (in[inOfs + 1] & 0xFF) << 8 | (in[inOfs + 2] & 0xFF) << 16 | in[inOfs + 3] << 24;
                inOfs += 4;
            }
        }
    }

    static void b2iLittle64(byte[] in, int inOfs, int[] out) {
        if (inOfs < 0 || in.length - inOfs < 64 || out.length < 16) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (littleEndianUnaligned) {
            out[0] = unsafe.getInt(in, inOfs += byteArrayOfs);
            out[1] = unsafe.getInt(in, inOfs + 4);
            out[2] = unsafe.getInt(in, inOfs + 8);
            out[3] = unsafe.getInt(in, inOfs + 12);
            out[4] = unsafe.getInt(in, inOfs + 16);
            out[5] = unsafe.getInt(in, inOfs + 20);
            out[6] = unsafe.getInt(in, inOfs + 24);
            out[7] = unsafe.getInt(in, inOfs + 28);
            out[8] = unsafe.getInt(in, inOfs + 32);
            out[9] = unsafe.getInt(in, inOfs + 36);
            out[10] = unsafe.getInt(in, inOfs + 40);
            out[11] = unsafe.getInt(in, inOfs + 44);
            out[12] = unsafe.getInt(in, inOfs + 48);
            out[13] = unsafe.getInt(in, inOfs + 52);
            out[14] = unsafe.getInt(in, inOfs + 56);
            out[15] = unsafe.getInt(in, inOfs + 60);
        } else if (bigEndian && (inOfs & 3) == 0) {
            out[0] = Integer.reverseBytes(unsafe.getInt(in, inOfs += byteArrayOfs));
            out[1] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 4));
            out[2] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 8));
            out[3] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 12));
            out[4] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 16));
            out[5] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 20));
            out[6] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 24));
            out[7] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 28));
            out[8] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 32));
            out[9] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 36));
            out[10] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 40));
            out[11] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 44));
            out[12] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 48));
            out[13] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 52));
            out[14] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 56));
            out[15] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 60));
        } else {
            ByteArrayAccess.b2iLittle(in, inOfs, out, 0, 64);
        }
    }

    static void i2bLittle(int[] in, int inOfs, byte[] out, int outOfs, int len) {
        if (inOfs < 0 || in.length - inOfs < len / 4 || outOfs < 0 || out.length - outOfs < len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (littleEndianUnaligned) {
            len += (outOfs += byteArrayOfs);
            while (outOfs < len) {
                unsafe.putInt(out, outOfs, in[inOfs++]);
                outOfs += 4;
            }
        } else if (bigEndian && (outOfs & 3) == 0) {
            len += (outOfs += byteArrayOfs);
            while (outOfs < len) {
                unsafe.putInt(out, outOfs, Integer.reverseBytes(in[inOfs++]));
                outOfs += 4;
            }
        } else {
            len += outOfs;
            while (outOfs < len) {
                int i = in[inOfs++];
                out[outOfs++] = (byte)i;
                out[outOfs++] = (byte)(i >> 8);
                out[outOfs++] = (byte)(i >> 16);
                out[outOfs++] = (byte)(i >> 24);
            }
        }
    }

    static void i2bLittle4(int val, byte[] out, int outOfs) {
        if (outOfs < 0 || out.length - outOfs < 4) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (littleEndianUnaligned) {
            unsafe.putInt(out, byteArrayOfs + outOfs, val);
        } else if (bigEndian && (outOfs & 3) == 0) {
            unsafe.putInt(out, byteArrayOfs + outOfs, Integer.reverseBytes(val));
        } else {
            out[outOfs] = (byte)val;
            out[outOfs + 1] = (byte)(val >> 8);
            out[outOfs + 2] = (byte)(val >> 16);
            out[outOfs + 3] = (byte)(val >> 24);
        }
    }

    static void b2iBig(byte[] in, int inOfs, int[] out, int outOfs, int len) {
        if (inOfs < 0 || in.length - inOfs < len || outOfs < 0 || out.length - outOfs < len / 4) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (littleEndianUnaligned) {
            len += (inOfs += byteArrayOfs);
            while (inOfs < len) {
                out[outOfs++] = Integer.reverseBytes(unsafe.getInt(in, inOfs));
                inOfs += 4;
            }
        } else if (bigEndian && (inOfs & 3) == 0) {
            len += (inOfs += byteArrayOfs);
            while (inOfs < len) {
                out[outOfs++] = unsafe.getInt(in, inOfs);
                inOfs += 4;
            }
        } else {
            len += inOfs;
            while (inOfs < len) {
                out[outOfs++] = in[inOfs + 3] & 0xFF | (in[inOfs + 2] & 0xFF) << 8 | (in[inOfs + 1] & 0xFF) << 16 | in[inOfs] << 24;
                inOfs += 4;
            }
        }
    }

    static void b2iBig64(byte[] in, int inOfs, int[] out) {
        if (inOfs < 0 || in.length - inOfs < 64 || out.length < 16) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (littleEndianUnaligned) {
            out[0] = Integer.reverseBytes(unsafe.getInt(in, inOfs += byteArrayOfs));
            out[1] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 4));
            out[2] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 8));
            out[3] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 12));
            out[4] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 16));
            out[5] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 20));
            out[6] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 24));
            out[7] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 28));
            out[8] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 32));
            out[9] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 36));
            out[10] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 40));
            out[11] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 44));
            out[12] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 48));
            out[13] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 52));
            out[14] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 56));
            out[15] = Integer.reverseBytes(unsafe.getInt(in, inOfs + 60));
        } else if (bigEndian && (inOfs & 3) == 0) {
            out[0] = unsafe.getInt(in, inOfs += byteArrayOfs);
            out[1] = unsafe.getInt(in, inOfs + 4);
            out[2] = unsafe.getInt(in, inOfs + 8);
            out[3] = unsafe.getInt(in, inOfs + 12);
            out[4] = unsafe.getInt(in, inOfs + 16);
            out[5] = unsafe.getInt(in, inOfs + 20);
            out[6] = unsafe.getInt(in, inOfs + 24);
            out[7] = unsafe.getInt(in, inOfs + 28);
            out[8] = unsafe.getInt(in, inOfs + 32);
            out[9] = unsafe.getInt(in, inOfs + 36);
            out[10] = unsafe.getInt(in, inOfs + 40);
            out[11] = unsafe.getInt(in, inOfs + 44);
            out[12] = unsafe.getInt(in, inOfs + 48);
            out[13] = unsafe.getInt(in, inOfs + 52);
            out[14] = unsafe.getInt(in, inOfs + 56);
            out[15] = unsafe.getInt(in, inOfs + 60);
        } else {
            ByteArrayAccess.b2iBig(in, inOfs, out, 0, 64);
        }
    }

    static void i2bBig(int[] in, int inOfs, byte[] out, int outOfs, int len) {
        if (inOfs < 0 || in.length - inOfs < len / 4 || outOfs < 0 || out.length - outOfs < len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (littleEndianUnaligned) {
            len += (outOfs += byteArrayOfs);
            while (outOfs < len) {
                unsafe.putInt(out, outOfs, Integer.reverseBytes(in[inOfs++]));
                outOfs += 4;
            }
        } else if (bigEndian && (outOfs & 3) == 0) {
            len += (outOfs += byteArrayOfs);
            while (outOfs < len) {
                unsafe.putInt(out, outOfs, in[inOfs++]);
                outOfs += 4;
            }
        } else {
            len += outOfs;
            while (outOfs < len) {
                int i = in[inOfs++];
                out[outOfs++] = (byte)(i >> 24);
                out[outOfs++] = (byte)(i >> 16);
                out[outOfs++] = (byte)(i >> 8);
                out[outOfs++] = (byte)i;
            }
        }
    }

    static void i2bBig4(int val, byte[] out, int outOfs) {
        if (outOfs < 0 || out.length - outOfs < 4) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (littleEndianUnaligned) {
            unsafe.putInt(out, byteArrayOfs + outOfs, Integer.reverseBytes(val));
        } else if (bigEndian && (outOfs & 3) == 0) {
            unsafe.putInt(out, byteArrayOfs + outOfs, val);
        } else {
            out[outOfs] = (byte)(val >> 24);
            out[outOfs + 1] = (byte)(val >> 16);
            out[outOfs + 2] = (byte)(val >> 8);
            out[outOfs + 3] = (byte)val;
        }
    }

    static void b2lBig(byte[] in, int inOfs, long[] out, int outOfs, int len) {
        if (inOfs < 0 || in.length - inOfs < len || outOfs < 0 || out.length - outOfs < len / 8) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (littleEndianUnaligned) {
            len += (inOfs += byteArrayOfs);
            while (inOfs < len) {
                out[outOfs++] = Long.reverseBytes(unsafe.getLong(in, inOfs));
                inOfs += 8;
            }
        } else if (bigEndian && (inOfs & 3) == 0) {
            len += (inOfs += byteArrayOfs);
            while (inOfs < len) {
                out[outOfs++] = (long)unsafe.getInt(in, inOfs) << 32 | (long)unsafe.getInt(in, inOfs + 4) & 0xFFFFFFFFL;
                inOfs += 8;
            }
        } else {
            len += inOfs;
            while (inOfs < len) {
                int i1 = in[inOfs + 3] & 0xFF | (in[inOfs + 2] & 0xFF) << 8 | (in[inOfs + 1] & 0xFF) << 16 | in[inOfs] << 24;
                int i2 = in[(inOfs += 4) + 3] & 0xFF | (in[inOfs + 2] & 0xFF) << 8 | (in[inOfs + 1] & 0xFF) << 16 | in[inOfs] << 24;
                out[outOfs++] = (long)i1 << 32 | (long)i2 & 0xFFFFFFFFL;
                inOfs += 4;
            }
        }
    }

    static void b2lBig128(byte[] in, int inOfs, long[] out) {
        if (inOfs < 0 || in.length - inOfs < 128 || out.length < 16) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (littleEndianUnaligned) {
            out[0] = Long.reverseBytes(unsafe.getLong(in, inOfs += byteArrayOfs));
            out[1] = Long.reverseBytes(unsafe.getLong(in, inOfs + 8));
            out[2] = Long.reverseBytes(unsafe.getLong(in, inOfs + 16));
            out[3] = Long.reverseBytes(unsafe.getLong(in, inOfs + 24));
            out[4] = Long.reverseBytes(unsafe.getLong(in, inOfs + 32));
            out[5] = Long.reverseBytes(unsafe.getLong(in, inOfs + 40));
            out[6] = Long.reverseBytes(unsafe.getLong(in, inOfs + 48));
            out[7] = Long.reverseBytes(unsafe.getLong(in, inOfs + 56));
            out[8] = Long.reverseBytes(unsafe.getLong(in, inOfs + 64));
            out[9] = Long.reverseBytes(unsafe.getLong(in, inOfs + 72));
            out[10] = Long.reverseBytes(unsafe.getLong(in, inOfs + 80));
            out[11] = Long.reverseBytes(unsafe.getLong(in, inOfs + 88));
            out[12] = Long.reverseBytes(unsafe.getLong(in, inOfs + 96));
            out[13] = Long.reverseBytes(unsafe.getLong(in, inOfs + 104));
            out[14] = Long.reverseBytes(unsafe.getLong(in, inOfs + 112));
            out[15] = Long.reverseBytes(unsafe.getLong(in, inOfs + 120));
        } else {
            ByteArrayAccess.b2lBig(in, inOfs, out, 0, 128);
        }
    }

    static void l2bBig(long[] in, int inOfs, byte[] out, int outOfs, int len) {
        if (inOfs < 0 || in.length - inOfs < len / 8 || outOfs < 0 || out.length - outOfs < len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (littleEndianUnaligned) {
            len += (outOfs += byteArrayOfs);
            while (outOfs < len) {
                unsafe.putLong(out, outOfs, Long.reverseBytes(in[inOfs++]));
                outOfs += 8;
            }
        } else {
            len += outOfs;
            while (outOfs < len) {
                long i = in[inOfs++];
                out[outOfs++] = (byte)(i >> 56);
                out[outOfs++] = (byte)(i >> 48);
                out[outOfs++] = (byte)(i >> 40);
                out[outOfs++] = (byte)(i >> 32);
                out[outOfs++] = (byte)(i >> 24);
                out[outOfs++] = (byte)(i >> 16);
                out[outOfs++] = (byte)(i >> 8);
                out[outOfs++] = (byte)i;
            }
        }
    }

    static void b2lLittle(byte[] in, int inOfs, long[] out, int outOfs, int len) {
        if (inOfs < 0 || in.length - inOfs < len || outOfs < 0 || out.length - outOfs < len / 8) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (littleEndianUnaligned) {
            len += (inOfs += byteArrayOfs);
            while (inOfs < len) {
                out[outOfs++] = unsafe.getLong(in, inOfs);
                inOfs += 8;
            }
        } else {
            len += inOfs;
            while (inOfs < len) {
                out[outOfs++] = (long)in[inOfs] & 0xFFL | ((long)in[inOfs + 1] & 0xFFL) << 8 | ((long)in[inOfs + 2] & 0xFFL) << 16 | ((long)in[inOfs + 3] & 0xFFL) << 24 | ((long)in[inOfs + 4] & 0xFFL) << 32 | ((long)in[inOfs + 5] & 0xFFL) << 40 | ((long)in[inOfs + 6] & 0xFFL) << 48 | ((long)in[inOfs + 7] & 0xFFL) << 56;
                inOfs += 8;
            }
        }
    }

    static void l2bLittle(long[] in, int inOfs, byte[] out, int outOfs, int len) {
        if (inOfs < 0 || in.length - inOfs < len / 8 || outOfs < 0 || out.length - outOfs < len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (littleEndianUnaligned) {
            len += (outOfs += byteArrayOfs);
            while (outOfs < len) {
                unsafe.putLong(out, outOfs, in[inOfs++]);
                outOfs += 8;
            }
        } else {
            len += outOfs;
            while (outOfs < len) {
                long i = in[inOfs++];
                out[outOfs++] = (byte)i;
                out[outOfs++] = (byte)(i >> 8);
                out[outOfs++] = (byte)(i >> 16);
                out[outOfs++] = (byte)(i >> 24);
                out[outOfs++] = (byte)(i >> 32);
                out[outOfs++] = (byte)(i >> 40);
                out[outOfs++] = (byte)(i >> 48);
                out[outOfs++] = (byte)(i >> 56);
            }
        }
    }

    static {
        Object unsafeObj = null;
        try {
            ClassLoader cLoader = ByteArrayAccess.class.getClassLoader();
            if (!VM.isSystemDomainLoader((ClassLoader)cLoader) && !cLoader.getClass().getName().startsWith("sun.misc.Launcher$ExtClassLoader")) {
                throw new SecurityException("Provider must be loaded by ExtClassLoader");
            }
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            unsafeObj = f.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException cLoader) {
            // empty catch block
        }
        unsafe = (Unsafe)unsafeObj;
        byteArrayOfs = unsafe.arrayBaseOffset(byte[].class);
        boolean scaleOK = unsafe.arrayIndexScale(byte[].class) == 1 && unsafe.arrayIndexScale(int[].class) == 4 && unsafe.arrayIndexScale(long[].class) == 8 && (byteArrayOfs & 3) == 0;
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        littleEndianUnaligned = scaleOK && ByteArrayAccess.unaligned() && byteOrder == ByteOrder.LITTLE_ENDIAN;
        bigEndian = scaleOK && byteOrder == ByteOrder.BIG_ENDIAN;
    }
}

