/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.widget;

import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.scijava.log.LogService;
import org.scijava.plugin.Plugin;
import org.scijava.ui.swing.widget.DocumentSizeFilter;
import org.scijava.ui.swing.widget.SwingInputWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.TextWidget;
import org.scijava.widget.WidgetModel;

@Plugin(type=InputWidget.class)
public class SwingTextWidget
extends SwingInputWidget<String>
implements DocumentListener,
TextWidget<JPanel> {
    private LogService log;
    private JTextComponent textComponent;

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateModel();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateModel();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateModel();
    }

    @Override
    public String getValue() {
        return this.textComponent.getText();
    }

    @Override
    public void set(WidgetModel model) {
        super.set(model);
        this.log = model.getContext().getService(LogService.class);
        int columns = model.getItem().getColumnCount();
        boolean addScrollPane = false;
        if (model.isStyle("text area")) {
            this.textComponent = new JTextArea("", 5, columns);
            addScrollPane = true;
        } else {
            this.textComponent = model.isStyle("password") ? new JPasswordField("", columns) : new JTextField("", columns);
        }
        this.setToolTip(this.textComponent);
        this.getComponent().add(addScrollPane ? new JScrollPane(this.textComponent) : this.textComponent);
        this.limitLength();
        this.textComponent.getDocument().addDocumentListener(this);
        this.refreshWidget();
    }

    @Override
    public boolean supports(WidgetModel model) {
        return super.supports(model) && model.isText() && !model.isMultipleChoice() && !model.isMessage();
    }

    private void limitLength() {
        if (!this.get().isCharacter()) {
            return;
        }
        boolean maxChars = true;
        Document doc = this.textComponent.getDocument();
        if (doc instanceof AbstractDocument) {
            DocumentSizeFilter docFilter = new DocumentSizeFilter(1);
            ((AbstractDocument)doc).setDocumentFilter(docFilter);
        } else if (this.log != null) {
            this.log.warn("Unknown document type: " + doc.getClass().getName());
        }
    }

    @Override
    public void doRefresh() {
        String text = this.get().getText();
        if (this.textComponent.getText().equals(text)) {
            return;
        }
        this.textComponent.setText(text);
    }
}

