/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.widget;

import java.io.IOException;
import java.util.Objects;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.scijava.log.LogService;
import org.scijava.platform.PlatformService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.swing.widget.SwingInputWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.MessageWidget;
import org.scijava.widget.WidgetModel;

@Plugin(type=InputWidget.class, priority=100.0)
public class SwingMessageWidget
extends SwingInputWidget<String>
implements MessageWidget<JPanel> {
    @Parameter
    private PlatformService platformService;
    @Parameter
    private LogService logService;
    private JEditorPane pane;
    private JEditorPane dummy;

    @Override
    public String getValue() {
        return null;
    }

    @Override
    public boolean isLabeled() {
        String l = this.get().getItem().getLabel();
        return l != null && !l.isEmpty();
    }

    @Override
    public boolean isMessage() {
        return true;
    }

    @Override
    public void set(WidgetModel model) {
        super.set(model);
        String text = model.getText();
        this.pane = new JEditorPane("text/html", text);
        this.pane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.pane.setEditable(false);
        this.pane.setOpaque(false);
        this.pane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hle) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                    try {
                        SwingMessageWidget.this.platformService.open(hle.getURL());
                    }
                    catch (IOException exc) {
                        SwingMessageWidget.this.logService.error("Error while opening " + hle.getURL(), exc);
                    }
                }
            }
        });
        this.getComponent().add(this.pane);
    }

    @Override
    public boolean supports(WidgetModel model) {
        return super.supports(model) && model.isMessage();
    }

    @Override
    public void doRefresh() {
        String text = this.get().getText();
        if (!Objects.equals(this.htmlify(text), this.pane.getText())) {
            this.pane.setText(text);
        }
    }

    private String htmlify(String text) {
        if (text == null) {
            return null;
        }
        if (this.dummy == null) {
            this.dummy = new JEditorPane("text/html", "");
        }
        this.dummy.setText(text);
        return this.dummy.getText();
    }
}

