/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.widget;

import javax.swing.JPanel;
import org.scijava.module.Module;
import org.scijava.module.process.PreprocessorPlugin;
import org.scijava.plugin.Plugin;
import org.scijava.ui.AbstractInputHarvesterPlugin;
import org.scijava.ui.swing.SwingDialog;
import org.scijava.ui.swing.widget.SwingInputPanel;
import org.scijava.widget.InputPanel;

@Plugin(type=PreprocessorPlugin.class, priority=-10000.0)
public class SwingInputHarvester
extends AbstractInputHarvesterPlugin<JPanel, JPanel> {
    public SwingInputPanel createInputPanel() {
        return new SwingInputPanel();
    }

    @Override
    public boolean harvestInputs(InputPanel<JPanel, JPanel> inputPanel, Module module) {
        JPanel pane = (JPanel)inputPanel.getComponent();
        String title = module.getInfo().getTitle();
        boolean modal = !module.getInfo().isInteractive();
        boolean allowCancel = module.getInfo().canCancel();
        int optionType = allowCancel ? 2 : -1;
        int messageType = inputPanel.isMessageOnly() ? (allowCancel ? 3 : 1) : -1;
        boolean doScrollBars = messageType == -1;
        SwingDialog dialog = new SwingDialog(pane, optionType, messageType, doScrollBars);
        dialog.setTitle(title);
        dialog.setModal(modal);
        int rval = dialog.show();
        return rval == 0;
    }

    @Override
    protected String getUI() {
        return "swing";
    }
}

