/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.widget;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.UIService;
import org.scijava.ui.swing.widget.SwingInputWidget;
import org.scijava.widget.FileWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.WidgetModel;

@Plugin(type=InputWidget.class)
public class SwingFileWidget
extends SwingInputWidget<File>
implements FileWidget<JPanel>,
ActionListener,
DocumentListener {
    @Parameter
    private UIService uiService;
    private JTextField path;
    private JButton browse;

    @Override
    public File getValue() {
        String text = this.path.getText();
        return text.isEmpty() ? null : new File(text);
    }

    @Override
    public void set(WidgetModel model) {
        super.set(model);
        this.path = new JTextField(16);
        this.path.setDragEnabled(true);
        String style = model.getItem().getWidgetStyle();
        this.path.setTransferHandler(new FileTransferHandler(style));
        this.setToolTip(this.path);
        this.getComponent().add(this.path);
        this.path.getDocument().addDocumentListener(this);
        this.getComponent().add(Box.createHorizontalStrut(3));
        this.browse = new JButton("Browse");
        this.setToolTip(this.browse);
        this.getComponent().add(this.browse);
        this.browse.addActionListener(this);
        this.refreshWidget();
    }

    @Override
    public boolean supports(WidgetModel model) {
        return super.supports(model) && model.isType(File.class);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        WidgetModel model;
        String style;
        File file = new File(this.path.getText());
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        if ((file = this.uiService.chooseFile(file, style = (model = this.get()).isStyle("directory") ? "directory" : (model.isStyle("save") ? "save" : "open"))) == null) {
            return;
        }
        this.path.setText(file.getAbsolutePath());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateModel();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateModel();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateModel();
    }

    @Override
    public void doRefresh() {
        String text = this.get().getText();
        if (text.equals(this.path.getText())) {
            return;
        }
        this.path.setText(text);
    }

    public static FileFilter createFileFilter(String widgetStyle) {
        List<String> filesOnlyStyles = Arrays.asList("open", "save", "files");
        List<String> dirsOnlyStyles = Arrays.asList("directory", "directories");
        List<String> filesAndDirsStyles = Arrays.asList("both");
        final ArrayList<String> exts = new ArrayList<String>();
        boolean filesOnly = false;
        boolean dirsOnly = false;
        boolean filesAndDirs = false;
        if (widgetStyle != null) {
            for (String token : widgetStyle.split(",")) {
                if (filesOnlyStyles.contains(token)) {
                    filesOnly = true;
                }
                if (dirsOnlyStyles.contains(token)) {
                    dirsOnly = true;
                }
                if (filesAndDirsStyles.contains(token)) {
                    filesAndDirs = true;
                }
                if (!token.startsWith("extensions")) continue;
                String extensions = token.split(":")[1];
                for (String ext : extensions.split("/")) {
                    exts.add(ext);
                }
            }
        }
        boolean defaultBehavior = !filesOnly && !dirsOnly && !filesAndDirs;
        final boolean rejectFiles = dirsOnly;
        final boolean rejectDirs = filesOnly || defaultBehavior;
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isFile() && rejectFiles) {
                    return false;
                }
                if (pathname.isDirectory() && rejectDirs) {
                    return false;
                }
                if (exts.isEmpty()) {
                    return true;
                }
                if (pathname.isDirectory()) {
                    return true;
                }
                for (String ext : exts) {
                    if (!pathname.getName().endsWith("." + ext)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return SwingFileWidget.formatFileFilterExtensions(exts);
            }
        };
    }

    static String formatFileFilterExtensions(List<String> extensions) {
        ArrayList<String> extsWithPrefix = new ArrayList<String>();
        for (String extension : extensions) {
            extsWithPrefix.add("*." + extension);
        }
        StringJoiner joiner = new StringJoiner(";");
        extsWithPrefix.forEach(joiner::add);
        return joiner.toString();
    }

    public static boolean hasFiles(TransferHandler.TransferSupport support) {
        for (DataFlavor flavor : support.getDataFlavors()) {
            if (!flavor.isFlavorJavaFileListType()) continue;
            return true;
        }
        return false;
    }

    public static List<File> getFiles(TransferHandler.TransferSupport support) {
        try {
            Object files = support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            if (!(files instanceof List)) {
                return null;
            }
            List list = (List)files;
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) instanceof File) continue;
                return null;
            }
            List listOfFiles = list;
            return listOfFiles;
        }
        catch (UnsupportedFlavorException | IOException exc) {
            return null;
        }
    }

    public static String getText(TransferHandler.TransferSupport support) {
        try {
            return (String)support.getTransferable().getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException | IOException exc) {
            return "";
        }
    }

    public static List<File> filterFiles(List<File> list, FileFilter filter) {
        return list.stream().filter(filter::accept).collect(Collectors.toList());
    }

    private class FileTransferHandler
    extends TransferHandler {
        private final String style;

        public FileTransferHandler(String style) {
            this.style = style;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!SwingFileWidget.hasFiles(support)) {
                return false;
            }
            try {
                List<File> allFiles = SwingFileWidget.getFiles(support);
                if (allFiles == null || allFiles.size() != 1) {
                    return false;
                }
                FileFilter filter = SwingFileWidget.createFileFilter(this.style);
                List<File> files = SwingFileWidget.filterFiles(allFiles, filter);
                return files.size() == 1;
            }
            catch (InvalidDnDOperationException exc) {
                return true;
            }
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            List<File> files = SwingFileWidget.getFiles(support);
            if (files == null) {
                String text = SwingFileWidget.getText(support);
                if (text.equals("")) {
                    return false;
                }
                ((JTextField)support.getComponent()).setText(text);
                return true;
            }
            if (files.size() != 1) {
                return false;
            }
            File file = files.get(0);
            ((JTextField)support.getComponent()).setText(file.getAbsolutePath());
            return true;
        }
    }
}

