/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.widget;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.sourceforge.jdatepicker.DateModel;
import net.sourceforge.jdatepicker.impl.JDatePanelImpl;
import net.sourceforge.jdatepicker.impl.JDatePickerImpl;
import net.sourceforge.jdatepicker.impl.UtilDateModel;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.swing.widget.SwingInputWidget;
import org.scijava.widget.DateWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.WidgetModel;

@Plugin(type=InputWidget.class)
public class SwingDateWidget
extends SwingInputWidget<Date>
implements DateWidget<JPanel>,
ActionListener {
    @Parameter
    private LogService log;
    private UtilDateModel dateModel;

    @Override
    public Date getValue() {
        return this.dateModel == null ? null : (Date)this.dateModel.getValue();
    }

    @Override
    public void set(WidgetModel model) {
        super.set(model);
        this.dateModel = new UtilDateModel();
        JDatePickerImpl datePicker = new JDatePickerImpl(new JDatePanelImpl((DateModel)this.dateModel), null);
        this.setToolTip((JComponent)datePicker);
        this.getComponent().add((Component)datePicker);
        datePicker.addActionListener((ActionListener)this);
        this.refreshWidget();
    }

    @Override
    public boolean supports(WidgetModel model) {
        return super.supports(model) && model.isType(Date.class);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateModel();
    }

    @Override
    public void doRefresh() {
        Date date = (Date)this.get().getValue();
        this.dateModel.setValue((Object)date);
    }
}

