/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.widget;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.swing.SpinnerNumberModel;
import org.scijava.ui.swing.widget.SpinnerBigDecimalModel;
import org.scijava.ui.swing.widget.SpinnerBigIntegerModel;
import org.scijava.util.NumberUtils;

public class SpinnerNumberModelFactory {
    public SpinnerNumberModel createModel(Number value, Number min, Number max, Number stepSize) {
        Class<?> c = value.getClass();
        if (BigInteger.class.isAssignableFrom(c)) {
            BigInteger biValue = (BigInteger)value;
            BigInteger biMin = (BigInteger)min;
            BigInteger biMax = (BigInteger)max;
            BigInteger biStepSize = (BigInteger)stepSize;
            return new SpinnerBigIntegerModel(biValue, biMin, biMax, biStepSize);
        }
        if (BigDecimal.class.isAssignableFrom(c)) {
            BigDecimal bdValue = (BigDecimal)value;
            BigDecimal bdMin = (BigDecimal)min;
            BigDecimal bdMax = (BigDecimal)max;
            BigDecimal bdStepSize = (BigDecimal)stepSize;
            return new SpinnerBigDecimalModel(bdValue, bdMin, bdMax, bdStepSize);
        }
        Comparable cMin = (Comparable)((Object)min);
        Comparable cMax = (Comparable)((Object)max);
        Number clampedValue = NumberUtils.clampToRange(value.getClass(), value, min, max);
        return new SpinnerNumberModel(clampedValue, cMin, cMax, stepSize);
    }
}

