/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.viewer.text;

import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.scijava.app.StatusService;
import org.scijava.display.TextDisplay;
import org.scijava.log.LogService;
import org.scijava.platform.PlatformService;
import org.scijava.plugin.Parameter;
import org.scijava.ui.viewer.DisplayWindow;
import org.scijava.ui.viewer.text.TextDisplayPanel;

public class SwingTextDisplayPanel
extends JScrollPane
implements TextDisplayPanel,
HyperlinkListener {
    private final DisplayWindow window;
    private final TextDisplay display;
    private final JEditorPane textArea;
    @Parameter
    private StatusService statusService;
    @Parameter(required=false)
    private PlatformService platformService;
    @Parameter(required=false)
    private LogService log;

    public SwingTextDisplayPanel(TextDisplay display, DisplayWindow window) {
        display.getContext().inject(this);
        this.display = display;
        this.window = window;
        this.textArea = new JEditorPane();
        this.textArea.setPreferredSize(new Dimension(600, 500));
        this.textArea.setEditable(false);
        Font font = new Font("Monospaced", 0, this.textArea.getFont().getSize());
        this.textArea.setFont(font);
        this.textArea.addHyperlinkListener(this);
        this.setViewportView(this.textArea);
        window.setContent(this);
    }

    @Override
    public void append(String text) {
        this.display.add(text);
    }

    @Override
    public void clear() {
        this.display.clear();
    }

    @Override
    public TextDisplay getDisplay() {
        return this.display;
    }

    @Override
    public DisplayWindow getWindow() {
        return this.window;
    }

    @Override
    public void redoLayout() {
    }

    @Override
    public void setLabel(String s) {
    }

    @Override
    public void redraw() {
        StringBuffer targetText = new StringBuffer();
        for (Object line : this.display) {
            targetText.append(line.toString() + "\n");
        }
        String text = targetText.toString();
        boolean html = text.startsWith("<html>");
        this.textArea.setContentType(html ? "text/html" : "text/plain");
        this.textArea.setText(text);
        this.textArea.setCaretPosition(0);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            this.hyperlinkStatus(e.getURL());
        } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.hyperlinkStatus(null);
        } else if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.hyperlinkActivate(e.getURL());
        }
    }

    private void hyperlinkActivate(URL url) {
        block3: {
            if (this.platformService == null) {
                return;
            }
            try {
                this.platformService.open(url);
            }
            catch (IOException exc) {
                if (this.log == null) break block3;
                this.log.error(exc);
            }
        }
    }

    private void hyperlinkStatus(URL url) {
        if (url == null) {
            this.statusService.clearStatus();
        } else {
            this.statusService.showStatus(url.toString());
        }
    }
}

