/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.viewer;

import java.awt.BorderLayout;
import javax.swing.JPanel;
import org.scijava.display.Display;
import org.scijava.display.event.DisplayDeletedEvent;
import org.scijava.object.ObjectService;
import org.scijava.plugin.Parameter;
import org.scijava.ui.UserInterface;
import org.scijava.ui.swing.SwingUI;
import org.scijava.ui.viewer.AbstractDisplayViewer;
import org.scijava.ui.viewer.DisplayPanel;
import org.scijava.ui.viewer.DisplayWindow;

public abstract class EasySwingDisplayViewer<T>
extends AbstractDisplayViewer<T> {
    private final Class<T> classOfObject;
    @Parameter
    ObjectService objectService;

    protected EasySwingDisplayViewer(Class<T> classOfObject) {
        this.classOfObject = classOfObject;
    }

    @Override
    public boolean isCompatible(UserInterface ui) {
        return ui instanceof SwingUI;
    }

    @Override
    public boolean canView(Display<?> d) {
        Object object = d.get(0);
        if (!this.classOfObject.isInstance(object)) {
            return false;
        }
        Object value = object;
        return this.canView(value);
    }

    protected abstract boolean canView(T var1);

    protected abstract void redoLayout();

    protected abstract void setLabel(String var1);

    protected abstract void redraw();

    protected abstract JPanel createDisplayPanel(T var1);

    @Override
    public void onDisplayDeletedEvent(DisplayDeletedEvent e) {
        super.onDisplayDeletedEvent(e);
        this.objectService.removeObject(this.getDisplay().get(0));
    }

    @Override
    public void view(DisplayWindow w, Display<?> d) {
        this.objectService.addObject(d.get(0));
        super.view(w, d);
        JPanel content = this.createDisplayPanel(this.getDisplay().get(0));
        this.setPanel(new SwingDisplayPanel(w, d, this, content));
    }

    public static class SwingDisplayPanel
    extends JPanel
    implements DisplayPanel {
        private final EasySwingDisplayViewer<?> viewer;
        private final DisplayWindow window;
        private final Display<?> display;

        public SwingDisplayPanel(DisplayWindow window, Display<?> display, EasySwingDisplayViewer<?> viewer, JPanel panel) {
            this.window = window;
            this.display = display;
            this.viewer = viewer;
            window.setContent(this);
            this.setLayout(new BorderLayout());
            this.add(panel);
        }

        @Override
        public Display<?> getDisplay() {
            return this.display;
        }

        @Override
        public DisplayWindow getWindow() {
            return this.window;
        }

        @Override
        public void redoLayout() {
            this.viewer.redoLayout();
        }

        @Override
        public void setLabel(String s) {
            this.viewer.setLabel(s);
        }

        @Override
        public void redraw() {
            this.viewer.redraw();
        }
    }
}

