/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.sdi;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.scijava.display.Display;
import org.scijava.event.EventService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.DialogPrompt;
import org.scijava.ui.UserInterface;
import org.scijava.ui.awt.AWTDropTargetEventDispatcher;
import org.scijava.ui.awt.AWTInputEventDispatcher;
import org.scijava.ui.awt.AWTWindowEventDispatcher;
import org.scijava.ui.swing.AbstractSwingUI;
import org.scijava.ui.swing.SwingApplicationFrame;
import org.scijava.ui.swing.console.SwingConsolePane;
import org.scijava.ui.swing.sdi.SwingDialogPrompt;
import org.scijava.ui.swing.viewer.SwingDisplayWindow;

@Plugin(type=UserInterface.class, name="swing")
public class SwingSDIUI
extends AbstractSwingUI {
    @Parameter
    private EventService eventService;

    @Override
    public SwingDisplayWindow createDisplayWindow(Display<?> display) {
        return SwingSDIUI.createDisplayWindow(display, this.eventService);
    }

    @Override
    public DialogPrompt dialogPrompt(String message, String title, DialogPrompt.MessageType msg, DialogPrompt.OptionType option) {
        return new SwingDialogPrompt(message, title, msg, option);
    }

    public static SwingDisplayWindow createDisplayWindow(Display<?> display, EventService eventService) {
        SwingDisplayWindow displayWindow = new SwingDisplayWindow();
        new AWTInputEventDispatcher(display).register((Component)displayWindow, true, false);
        new AWTWindowEventDispatcher(display).register((Window)displayWindow);
        new AWTDropTargetEventDispatcher(display, eventService);
        return displayWindow;
    }

    @Override
    protected void setupAppFrame() {
        SwingApplicationFrame appFrame = this.getApplicationFrame();
        JPanel pane = new JPanel();
        appFrame.setContentPane(pane);
        pane.setLayout(new BorderLayout());
    }

    @Override
    protected void setupConsole() {
        SwingConsolePane cPane = this.getConsolePane();
        if (cPane == null) {
            return;
        }
        JFrame frame = new JFrame("Console");
        frame.setDefaultCloseOperation(2);
        frame.setContentPane(cPane.getComponent());
        frame.setJMenuBar(this.createConsoleMenu());
        frame.pack();
        cPane.setWindow(frame);
    }
}

