/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.plot.io;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import org.jfree.chart.JFreeChart;
import org.jfree.graphics2d.svg.SVGGraphics2D;
import org.jfree.graphics2d.svg.SVGUtils;
import org.scijava.convert.ConvertService;
import org.scijava.io.AbstractIOPlugin;
import org.scijava.io.IOPlugin;
import org.scijava.plot.Plot;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=IOPlugin.class)
public class PlotToSvgIOPlugin
extends AbstractIOPlugin<Plot> {
    @Parameter
    ConvertService convertService;

    @Override
    public boolean supportsOpen(String source) {
        return false;
    }

    @Override
    public boolean supportsSave(String destination) {
        return destination.endsWith(".svg");
    }

    @Override
    public boolean supportsSave(Object data, String destination) {
        return this.supportsSave(destination) && data instanceof Plot && this.convertService.supports(data, JFreeChart.class);
    }

    @Override
    public Plot open(String source) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void save(Plot data, String destination) throws IOException {
        if (!this.supportsSave((Object)data, destination)) {
            throw new IllegalArgumentException();
        }
        JFreeChart chart = this.convertService.convert((Object)data, JFreeChart.class);
        SVGGraphics2D g = new SVGGraphics2D(data.getPreferredWidth(), data.getPreferredWidth());
        chart.draw((Graphics2D)g, (Rectangle2D)new Rectangle(0, 0, g.getWidth(), g.getHeight()));
        SVGUtils.writeToSVG((File)new File(destination), (String)g.getSVGElement());
    }

    @Override
    public Class<Plot> getDataType() {
        return Plot.class;
    }
}

