/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.mdi;

import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.scijava.display.Display;
import org.scijava.display.event.window.WinActivatedEvent;
import org.scijava.display.event.window.WinClosedEvent;
import org.scijava.display.event.window.WinClosingEvent;
import org.scijava.display.event.window.WinDeactivatedEvent;
import org.scijava.display.event.window.WinDeiconifiedEvent;
import org.scijava.display.event.window.WinIconifiedEvent;
import org.scijava.display.event.window.WinOpenedEvent;
import org.scijava.event.EventService;

public class InternalFrameEventDispatcher
implements InternalFrameListener {
    private final Display<?> display;
    private final EventService eventService;

    public InternalFrameEventDispatcher(Display<?> display) {
        this.display = display;
        this.eventService = display.getContext().getService(EventService.class);
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
        JInternalFrame window = e.getInternalFrame();
        this.eventService.publish(new WinActivatedEvent(this.display, window));
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
        JInternalFrame window = e.getInternalFrame();
        this.eventService.publish(new WinClosedEvent(this.display, window));
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        JInternalFrame window = e.getInternalFrame();
        this.eventService.publish(new WinClosingEvent(this.display, window));
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
        JInternalFrame window = e.getInternalFrame();
        this.eventService.publish(new WinDeactivatedEvent(this.display, window));
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
        JInternalFrame window = e.getInternalFrame();
        this.eventService.publish(new WinDeiconifiedEvent(this.display, window));
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
        JInternalFrame window = e.getInternalFrame();
        this.eventService.publish(new WinIconifiedEvent(this.display, window));
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
        JInternalFrame window = e.getInternalFrame();
        this.eventService.publish(new WinOpenedEvent(this.display, window));
    }
}

