/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.laf;

import com.formdev.flatlaf.FlatDarculaLaf;
import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.prefs.PrefService;
import org.scijava.service.AbstractService;
import org.scijava.service.SciJavaService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class SwingLookAndFeelService
extends AbstractService
implements SciJavaService {
    private static final String LAF_PREF_KEY = "lookAndFeel";
    @Parameter(required=false)
    private PrefService prefs;
    @Parameter(required=false)
    private LogService log;
    private Map<String, Supplier<LookAndFeel>> factories;

    public void initLookAndFeel() {
        block2: {
            String lafPref = this.prefs == null ? null : this.prefs.get(this.getClass(), LAF_PREF_KEY);
            String laf = lafPref == null ? "FlatLaf Light" : lafPref;
            try {
                this.setLookAndFeel(laf);
            }
            catch (IllegalArgumentException exc) {
                if (this.log == null) break block2;
                this.log.warn("Could not set Look & Feel '" + laf + "'");
                this.log.debug(exc);
            }
        }
    }

    public void setLookAndFeel(String lookAndFeel) {
        if (this.factories == null) {
            this.initFactories();
        }
        if (this.factories.containsKey(lookAndFeel)) {
            LookAndFeel laf = this.factories.get(lookAndFeel).get();
            try {
                UIManager.setLookAndFeel(laf);
            }
            catch (UnsupportedLookAndFeelException exc) {
                this.attemptToRecover();
                throw new IllegalArgumentException("Invalid look and feel: " + lookAndFeel, exc);
            }
        }
        UIManager.LookAndFeelInfo info = this.getLookAndFeel(lookAndFeel);
        String className = info == null ? lookAndFeel : info.getClassName();
        try {
            UIManager.setLookAndFeel(className);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exc) {
            this.attemptToRecover();
            throw new IllegalArgumentException("Invalid look and feel: " + lookAndFeel, exc);
        }
        FlatLaf.updateUI();
        if (this.prefs != null) {
            this.prefs.put(this.getClass(), LAF_PREF_KEY, lookAndFeel);
        }
    }

    public UIManager.LookAndFeelInfo getLookAndFeel(String name) {
        return this.find(this.getLookAndFeels(), name);
    }

    public UIManager.LookAndFeelInfo[] getLookAndFeels() {
        UIManager.LookAndFeelInfo[] infos = UIManager.getInstalledLookAndFeels();
        if (this.find(infos, "FlatLaf Light") == null) {
            FlatLightLaf.installLafInfo();
        }
        if (this.find(infos, "FlatLaf Dark") == null) {
            FlatDarkLaf.installLafInfo();
        }
        if (this.find(infos, "FlatLaf Darcula") == null) {
            FlatDarculaLaf.installLafInfo();
        }
        if (this.find(infos, "FlatLaf IntelliJ") == null) {
            FlatIntelliJLaf.installLafInfo();
        }
        return UIManager.getInstalledLookAndFeels();
    }

    private UIManager.LookAndFeelInfo find(UIManager.LookAndFeelInfo[] infos, String name) {
        return Arrays.stream(infos).filter(info -> info.getName().equals(name)).findFirst().orElseGet(() -> null);
    }

    private void attemptToRecover() {
        FlatLaf.revalidateAndRepaintAllFramesAndDialogs();
    }

    private synchronized void initFactories() {
        if (this.factories != null) {
            return;
        }
        HashMap<String, Supplier<LookAndFeel>> m = new HashMap<String, Supplier<LookAndFeel>>();
        m.put("FlatLaf Light", FlatLightLaf::new);
        m.put("FlatLaf Dark", FlatDarkLaf::new);
        m.put("FlatLaf Darcula", FlatDarculaLaf::new);
        m.put("FlatLaf IntelliJ", FlatIntelliJLaf::new);
        this.factories = m;
    }
}

