/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.commands;

import org.scijava.app.AppService;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleService;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.swing.SwingDialog;
import org.scijava.ui.swing.commands.CommandFinderPanel;

@Plugin(type=Command.class, menu={@Menu(label="Plugins", weight=5.0, mnemonic=117), @Menu(label="Utilities"), @Menu(label="Find Commands...", accelerator="^L")}, attrs={@Attr(name="no-legacy")})
public class CommandFinder
extends ContextCommand {
    @Parameter
    private ModuleService moduleService;
    @Parameter
    private AppService appService;

    @Override
    public void run() {
        String baseDir = this.appService.getApp().getBaseDirectory().getAbsolutePath();
        CommandFinderPanel commandFinderPanel = new CommandFinderPanel(this.moduleService, baseDir);
        SwingDialog dialog = new SwingDialog(commandFinderPanel, 2, -1, false);
        dialog.setFocus(commandFinderPanel.getSearchField());
        dialog.setTitle("Find Commands");
        int rval = dialog.show();
        if (rval != 0) {
            return;
        }
        ModuleInfo info = commandFinderPanel.getCommand();
        if (info == null) {
            return;
        }
        this.moduleService.run(info, true, new Object[0]);
    }
}

