/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.BevelBorder;
import org.scijava.Context;
import org.scijava.app.AppService;
import org.scijava.app.StatusService;
import org.scijava.app.event.StatusEvent;
import org.scijava.event.EventHandler;
import org.scijava.options.OptionsService;
import org.scijava.plugin.Parameter;
import org.scijava.ui.DialogPrompt;
import org.scijava.ui.StatusBar;
import org.scijava.ui.UIService;
import org.scijava.ui.awt.AWTInputEventDispatcher;
import org.scijava.ui.swing.task.SwingTaskMonitorComponent;

public class SwingStatusBar
extends JPanel
implements StatusBar {
    private final JLabel statusText;
    private final JProgressBar progressBar;
    @Parameter
    private OptionsService optionsService;
    @Parameter
    private StatusService statusService;
    @Parameter
    private AppService appService;
    @Parameter
    private UIService uiService;

    public SwingStatusBar(Context context) {
        context.inject(this);
        this.statusText = new JLabel(this.appService.getApp().getInfo(false));
        this.statusText.setBorder(new BevelBorder(1));
        this.progressBar = new JProgressBar();
        this.progressBar.setVisible(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.statusText, "Center");
        this.add((Component)this.progressBar, "West");
        JComponent progress = new SwingTaskMonitorComponent(context, true, true, 300, false).getComponent();
        int h = this.getPreferredSize().height;
        progress.setPreferredSize(new Dimension(h, h));
        this.add((Component)progress, "East");
    }

    public void addEventDispatcher(AWTInputEventDispatcher dispatcher) {
        dispatcher.register((Component)this, false, true);
    }

    @Override
    public void setStatus(String message) {
        if (message == null) {
            return;
        }
        String text = message.isEmpty() ? " " : message;
        this.statusText.setText(text);
    }

    @Override
    public void setProgress(int val, int max) {
        if (max < 0) {
            this.progressBar.setVisible(false);
            return;
        }
        if (val >= 0 && val < max) {
            this.progressBar.setValue(val);
            this.progressBar.setMaximum(max);
            this.progressBar.setVisible(true);
        } else {
            this.progressBar.setVisible(false);
        }
    }

    @EventHandler
    protected void onEvent(StatusEvent event) {
        if (event.isWarning()) {
            String message = event.getStatusMessage();
            if (message != null && !message.isEmpty()) {
                this.uiService.showDialog(message, DialogPrompt.MessageType.WARNING_MESSAGE);
            }
        } else {
            int val = event.getProgressValue();
            int max = event.getProgressMaximum();
            String message = this.uiService.getStatusMessage(event);
            this.setStatus(message);
            this.setProgress(val, max);
        }
    }
}

